/*
 * Decompiled with CFR 0.152.
 */
package amoebaTracker2works2;

import amoebaTracker2works2.ShortPoint;
import java.io.Serializable;

public class DoublePoint
implements Cloneable,
Serializable {
    public double x;
    public double y;

    public DoublePoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public DoublePoint clone() {
        return new DoublePoint(this.x, this.y);
    }

    public boolean equals(DoublePoint o) {
        return this.x == o.x && this.y == o.y;
    }

    public double dotProduct(double x2, double y2) {
        return this.x * x2 + this.y * y2;
    }

    public double dotProduct(DoublePoint dp) {
        double x2 = dp.x;
        double y2 = dp.y;
        return this.x * x2 + this.y * y2;
    }

    public double getAngleTo(DoublePoint dp) {
        double dot = this.dotProduct(dp);
        return Math.acos(dot / (dp.magnitude() * this.magnitude()));
    }

    public double getAngleFromRightTo(DoublePoint dp) {
        DoublePoint right = new DoublePoint(1.0, 0.0);
        DoublePoint toPoint = dp.minus(this);
        double dot = right.dotProduct(toPoint);
        double theta = Math.acos(dot / toPoint.magnitude());
        if (toPoint.y < 0.0) {
            return Math.PI * 2 - theta;
        }
        return theta;
    }

    public double crossProduct(double x2, double y2) {
        return this.x * y2 - this.y * x2;
    }

    public double crossProduct(DoublePoint dp) {
        double x2 = dp.x;
        double y2 = dp.y;
        return this.x * y2 - this.y * x2;
    }

    public DoublePoint plus(DoublePoint dp) {
        return new DoublePoint(this.x + dp.x, this.y + dp.y);
    }

    public void add(DoublePoint dp) {
        this.x += dp.x;
        this.y += dp.y;
    }

    public void subtract(DoublePoint dp) {
        this.x -= dp.x;
        this.y -= dp.y;
    }

    public void multiply(double f) {
        this.x *= f;
        this.y *= f;
    }

    public DoublePoint minus(DoublePoint dp) {
        return new DoublePoint(this.x - dp.x, this.y - dp.y);
    }

    public DoublePoint scale(double d) {
        return new DoublePoint(this.x * d, this.y * d);
    }

    public DoublePoint rotate(double angle) {
        return new DoublePoint(this.x * Math.cos(angle) - this.y * Math.sin(angle), this.x * Math.sin(angle) + this.y * Math.cos(angle));
    }

    public double distanceTo(DoublePoint dp) {
        return Math.sqrt((dp.x - this.x) * (dp.x - this.x) + (dp.y - this.y) * (dp.y - this.y));
    }

    public double distanceTo(ShortPoint dp) {
        return Math.sqrt(((double)dp.x - this.x) * ((double)dp.x - this.x) + ((double)dp.y - this.y) * ((double)dp.y - this.y));
    }

    public double squaredDistance(DoublePoint dp) {
        if (dp == null) {
            return 0.0;
        }
        return (dp.x - this.x) * (dp.x - this.x) + (dp.y - this.y) * (dp.y - this.y);
    }

    public double distanceTo(double x2, double y2) {
        return Math.sqrt((x2 - this.x) * (x2 - this.x) + (y2 - this.y) * (y2 - this.y));
    }

    public double squaredDistance(double x2, double y2) {
        return (x2 - this.x) * (x2 - this.x) + (y2 - this.y) * (y2 - this.y);
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public DoublePoint normalized() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new DoublePoint(0.0, 0.0);
        }
        double x2 = this.x / mag;
        double y2 = this.y / mag;
        return new DoublePoint(x2, y2);
    }

    public DoublePoint normal() {
        return new DoublePoint(-this.y, this.x);
    }

    public String toString() {
        return String.format("(%3.3f,%3.3f)", this.x, this.y);
    }

    public static DoublePoint getORIGIN() {
        return new DoublePoint(0.0, 0.0);
    }
}

