/*
 * Decompiled with CFR 0.152.
 */
package amoebaTracker2works2;

import amoebaTracker2works2.Cell;
import amoebaTracker2works2.DoublePoint;
import amoebaTracker2works2.ShortPoint;
import amoebaTracker2works2.Waypoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class Static {
    public static final boolean visualizingPhysics = false;
    public static final int max = 65535;
    public static final int gridSize = 1;
    public static final double thresholdMultiplier = 1.65;
    public static final int integrationSteps = 100;
    public static final int holeFillSteps = 5;
    public static final int minimumLongevity = 10;
    public static final String newline = System.getProperty("line.separator");
    public static final int Border = 25;
    public static final int nearbyRefreshRate = 20;
    public static final double maxNeighborDistance = 50.0;
    public static final double maxWhitespotDistance = 20.0;

    public static double minimumDistance(LinkedList<ShortPoint> l1, LinkedList<ShortPoint> l2) {
        double shortest = Double.MAX_VALUE;
        for (ShortPoint s1 : l1) {
            for (ShortPoint s2 : l2) {
                double d = (s1.x - s2.x) * (s1.x - s2.x) + (s1.y - s2.y) * (s1.y - s2.y);
                if (!(d < shortest)) continue;
                shortest = d;
            }
        }
        return Math.sqrt(shortest);
    }

    public static double probability(double distance, int area, int target_area, int target_persistence, int frames_mistracked) {
        double kd = 1.0;
        double ka = 5.0;
        double kp = 0.2;
        double farea = ((double)Math.abs(area - target_area) + 2.0) / (double)(area + 2);
        farea *= farea;
        return Math.exp(-(Math.max(0.0, distance - Math.sqrt(area) / 3.0 - Math.sqrt(target_area) / 3.0) * kd + farea * ka + (double)Math.abs(target_persistence - frames_mistracked) * kp));
    }

    public static double average(double[] s) {
        double u = 0.0;
        int i = 0;
        while (i < s.length) {
            u += s[i];
            ++i;
        }
        return u / (double)s.length;
    }

    public static LinkedList<ShortPoint> outline(LinkedList<ShortPoint> pixels) {
        short s;
        short s2;
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        if (pixels == null) {
            return new LinkedList<ShortPoint>();
        }
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixels) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        ShortPoint[][] map = new ShortPoint[right - s + 3][bottom - s2 + 3];
        Iterator iterator = pixels.iterator();
        while (iterator.hasNext()) {
            ShortPoint dp;
            map[dp.x - s + 1][dp.y - s2 + 1] = dp = (ShortPoint)iterator.next();
        }
        int i = 1;
        while (i < map.length - 1) {
            int j = 1;
            while (j < map[i].length - 1) {
                if (map[i][j] != null) {
                    int count = 0;
                    if (map[i - 1][j] != null) {
                        ++count;
                    }
                    if (map[i + 1][j] != null) {
                        ++count;
                    }
                    if (map[i][j - 1] != null) {
                        ++count;
                    }
                    if (map[i][j + 1] != null) {
                        ++count;
                    }
                    if (count < 4) {
                        result.add(map[i][j]);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static LinkedList<ShortPoint> shrinkWrap(LinkedList<ShortPoint> pixels) {
        int i;
        int j;
        short s;
        short s2;
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        if (pixels == null || pixels.size() == 0) {
            return new LinkedList<ShortPoint>();
        }
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixels) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        ShortPoint[][] map = new ShortPoint[right - s + 1][bottom - s2 + 1];
        Iterator iterator = pixels.iterator();
        while (iterator.hasNext()) {
            ShortPoint dp;
            map[dp.x - s][dp.y - s2] = dp = (ShortPoint)iterator.next();
        }
        ShortPoint[][] map2 = new ShortPoint[right - s + 1][bottom - s2 + 1];
        int i2 = 0;
        while (i2 < map.length) {
            j = 0;
            while (j < map[i2].length && map[i2][j] == null) {
                ++j;
            }
            map2[i2][j] = map[i2][j];
            ++i2;
        }
        int i3 = 0;
        while (i3 < map.length) {
            j = map[i3].length - 1;
            while (j > -1 && map[i3][j] == null) {
                --j;
            }
            map2[i3][j] = map[i3][j];
            ++i3;
        }
        int j2 = 0;
        while (j2 < map[0].length) {
            i = 0;
            while (i < map.length && map[i][j2] == null) {
                ++i;
            }
            map2[i][j2] = map[i][j2];
            ++j2;
        }
        int j3 = 0;
        while (j3 < map[0].length) {
            i = map.length - 1;
            while (i > -1 && map[i][j3] == null) {
                --i;
            }
            map2[i][j3] = map[i][j3];
            ++j3;
        }
        i3 = 0;
        while (i3 < map2.length) {
            j = 0;
            while (j < map2[i3].length) {
                if (map2[i3][j] != null) {
                    result.add(map2[i3][j]);
                }
                ++j;
            }
            ++i3;
        }
        return result;
    }

    public static LinkedList<ShortPoint> perimeterPixels(LinkedList<ShortPoint> pixels) {
        short s;
        short s2;
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        if (pixels == null) {
            return new LinkedList<ShortPoint>();
        }
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixels) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        ShortPoint[][] map = new ShortPoint[right - s + 3][bottom - s2 + 3];
        Iterator iterator = pixels.iterator();
        while (iterator.hasNext()) {
            ShortPoint dp;
            map[dp.x - s + 1][dp.y - s2 + 1] = dp = (ShortPoint)iterator.next();
        }
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                int count = 0;
                try {
                    if (map[i - 1][j] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i + 1][j] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i][j + 1] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i][j - 1] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (count < 4 && count > 0 && map[i][j] == null) {
                    result.add(new ShortPoint((short)(s + i - 1), (short)(s2 + j - 1)));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static LinkedList<ShortPoint> contiguousPerimeterPixels(LinkedList<ShortPoint> pixels) {
        short s;
        short s2;
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        if (pixels == null) {
            return new LinkedList<ShortPoint>();
        }
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixels) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        ShortPoint[][] map = new ShortPoint[right - s + 3][bottom - s2 + 3];
        Iterator iterator = pixels.iterator();
        while (iterator.hasNext()) {
            ShortPoint dp;
            map[dp.x - s + 1][dp.y - s2 + 1] = dp = (ShortPoint)iterator.next();
        }
        HashSet<ShortPoint> tried = new HashSet<ShortPoint>();
        int currentx = 0;
        int currenty = 0;
        ShortPoint startPoint = null;
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                if (map[i][j] != null) {
                    tried.add(map[i][j]);
                    result.add(map[i][j]);
                    currentx = i;
                    currenty = j;
                    startPoint = map[i][j];
                    i = map.length;
                    break;
                }
                ++j;
            }
            ++i;
        }
        int[] nArray = new int[8];
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        int[] xs = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[7] = -1;
        int[] ys = nArray2;
        int starti = 0;
        int i2 = 1;
        while (i2 != starti) {
            int count = 0;
            int t = 0;
            while (t < 8) {
                try {
                    if (map[currentx + xs[i2] + xs[t]][currenty + ys[i2] + ys[t]] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++t;
            }
            try {
                if (map[currentx + xs[i2]][currenty + ys[i2]] != null && count > 1) {
                    if (!tried.contains(map[currentx + xs[i2]][currenty + ys[i2]])) {
                        tried.add(map[currentx + xs[i2]][currenty + ys[i2]]);
                        result.add(map[currentx + xs[i2]][currenty + ys[i2]]);
                        currentx += xs[i2];
                        currenty += ys[i2];
                        starti = i2 = (i2 + 4) % 8;
                    } else if (map[currentx + xs[i2]][currenty + ys[i2]].equals(startPoint)) {
                        return result;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            i2 = (i2 + 1) % 8;
        }
        return result;
    }

    public static LinkedList<ShortPoint> perimeterPixels2(LinkedList<ShortPoint> pixels) {
        int count;
        short s;
        short s2;
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        if (pixels == null) {
            return new LinkedList<ShortPoint>();
        }
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixels) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        ShortPoint[][] map = new ShortPoint[right - s + 5][bottom - s2 + 5];
        Iterator iterator = pixels.iterator();
        while (iterator.hasNext()) {
            ShortPoint dp;
            map[dp.x - s + 2][dp.y - s2 + 2] = dp = (ShortPoint)iterator.next();
        }
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                count = 0;
                try {
                    if (map[i - 1][j] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i + 1][j] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i][j + 1] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i][j - 1] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (count < 4 && count > 0 && map[i][j] == null) {
                    map[i][j] = new ShortPoint((short)(s + i - 2), (short)(s2 + j - 2));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                count = 0;
                try {
                    if (map[i - 1][j] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i + 1][j] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i][j + 1] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (map[i][j - 1] != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (count < 4 && count > 0 && map[i][j] == null) {
                    result.add(new ShortPoint((short)(s + i - 1), (short)(s2 + j - 1)));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static LinkedList<ShortPoint> floodFill(Collection<ShortPoint> perimeter) {
        short s;
        short s2;
        if (perimeter.size() == 0) {
            return new LinkedList<ShortPoint>();
        }
        short maxx = -9999;
        short maxy = -9999;
        int n = 99999;
        int n2 = 99999;
        for (ShortPoint sp : perimeter) {
            if (sp.x > maxx) {
                maxx = sp.x;
            }
            if (sp.y > maxy) {
                maxy = sp.y;
            }
            if (sp.x < s2) {
                s2 = sp.x;
            }
            if (sp.y >= s) continue;
            s = sp.y;
        }
        boolean[][] mask = new boolean[maxx - s2 + 1][maxy - s + 1];
        for (ShortPoint sp : perimeter) {
            mask[sp.x - s2][sp.y - s] = true;
        }
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        int i = 0;
        while (i < mask.length) {
            int start = -1;
            int end = -1;
            int j = 0;
            while (j < mask[i].length) {
                if (mask[i][j]) {
                    if (start == -1) {
                        start = j;
                    }
                    end = Math.max(end, j);
                }
                ++j;
            }
            if (end < start) {
                end = start;
            }
            j = start;
            while (j <= end) {
                result.add(new ShortPoint(s2 + i, s + j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static LinkedList<ShortPoint> doFloodFill(int i, int j, boolean[][] mask, int minx, int miny, int depth) {
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        if (depth == 0 || i - minx < 0 || j - miny < 0 || i - minx >= mask.length || j - miny >= mask[i - minx].length) {
            return result;
        }
        if (!mask[i - minx][j - miny]) {
            mask[i - minx][j - miny] = true;
            result.add(new ShortPoint(i, j));
            try {
                result.addAll(Static.doFloodFill(i + 1, j, mask, minx, miny, depth - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                result.addAll(Static.doFloodFill(i - 1, j, mask, minx, miny, depth - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                result.addAll(Static.doFloodFill(i, j + 1, mask, minx, miny, depth - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                result.addAll(Static.doFloodFill(i, j + 1, mask, minx, miny, depth - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LinkedList<ShortPoint> flow(LinkedList<ShortPoint> from, LinkedList<ShortPoint> to, int rounds) {
        short s;
        short s2;
        if (from.size() == 0 || to.size() == 0) {
            return from;
        }
        short maxx = 0;
        short maxy = 0;
        int n = 99999;
        int n2 = 99999;
        for (ShortPoint sp : from) {
            short s3;
            short s4;
            if (sp.x > maxx) {
                maxx = sp.x;
            }
            if (sp.y > maxy) {
                maxy = sp.y;
            }
            if (sp.y < s4) {
                s4 = sp.y;
            }
            if (sp.x >= s3) continue;
            s3 = sp.x;
        }
        for (ShortPoint sp : to) {
            if (sp.x > maxx) {
                maxx = sp.x;
            }
            if (sp.y > maxy) {
                maxy = sp.y;
            }
            if (sp.y < s2) {
                s2 = sp.y;
            }
            if (sp.x >= s) continue;
            s = sp.x;
        }
        int[][] map = new int[maxx - s + 2][maxy - s2 + 2];
        for (ShortPoint sp : from) {
            map[sp.x - s + 1][sp.y - s2 + 1] = 1;
        }
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        for (ShortPoint sp : to) {
            int x = sp.x - s + 1;
            int y = sp.y - s2 + 1;
            if (map[x][y] == 0) {
                map[x][y] = 2;
                continue;
            }
            map[x][y] = -1;
            result.add(new ShortPoint(sp.x, sp.y));
        }
        int[][] map2 = new int[maxx - s + 2][maxy - s2 + 2];
        int i = 1;
        while (i < maxx - s + 1) {
            int j = 1;
            while (j < maxy - s2 + 1) {
                int count;
                if (map[i][j] == 1) {
                    count = 4;
                    if (map[i - 1][j] == 0) {
                        --count;
                    }
                    if (map[i + 1][j] == 0) {
                        --count;
                    }
                    if (map[i][j - 1] == 0) {
                        --count;
                    }
                    if (map[i][j + 1] == 0) {
                        // empty if block
                    }
                    map2[i][j] = --count;
                } else if (map[i][j] == 2) {
                    count = -2;
                    if (map[i - 1][j] == -1) {
                        count += 10;
                    }
                    if (map[i + 1][j] == -1) {
                        count += 10;
                    }
                    if (map[i][j - 1] == -1) {
                        count += 10;
                    }
                    if (map[i][j + 1] == -1) {
                        count += 10;
                    }
                    map2[i][j] = count;
                } else if (map[i][j] == -1) {
                    map2[i][j] = -1;
                }
                ++j;
            }
            ++i;
        }
        map = map2;
        int r = 0;
        while (r < rounds) {
            map2 = new int[maxx - s + 2][maxy - s2 + 2];
            int i2 = 1;
            while (i2 < maxx - s + 1) {
                int j = 1;
                while (j < maxy - s2 + 1) {
                    int[] nArray = map2[i2];
                    int n3 = j;
                    nArray[n3] = nArray[n3] + map[i2][j];
                    if (map[i2][j] < 10 && map[i2][j] > 0) {
                        map2[i2][j] = map[i2][j] - 1;
                    } else if (map[i2][j] > 4) {
                        map2[i2][j] = -1;
                        result.add(new ShortPoint(i2 + s + 1, j + s2 + 1));
                        if (map[i2 - 1][j] == -2) {
                            int[] nArray2 = map2[i2 - 1];
                            int n4 = j;
                            nArray2[n4] = nArray2[n4] + 10;
                        }
                        if (map[i2 + 1][j] == -2) {
                            int[] nArray3 = map2[i2 + 1];
                            int n5 = j;
                            nArray3[n5] = nArray3[n5] + 10;
                        }
                        if (map[i2][j - 1] == -2) {
                            int[] nArray4 = map2[i2];
                            int n6 = j - 1;
                            nArray4[n6] = nArray4[n6] + 10;
                        }
                        if (map[i2][j + 1] == -2) {
                            int[] nArray5 = map2[i2];
                            int n7 = j + 1;
                            nArray5[n7] = nArray5[n7] + 10;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            ++r;
        }
        return result;
    }

    public static double std(double[] x) {
        double std = 0.0;
        double u = Static.average(x);
        int i = 0;
        while (i < x.length) {
            std += (u - x[i]) * (u - x[i]);
            ++i;
        }
        return Math.sqrt(std / (double)x.length);
    }

    public static final double[][] sumDistanceMap(int radius, int[][] field) {
        int j;
        double[][] result = new double[field.length][field[0].length];
        double[][] kernel = new double[radius * 2 + 1][radius * 2 + 1];
        int i = -radius;
        while (i <= radius) {
            j = -radius;
            while (j <= radius) {
                kernel[i + radius][j + radius] = 1.0 / ((double)(i * i + j * j) + 1.0);
                ++j;
            }
            ++i;
        }
        kernel[radius][radius] = -2.0;
        i = 0;
        while (i < field.length) {
            j = 0;
            while (j < field[i].length) {
                double sum = 0.0;
                int k = -radius;
                while (k <= radius) {
                    int l = -radius;
                    while (l <= radius) {
                        try {
                            sum += (double)field[i + k][j + l] * kernel[radius + k][radius + l];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++l;
                    }
                    ++k;
                }
                result[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static final BufferedImage arrayToImage(double[][] arr) {
        double TheMax = 0.0;
        double[] vals = new double[arr.length * arr[0].length];
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                if (arr[i][j] > TheMax) {
                    TheMax = arr[i][j];
                }
                vals[j * arr.length + i] = arr[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < vals.length) {
            vals[i] = vals[i] / TheMax * 65535.0;
            ++i;
        }
        BufferedImage img = new BufferedImage(arr.length, arr[0].length, 11);
        WritableRaster wr = img.getRaster();
        wr.setPixels(0, 0, arr.length, arr[0].length, vals);
        return img;
    }

    public static final BufferedImage gaussianBlur(int radius, BufferedImage img) {
        int j;
        double val;
        double[] kernel = new double[radius * 2 + 1];
        double total = 0.0;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        int[] vals2 = new int[img.getWidth() * img.getHeight()];
        int i = 0;
        while (i < kernel.length) {
            double val2 = Static.getGaussianPDF((double)radius + 0.5, (double)radius * 0.5, i + 1);
            total += val2;
            kernel[i] = val2;
            ++i;
        }
        i = 0;
        while (i < kernel.length) {
            int n = i++;
            kernel[n] = kernel[n] / total;
        }
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        int i2 = 0;
        while (i2 < img.getWidth()) {
            int j2 = 0;
            while (j2 < img.getHeight()) {
                vals[j2 * img.getWidth() + i2] = rast.getSample(i2, j2, 0);
                vals2[j2 * img.getWidth() + i2] = rast.getSample(i2, j2, 0);
                ++j2;
            }
            ++i2;
        }
        WritableRaster rast2 = result.getRaster();
        int y = 0;
        while (y < img.getHeight()) {
            int x = radius;
            while (x < img.getWidth() - radius) {
                val = 0.0;
                j = -radius;
                while (j <= radius) {
                    val += kernel[j + radius] * (double)vals[y * img.getWidth() + x + j];
                    ++j;
                }
                vals2[y * img.getWidth() + x] = (int)val;
                ++x;
            }
            ++y;
        }
        int x = 0;
        while (x < img.getWidth()) {
            int y2 = radius;
            while (y2 < result.getHeight() - radius) {
                val = 0.0;
                j = -radius;
                while (j <= radius) {
                    val += kernel[j + radius] * (double)vals2[(y2 + j) * img.getWidth() + x];
                    ++j;
                }
                vals[y2 * img.getWidth() + x] = (int)val;
                ++y2;
            }
            ++x;
        }
        rast2.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static final BufferedImage filterBlurAndBackgroundSubtraction(int radius, int threshold, BufferedImage img) {
        int j;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        int[] vals2 = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        int i = 0;
        while (i < img.getWidth()) {
            int j2 = 0;
            while (j2 < img.getHeight()) {
                vals[j2 * img.getWidth() + i] = rast.getSample(i, j2, 0);
                vals2[j2 * img.getWidth() + i] = rast.getSample(i, j2, 0);
                ++j2;
            }
            ++i;
        }
        WritableRaster rast2 = result.getRaster();
        int y = 0;
        while (y < img.getHeight()) {
            int x = radius;
            while (x < img.getWidth() - radius) {
                double val = 0.0;
                int count = 0;
                j = -radius;
                while (j <= radius) {
                    if (Math.abs(vals[y * img.getWidth() + x + j] - vals[y * img.getWidth() + x]) < threshold) {
                        val += (double)vals[y * img.getWidth() + x + j];
                        ++count;
                    }
                    ++j;
                }
                vals2[y * img.getWidth() + x] = (int)(val / (double)count);
                ++x;
            }
            ++y;
        }
        int x = 0;
        while (x < img.getWidth()) {
            int y2 = radius;
            while (y2 < result.getHeight() - radius) {
                int count = 0;
                double val = 0.0;
                j = -radius;
                while (j <= radius) {
                    if (Math.abs(vals2[(y2 + j) * img.getWidth() + x] - vals2[y2 * img.getWidth() + x]) < threshold) {
                        val += (double)vals2[(y2 + j) * img.getWidth() + x];
                        ++count;
                    }
                    ++j;
                }
                vals[y2 * img.getWidth() + x] = (int)(val / (double)count);
                ++y2;
            }
            ++x;
        }
        int smoothe = 20;
        double[][] gweights = new double[smoothe * 2 + 1][smoothe * 2 + 1];
        double total = 0.0;
        int i2 = 0;
        while (i2 < smoothe * 2 + 1) {
            j = 0;
            while (j < smoothe * 2 + 1) {
                gweights[i2][j] = Static.getGaussianPDF(smoothe, smoothe / 2, i2) * Static.getGaussianPDF(smoothe, smoothe / 2, j);
                total += gweights[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < gweights.length) {
            j = 0;
            while (j < gweights.length) {
                double[] dArray = gweights[i2];
                int n = j++;
                dArray[n] = dArray[n] / total;
            }
            ++i2;
        }
        int x2 = 0;
        while (x2 < img.getWidth()) {
            int y3 = 0;
            while (y3 < result.getHeight()) {
                double val = 0.0;
                double tot = 0.0;
                int j3 = -smoothe;
                while (j3 <= smoothe) {
                    int k = -smoothe;
                    while (k <= smoothe) {
                        if (y3 + j3 > -1 && y3 + j3 < img.getHeight() && x2 + k > -1 && x2 + k < img.getWidth()) {
                            val += (double)vals2[(y3 + j3) * img.getWidth() + x2 + k] * gweights[k + smoothe][j3 + smoothe];
                            tot += gweights[j3 + smoothe][k + smoothe];
                        }
                        ++k;
                    }
                    ++j3;
                }
                if (vals[y3 * img.getWidth() + x2] < 50000) {
                    vals[y3 * img.getWidth() + x2] = (int)Math.max(0.0, (double)vals[y3 * img.getWidth() + x2] - val / tot);
                }
                if (vals[y3 * img.getWidth() + x2] < 50000) {
                    vals[y3 * img.getWidth() + x2] = 0;
                }
                ++y3;
            }
            ++x2;
        }
        rast2.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static final BufferedImage filterBlur(int radius, int threshold, BufferedImage img) {
        int j;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        int[] vals2 = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        int i = 0;
        while (i < img.getWidth()) {
            int j2 = 0;
            while (j2 < img.getHeight()) {
                vals[j2 * img.getWidth() + i] = rast.getSample(i, j2, 0);
                vals2[j2 * img.getWidth() + i] = rast.getSample(i, j2, 0);
                ++j2;
            }
            ++i;
        }
        WritableRaster rast2 = result.getRaster();
        int y = 0;
        while (y < img.getHeight()) {
            int x = radius;
            while (x < img.getWidth() - radius) {
                double val = 0.0;
                int count = 0;
                j = -radius;
                while (j <= radius) {
                    if (Math.abs(vals[y * img.getWidth() + x + j] - vals[y * img.getWidth() + x]) < threshold) {
                        val += (double)vals[y * img.getWidth() + x + j];
                        ++count;
                    }
                    ++j;
                }
                vals2[y * img.getWidth() + x] = (int)(val / (double)count);
                ++x;
            }
            ++y;
        }
        int x = 0;
        while (x < img.getWidth()) {
            int y2 = radius;
            while (y2 < result.getHeight() - radius) {
                int count = 0;
                double val = 0.0;
                j = -radius;
                while (j <= radius) {
                    if (Math.abs(vals2[(y2 + j) * img.getWidth() + x] - vals2[y2 * img.getWidth() + x]) < threshold) {
                        val += (double)vals2[(y2 + j) * img.getWidth() + x];
                        ++count;
                    }
                    ++j;
                }
                vals[y2 * img.getWidth() + x] = (int)(val / (double)count);
                ++y2;
            }
            ++x;
        }
        rast2.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static final double compactness(LinkedList<DoublePoint> pixs) {
        if (pixs.size() > 0) {
            return (double)pixs.size() / Math.pow((double)Static.perimeter(pixs) / 4.0, 2.0);
        }
        return 0.0;
    }

    public static final double compactnessShort(LinkedList<ShortPoint> pixs) {
        if (pixs.size() > 0) {
            return (double)pixs.size() / Math.pow((double)Static.perimeterShort(pixs) / 4.0, 2.0);
        }
        return 0.0;
    }

    public static final int perimeter(LinkedList<DoublePoint> pixs) {
        if (pixs.size() == 0) {
            return 0;
        }
        int count = 0;
        int top = 99999999;
        int left = 99999999;
        int right = 0;
        int bottom = 0;
        for (DoublePoint dp : pixs) {
            if ((int)dp.y < top) {
                top = (int)dp.y;
            }
            if ((int)dp.y > bottom) {
                bottom = (int)dp.y;
            }
            if ((int)dp.x < left) {
                left = (int)dp.x;
            }
            if ((int)dp.x <= right) continue;
            right = (int)dp.x;
        }
        boolean[][] map = new boolean[right - left + 3][bottom - top + 3];
        for (DoublePoint dp : pixs) {
            map[(int)dp.x - left + 1][(int)dp.y - top + 1] = true;
        }
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                if (map[i][j]) {
                    try {
                        if (!map[i - 1][j]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!map[i + 1][j]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!map[i][j - 1]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!map[i][j + 1]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public static final int perimeterShort(LinkedList<ShortPoint> pixs) {
        short s;
        short s2;
        if (pixs.size() == 0) {
            return 0;
        }
        int count = 0;
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixs) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        boolean[][] map = new boolean[right - s + 3][bottom - s2 + 3];
        for (ShortPoint dp : pixs) {
            map[dp.x - s + 1][dp.y - s2 + 1] = true;
        }
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                if (map[i][j]) {
                    try {
                        if (!map[i - 1][j]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!map[i + 1][j]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!map[i][j - 1]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!map[i][j + 1]) {
                            ++count;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public static final double perimeterAvgIntensity(LinkedList<ShortPoint> pixs, BufferedImage img, int max_layer) {
        short s;
        short s2;
        if (pixs.size() == 0) {
            return 0.0;
        }
        int count = 0;
        int n = 99999999;
        int n2 = 99999999;
        short right = 0;
        short bottom = 0;
        for (ShortPoint dp : pixs) {
            if (dp.y < s2) {
                s2 = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < s) {
                s = dp.x;
            }
            if (dp.x <= right) continue;
            right = dp.x;
        }
        boolean[][] map = new boolean[right - s + 5][bottom - s2 + 5];
        for (ShortPoint dp : pixs) {
            map[dp.x - s + 1][dp.y - s2 + 1] = true;
        }
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        int layer = 0;
        while (layer < max_layer) {
            int i = 0;
            while (i < map.length) {
                int j = 0;
                while (j < map[i].length) {
                    if (!map[i][j]) {
                        try {
                            if (!map[i - 1][j]) {
                                ++count;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (!map[i + 1][j]) {
                                ++count;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (!map[i][j - 1]) {
                                ++count;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (!map[i][j + 1]) {
                                ++count;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (count > 0) {
                            result.add(new ShortPoint(s + 1 + i, s2 + 1 + j));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++layer;
        }
        double avg = 0.0;
        for (ShortPoint sp : result) {
            avg += (double)Static.gray(img, sp.x, sp.y);
        }
        return avg / (double)result.size();
    }

    public static final int gray(BufferedImage img, int x, int y) {
        int val;
        try {
            WritableRaster rast = img.getRaster();
            val = -1;
            try {
                val = rast.getSample(x, y, 0);
            }
            catch (Exception e) {
                return 0;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return val;
    }

    public static final int gradient(BufferedImage img, int x, int y) {
        WritableRaster rast = img.getRaster();
        int count = 0;
        double val = 0.0;
        int spotVal = rast.getSample(x, y, 0);
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                try {
                    val += Math.pow(rast.getSample(x + i, y + j, 0) - spotVal, 2.0);
                    ++count;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        if (count > 0) {
            return (int)Math.sqrt(val / (double)count);
        }
        return 0;
    }

    public static final int sobel(BufferedImage img, int x, int y) {
        WritableRaster rast = img.getRaster();
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] Gx = nArrayArray;
        int[][] Gy = new int[][]{{-1, -2, -1}, new int[3], {1, 2, 1}};
        int sumGx = 0;
        int sumGy = 0;
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                try {
                    sumGx += rast.getSample(x + i, y + j, 0) * Gx[i + 1][j + 1];
                    sumGy += rast.getSample(x + i, y + j, 0) * Gy[i + 1][j + 1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        int val = (int)Math.min(65535.0, Math.sqrt(sumGx * sumGx + sumGy * sumGy));
        return val;
    }

    public static int[][] getIntArray(BufferedImage img) {
        int[][] vals = new int[img.getWidth()][img.getHeight()];
        WritableRaster rast = img.getRaster();
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                vals[x][y] = rast.getSample(x, y, 0);
                ++y;
            }
            ++x;
        }
        return vals;
    }

    public static final LinkedList<DoublePoint> fillHoles(LinkedList<DoublePoint> list) {
        double top = 9.999999999E9;
        double left = 9.999999999E9;
        double right = 0.0;
        double bottom = 0.0;
        for (DoublePoint dp : list) {
            if (dp.y < top) {
                top = dp.y;
            }
            if (dp.y > bottom) {
                bottom = dp.y;
            }
            if (dp.x < left) {
                left = dp.x;
            }
            if (!(dp.x > right)) continue;
            right = dp.x;
        }
        if (right < left || bottom < top) {
            return list;
        }
        boolean[][] map = new boolean[(int)(right - left) + 3][(int)(bottom - top) + 3];
        for (DoublePoint dp : list) {
            map[(int)(dp.x - left) + 1][(int)(dp.y - top) + 1] = true;
        }
        LinkedList<DoublePoint> newPoints = new LinkedList<DoublePoint>();
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                if (!map[i][j]) {
                    int count = 0;
                    int a = -1;
                    while (a <= 1) {
                        int b = -1;
                        while (b <= 1) {
                            try {
                                if (map[i + a][j + b]) {
                                    ++count;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++b;
                        }
                        ++a;
                    }
                    if (count > 3) {
                        newPoints.add(new DoublePoint(left + (double)i - 1.0, top + (double)j - 1.0));
                    }
                }
                ++j;
            }
            ++i;
        }
        return newPoints;
    }

    public static final LinkedList<ShortPoint> expand(LinkedList<ShortPoint> list) {
        HashSet<String> positions = new HashSet<String>();
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        for (ShortPoint sp : list) {
            int i = -1;
            while (i <= 1) {
                int j = -1;
                while (j <= 1) {
                    positions.add(String.valueOf(sp.x + i) + "," + (sp.y + j));
                    ++j;
                }
                ++i;
            }
        }
        for (String s : positions) {
            result.add(new ShortPoint(Short.parseShort(s.split(",")[0]), Short.parseShort(s.split(",")[1])));
        }
        return result;
    }

    public static final LinkedList<ShortPoint> errode(LinkedList<ShortPoint> list) {
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        result.addAll(list);
        result.removeAll(Static.perimeterPixels(list));
        return result;
    }

    public static final LinkedList<ShortPoint> fillHolesShort(LinkedList<ShortPoint> perimeter) {
        return Static.contiguousPerimeterPixels(Static.floodFill(perimeter));
    }

    public static final int computeImageAverage(BufferedImage img) {
        long average = 0L;
        int i = 0;
        while (i < img.getWidth()) {
            int j = 0;
            while (j < img.getHeight()) {
                average += (long)Static.gray(img, i, j);
                ++j;
            }
            ++i;
        }
        return (int)(average / (long)(img.getWidth() * img.getHeight()));
    }

    public static final int[][] averageGrids(BufferedImage img) {
        int j;
        int size = Math.max(1, Math.min(img.getWidth(), img.getHeight()) / 120);
        if (size < 2) {
            size = 2;
        }
        long[][] averages = new long[size][size];
        int[][] averages2 = new int[size][size];
        int xspacing = img.getWidth() / size + 1;
        int yspacing = img.getHeight() / size + 1;
        int i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                long[] lArray = averages[i / xspacing];
                int n = j / yspacing;
                lArray[n] = lArray[n] + (long)Static.gray(img, i, j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                averages2[i][j] = (int)(averages[i][j] / (long)(xspacing * yspacing));
                ++j;
            }
            ++i;
        }
        return averages2;
    }

    public static final BufferedImage getGrayscale(BufferedImage img) {
        BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), 11);
        img2.getGraphics().drawImage(img, 0, 0, null);
        return img2;
    }

    public static BufferedImage adjustMinMax(BufferedImage current) {
        BufferedImage gray = current;
        if (current.getType() != 11) {
            gray = Static.getGrayscale(current);
        }
        BufferedImage img = new BufferedImage(current.getWidth(), current.getHeight(), 11);
        int min = 65535;
        int maximum = 0;
        WritableRaster rast = gray.getRaster();
        int i = 0;
        while (i < current.getWidth()) {
            int j = 0;
            while (j < current.getHeight()) {
                int val = rast.getSample(i, j, 0);
                if (val < min) {
                    min = val;
                }
                if (val > maximum) {
                    maximum = val;
                }
                ++j;
            }
            ++i;
        }
        float rat = 65535.0f / (float)(maximum - min);
        int i2 = 0;
        while (i2 < current.getWidth()) {
            int j = 0;
            while (j < current.getHeight()) {
                rast.setSample(i2, j, 0, Math.min(65535.0f, rat * (float)rast.getSample(i2, j, 0) - (float)min));
                ++j;
            }
            ++i2;
        }
        img.getGraphics().drawImage(gray, 0, 0, null);
        return img;
    }

    public static DoublePoint getCOM(LinkedList<DoublePoint> list) {
        double x = 0.0;
        double y = 0.0;
        for (DoublePoint dp : list) {
            x += dp.x;
            y += dp.y;
        }
        return new DoublePoint(x / (double)list.size(), y / (double)list.size());
    }

    public static DoublePoint getCOMShort(LinkedList<ShortPoint> list) {
        double x = 0.0;
        double y = 0.0;
        for (ShortPoint dp : list) {
            x += (double)dp.x;
            y += (double)dp.y;
        }
        return new DoublePoint(x / (double)list.size(), y / (double)list.size());
    }

    public static int[][] duplicate(int[][] arr) {
        int[][] result = new int[arr.length][arr[0].length];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = arr[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static LinkedList<LinkedList<Cell>> splitList(LinkedList<Cell> cells, int size) {
        LinkedList<LinkedList<Cell>> split = new LinkedList<LinkedList<Cell>>();
        int i = 0;
        while (i < size) {
            split.add(new LinkedList());
            ++i;
        }
        int index = 0;
        for (Cell c : cells) {
            split.get(index % size).add(c);
            ++index;
        }
        return split;
    }

    public static int maxGradient(BufferedImage current, int i, int j) {
        int val = Static.gray(current, i, j);
        int max_gradient = 0;
        if (i - 1 >= 0) {
            max_gradient = Math.max(max_gradient, val - Static.gray(current, i - 1, j));
        }
        if (j - 1 >= 0) {
            max_gradient = Math.max(max_gradient, val - Static.gray(current, i, j - 1));
        }
        if (i + 1 < current.getWidth()) {
            max_gradient = Math.max(max_gradient, val - Static.gray(current, i + 1, j));
        }
        if (j + 1 < current.getHeight()) {
            max_gradient = Math.max(max_gradient, val - Static.gray(current, i, j + 1));
        }
        return max_gradient;
    }

    public static int minimumBrightness(BufferedImage img, int x, int y, int radius) {
        int min = 65535;
        int i = x - radius;
        while (i <= x + radius) {
            int j = y - radius;
            while (j <= y + radius) {
                int val;
                if (i > -1 && j > -1 && i < img.getWidth() && j < img.getHeight() && (val = Static.gray(img, i, j)) < min) {
                    min = val;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public static BufferedImage getGradientTransformed(BufferedImage img) {
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int i = 0;
        while (i < img.getWidth()) {
            int j = 0;
            while (j < img.getHeight()) {
                int times = 0;
                int value = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        try {
                            if (x != 0 || y != 0) {
                                value += Math.abs(rast.getSample(i + x, j + y, 0) - rast.getSample(i, j, 0));
                                ++times;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++y;
                    }
                    ++x;
                }
                vals[j * img.getWidth() + i] = value / times;
                ++j;
            }
            ++i;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage getSobelTransformed(BufferedImage img) {
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] Gx = nArrayArray;
        int[][] Gy = new int[][]{{-1, -2, -1}, new int[3], {1, 2, 1}};
        int x = 1;
        while (x < img.getWidth() - 1) {
            int y = 1;
            while (y < img.getHeight() - 1) {
                double sumGx = 0.0;
                double sumGy = 0.0;
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        try {
                            sumGx += (double)(rast.getSample(x + i, y + j, 0) * Gx[i + 1][j + 1]) * 0.5;
                            sumGy += (double)(rast.getSample(x + i, y + j, 0) * Gy[i + 1][j + 1]) * 0.5;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++j;
                    }
                    ++i;
                }
                vals[y * img.getWidth() + x] = (int)Math.max(0.0, Math.min(65535.0, Math.sqrt(sumGx * sumGx + sumGy * sumGy)));
                ++y;
            }
            ++x;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage getSobelTransformed2(BufferedImage img) {
        int y;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        int[] vals2 = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] Gx = nArrayArray;
        int[][] Gy = new int[][]{{-1, -2, -1}, new int[3], {1, 2, 1}};
        int x = 1;
        while (x < img.getWidth() - 1) {
            y = 1;
            while (y < img.getHeight() - 1) {
                double sumGx = 0.0;
                double sumGy = 0.0;
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        try {
                            sumGx += (double)(rast.getSample(x + i, y + j, 0) * Gx[i + 1][j + 1]) * 0.5;
                            sumGy += (double)(rast.getSample(x + i, y + j, 0) * Gy[i + 1][j + 1]) * 0.5;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++j;
                    }
                    ++i;
                }
                vals[y * img.getWidth() + x] = (int)Math.max(0.0, Math.min(65535.0, Math.sqrt(sumGx * sumGx + sumGy * sumGy)));
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < img.getWidth()) {
            y = 0;
            while (y < img.getHeight()) {
                int val = vals[y * img.getWidth() + x];
                int i = -5;
                while (i <= 5) {
                    int j = -5;
                    while (j <= 5) {
                        int nearby = 0;
                        try {
                            nearby = vals[(y + j) * img.getWidth() + (x + i)];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if ((double)nearby > (double)val * 1.5) {
                            val = 0;
                            break;
                        }
                        ++j;
                    }
                    if (val == 0) break;
                    ++i;
                }
                vals2[y * img.getWidth() + x] = val;
                ++y;
            }
            ++x;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals2);
        return result;
    }

    public static BufferedImage getSobelTransformed3(BufferedImage img) {
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] Gx = nArrayArray;
        int[][] Gy = new int[][]{{-1, -2, -1}, new int[3], {1, 2, 1}};
        int x = 1;
        while (x < img.getWidth() - 1) {
            int y = 1;
            while (y < img.getHeight() - 1) {
                double sumGx = 0.0;
                double sumGy = 0.0;
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        try {
                            sumGx += (double)(rast.getSample(x + i, y + j, 0) * Gx[i + 1][j + 1]) * 0.5;
                            sumGy += (double)(rast.getSample(x + i, y + j, 0) * Gy[i + 1][j + 1]) * 0.5;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++j;
                    }
                    ++i;
                }
                if (rast.getSample(x, y, 0) < 20000) {
                    vals[y * img.getWidth() + x] = (int)Math.max(0.0, Math.min(65535.0, Math.sqrt(sumGx * sumGx + sumGy * sumGy)));
                }
                ++y;
            }
            ++x;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage thresholded(BufferedImage img, int threshold) {
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                if (rast.getSample(x, y, 0) > threshold) {
                    vals[y * img.getWidth() + x] = 65535;
                }
                ++y;
            }
            ++x;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage getInvertedGradient(BufferedImage img) {
        int j;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int maxVal = 0;
        int i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                int times = 0;
                int value = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        try {
                            if (x != 0 || y != 0) {
                                value += Math.abs(rast.getSample(i + x, j + y, 0) - rast.getSample(i, j, 0));
                                ++times;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++y;
                    }
                    ++x;
                }
                vals[j * img.getWidth() + i] = value / times;
                maxVal = Math.max(maxVal, value / times);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                vals[j * img.getWidth() + i] = 65535 - (int)(65535.0 * ((double)vals[j * img.getWidth() + i] / (double)maxVal));
                ++j;
            }
            ++i;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage getGradientTransformedNormalized(BufferedImage img) {
        int j;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int maxVal = 0;
        int i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                int times = 0;
                int value = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        try {
                            if (x != 0 || y != 0) {
                                value += Math.abs(rast.getSample(i + x, j + y, 0) - rast.getSample(i, j, 0));
                                ++times;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++y;
                    }
                    ++x;
                }
                vals[j * img.getWidth() + i] = value / times;
                maxVal = Math.max(maxVal, value / times);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                vals[j * img.getWidth() + i] = (int)(65535.0 * ((double)vals[j * img.getWidth() + i] / (double)maxVal));
                ++j;
            }
            ++i;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage getGradientTransformedMaxNormalized(BufferedImage img) {
        int j;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int maxVal = 0;
        int i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                int value = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        try {
                            if (x != 0 || y != 0) {
                                value = Math.max(value, Math.abs(rast.getSample(i + x, j + y, 0) - rast.getSample(i, j, 0)));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++y;
                    }
                    ++x;
                }
                vals[j * img.getWidth() + i] = value;
                maxVal = Math.max(maxVal, value);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                vals[j * img.getWidth() + i] = (int)(65535.0 * ((double)vals[j * img.getWidth() + i] / (double)maxVal));
                ++j;
            }
            ++i;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static BufferedImage getGradientTransformedThresholded(BufferedImage img, int threshold) {
        int j;
        int[] vals = new int[img.getWidth() * img.getHeight()];
        BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster rast = img.getRaster();
        WritableRaster wr = result.getRaster();
        int maxVal = 0;
        int i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                int value = 0;
                int x = -1;
                while (x <= 1) {
                    int y = -1;
                    while (y <= 1) {
                        try {
                            if (x != 0 || y != 0) {
                                value += Math.max(value, Math.abs(rast.getSample(i + x, j + y, 0) - rast.getSample(i, j, 0)));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++y;
                    }
                    ++x;
                }
                vals[j * img.getWidth() + i] = value;
                maxVal = Math.max(maxVal, value);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < img.getWidth()) {
            j = 0;
            while (j < img.getHeight()) {
                vals[j * img.getWidth() + i] = (int)(65535.0 * ((double)vals[j * img.getWidth() + i] / (double)maxVal));
                ++j;
            }
            ++i;
        }
        wr.setSamples(0, 0, img.getWidth(), img.getHeight(), 0, vals);
        return result;
    }

    public static void paintOnGraphics(Graphics2D g2, BufferedImage todraw, boolean color_by_score, boolean showImage, boolean showAllTraces, boolean showTags, boolean goodOnly, LinkedList<String> messages, double zoom, int centerx, int centery, Collection<Cell> cellList, int index, Cell pick) {
        Color[] colors = new Color[]{Color.red.darker().darker(), Color.blue, Color.green, Color.cyan, Color.blue.darker(), Color.red, Color.green.darker().darker(), Color.yellow, Color.red.brighter().brighter(), Color.yellow.darker(), Color.orange, Color.magenta.brighter()};
        g2.scale(zoom, zoom);
        if (todraw != null && showImage) {
            g2.drawImage((Image)todraw, -centerx, -centery, null);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRect(0, 0, todraw.getWidth(), todraw.getHeight());
        }
        for (Cell c : cellList) {
            int r = 0;
            int gr = 0;
            int b = 0;
            int a = 130;
            if (!color_by_score) {
                r = colors[c.id % colors.length].getRed();
                gr = colors[c.id % colors.length].getGreen();
                b = colors[c.id % colors.length].getBlue();
            } else {
                if ((double)c.getStats((int)index).fate_score > 0.5) {
                    gr = 255;
                    r = 0;
                } else if ((double)c.getStats((int)index).fate_score > 0.3) {
                    gr = 255;
                    r = 140;
                    b = 50;
                } else if ((double)c.getStats((int)index).fate_score > 0.1) {
                    gr = 255;
                    r = 255;
                } else if ((double)c.getStats((int)index).fate_score > 0.03) {
                    gr = 125;
                    r = 255;
                    b = 125;
                } else {
                    gr = 0;
                    r = 255;
                }
                a = 200;
            }
            g2.setColor(new Color(r, gr, b, a));
            for (Waypoint w : c.waypoints) {
                if (!w.contains(index)) continue;
                g2.drawLine(w.x1, w.y1, w.x2, w.y2);
                DoublePoint thePoint = w.getPoint(index);
                g2.fillOval((int)thePoint.x - 1, (int)thePoint.y - 1, 3, 3);
            }
            if (c.points.get(index) == null || c.points.get(index).size() <= 0) continue;
            DoublePoint cnew = c.getCenter(index);
            int[] xs = new int[c.points.get(index).size()];
            int[] ys = new int[c.points.get(index).size()];
            int i = 0;
            while (i < xs.length) {
                xs[i] = (int)c.points.get((Object)Integer.valueOf((int)index)).get((int)i).x;
                ys[i] = (int)c.points.get((Object)Integer.valueOf((int)index)).get((int)i).y;
                ++i;
            }
            g2.fillPolygon(xs, ys, xs.length);
            if (showTags) {
                g2.setFont(new Font("Calibri", 0, 10));
                if (index == c.Tenter) {
                    g2.setColor(Color.yellow);
                    g2.drawString("e", xs[0], ys[0]);
                }
                if (index == c.Tgone - 1) {
                    g2.setColor(Color.red);
                    g2.drawString("->", xs[0], ys[0]);
                }
                if (index == c.Tdie - 1) {
                    g2.setColor(Color.red);
                    g2.drawString("x", xs[0], ys[0]);
                }
                if (index == c.Tdiv - 1) {
                    g2.setColor(Color.GREEN.brighter());
                    g2.drawString("-<", xs[0], ys[0]);
                }
                if (index == c.Tbirth) {
                    g2.setColor(Color.GREEN.brighter());
                    g2.drawString("!", xs[0], ys[0]);
                }
            }
            if (showAllTraces && c.exists(index - 1)) {
                g2.setColor(Color.WHITE);
                DoublePoint cold = c.getCOM(index - 1);
                if (cold != null) {
                    g2.drawLine((int)cold.x, (int)cold.y, (int)cnew.x, (int)cnew.y);
                }
            }
            if (!c.equals(pick)) continue;
            g2.setColor(Color.RED.brighter());
            for (DoublePoint dp : c.points.get(index)) {
                if (dp == null) continue;
                g2.drawLine((int)dp.x, (int)dp.y, (int)dp.x, (int)dp.y);
            }
            if (!showAllTraces) {
                g2.setColor(Color.WHITE);
                DoublePoint cold = c.getCOM(index - 1);
                if (cold != null) {
                    g2.drawLine((int)cold.x, (int)cold.y, (int)cnew.x, (int)cnew.y);
                }
            }
            g2.setColor(new Color(255, 255, 255, 50));
            g2.drawLine((int)cnew.x, 0, (int)cnew.x, todraw.getHeight());
            g2.drawLine(0, (int)cnew.y, todraw.getWidth(), (int)cnew.y);
        }
        g2.setFont(new Font("Calibri", 0, 12));
        g2.scale(1.0 / zoom, 1.0 / zoom);
        if (messages != null) {
            int offset = 0;
            for (String s : messages) {
                g2.setColor(Color.DARK_GRAY);
                g2.drawString(s, 10, 10 + offset * 10);
                g2.setColor(Color.red);
                g2.drawString(s, 9, 9 + offset * 10);
                ++offset;
            }
        }
    }

    public static double getGaussianCDF(double mu, double sigma, double a, double b) {
        double k = 0.140012289;
        double r2 = 1.41421356;
        double A = (a - mu) / (r2 * sigma);
        double B = (b - mu) / (r2 * sigma);
        double A2 = A * A;
        double B2 = B * B;
        double k2 = 1.27323954;
        double left = B / Math.abs(B) * Math.sqrt(1.0 - Math.exp(-B2 * (k2 + k * B2) / (1.0 + k * B2)));
        double right = A / Math.abs(A) * Math.sqrt(1.0 - Math.exp(-A2 * (k2 + k * A2) / (1.0 + k * A2)));
        return 0.5 * (left - right);
    }

    public static double getGaussianPDF(double mu, double sigma, double x) {
        double s1 = 2.50662827;
        double k = 1.0 / (sigma * s1);
        double e = Math.exp(-Math.pow(x - mu, 2.0) / (2.0 * sigma * sigma));
        return e * k;
    }

    public static LinkedList<ShortPoint> floodFillThreshold(int[][] array, int i, int j, double threshold) {
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        boolean[][] tried = new boolean[array.length][array[0].length];
        LinkedList<ShortPoint> candidates = new LinkedList<ShortPoint>();
        candidates.add(new ShortPoint(i, j));
        while (candidates.size() > 0) {
            ShortPoint next = (ShortPoint)candidates.removeFirst();
            short x = -1;
            while (x <= 1) {
                short y = -1;
                while (y <= 1) {
                    try {
                        if ((x != next.x || y != next.y) && !tried[next.x + x][next.y + y] && (double)array[next.x + x][next.y + y] > threshold) {
                            candidates.add(new ShortPoint(next.x + x, next.y + y));
                            tried[next.x + x][next.y + y] = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++y;
                }
                ++x;
            }
            result.add(next);
        }
        return result;
    }

    public static LinkedList<ShortPoint> floodFillThreshold(int[][] array, int[][] gradient, int i, int j, int threshold, int gradient_threshold) {
        LinkedList<ShortPoint> result = new LinkedList<ShortPoint>();
        boolean[][] tried = new boolean[array.length][array[0].length];
        LinkedList<ShortPoint> candidates = new LinkedList<ShortPoint>();
        candidates.add(new ShortPoint(i, j));
        tried[i][j] = true;
        while (candidates.size() > 0) {
            ShortPoint next = (ShortPoint)candidates.removeFirst();
            short x = -1;
            while (x <= 1) {
                short y = -1;
                while (y <= 1) {
                    try {
                        if (!(x == next.x && y == next.y || tried[next.x + x][next.y + y] || array[next.x + x][next.y + y] <= threshold || gradient[next.x + x][next.y + y] >= gradient_threshold)) {
                            candidates.add(new ShortPoint(next.x + x, next.y + y));
                            tried[next.x + x][next.y + y] = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++y;
                }
                ++x;
            }
            result.add(next);
        }
        return result;
    }
}

