/*
 * Decompiled with CFR 0.152.
 */
package amoebaTracker2works2;

import amoebaTracker2works2.Cell;
import amoebaTracker2works2.Dialogs;
import amoebaTracker2works2.Display;
import amoebaTracker2works2.DoublePoint;
import amoebaTracker2works2.ShortPoint;
import amoebaTracker2works2.Static;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class Tracker
extends JFrame {
    Tracker self = this;
    BufferedImage current = null;
    BufferedImage sobelImage = null;
    int index = 0;
    int[][] current_averages;
    int[][][] img_averages;
    int total_images_processed = 0;
    boolean escape_flag = false;
    private int id = 0;
    boolean applyMinMax = false;
    boolean color_by_score = false;
    boolean sobel = false;
    boolean continuousStitch = false;
    boolean endStitch = false;
    private static int minTrackLength = 0;
    boolean finished_task = true;
    boolean debug = true;
    File dir;
    ArrayList<File> pngs = new ArrayList();
    Display disp;
    Cell pick;
    boolean ctrl_down = false;
    boolean shift_down = false;
    HashSet<Cell> cells = new HashSet();
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH-mm-ss";

    public int getNextId() {
        int result = this.id++;
        return result;
    }

    private void setDir(File d) {
        this.dir = d;
        this.pngs.clear();
        if (this.debug) {
            System.err.println("Found " + d.list().length + " files in dir " + d.getName());
        }
        String[] strs = d.list();
        File[] files = d.listFiles();
        int i = 0;
        while (i < files.length) {
            if (strs[i].endsWith("png") || strs[i].endsWith("PNG")) {
                this.pngs.add(files[i]);
            }
            ++i;
        }
        Collections.sort(this.pngs, new FComparator());
        this.img_averages = new int[this.pngs.size()][1][1];
    }

    private void setCurrent(int new_index) {
        if ((new_index %= this.pngs.size()) < 0) {
            new_index = this.pngs.size() + new_index;
        }
        this.current = null;
        this.current = this.applyMinMax ? Static.adjustMinMax(this.getImage(new_index)) : this.getImage(new_index);
        this.sobelImage = Static.getSobelTransformed(this.current);
        this.current_averages = Static.averageGrids(this.current);
        this.img_averages[new_index] = this.current_averages;
        this.total_images_processed = Math.max(this.total_images_processed, new_index + 1);
        this.index = new_index;
        this.setTitle("TrackerMax by Shokhirev M., Signaling Systems Laboratory (C) 2013. Current Frame = " + this.index + "/" + this.pngs.size());
    }

    public Tracker() {
        this.initialize();
    }

    private BufferedImage getImage(int index) {
        if (this.dir != null) {
            try {
                return Static.getGrayscale(ImageIO.read(this.pngs.get(index % this.pngs.size())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void saveImages() {
        File dir = Dialogs.getSaveDir("Save images to dir");
        int i = 0;
        while (i < this.pngs.size()) {
            this.setCurrent(i);
            BufferedImage img = this.getImage(i);
            BufferedImage ioimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Static.paintOnGraphics((Graphics2D)ioimg.getGraphics(), img, false, true, true, true, false, null, 1.0, 0, 0, this.cells, this.index, this.pick);
            try {
                ImageIO.write((RenderedImage)ioimg, "PNG", new File(String.valueOf(dir.getAbsolutePath()) + File.separator + this.pngs.get(i).getName() + "_processed_" + String.format("%4d.png", i)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.info("Saved all images!");
    }

    private void info(String string) {
        this.disp.addMessage(string);
        this.paint();
    }

    private void initialize() {
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("Load");
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        boolean loading = true;
        while (loading) {
            int val = fc.showOpenDialog(this);
            if (val != 0 || !fc.getSelectedFile().isDirectory()) continue;
            this.setDir(fc.getSelectedFile());
            this.setCurrent(0);
            loading = false;
        }
        if (this.disp == null) {
            this.disp = new Display(this);
        }
        this.disp.addMessage("Welcome to TrackerMax 2013! Get ready to track some cells!");
        this.disp.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Tracker.this.ctrl_down = arg0.isControlDown();
                Tracker.this.shift_down = arg0.isShiftDown();
            }

            @Override
            public void keyReleased(final KeyEvent arg0) {
                if (arg0.getKeyCode() == 27 || arg0.getKeyCode() == 73 || arg0.getKeyCode() == 84 || arg0.getKeyCode() == 71 || Tracker.this.finished_task) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            (this).Tracker.this.finished_task = false;
                            (this).Tracker.this.ctrl_down = arg0.isControlDown();
                            (this).Tracker.this.shift_down = arg0.isShiftDown();
                            if (arg0.getKeyCode() == 68) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 1);
                                if ((this).Tracker.this.pick != null) {
                                    // empty if block
                                }
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 69) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 5);
                                if ((this).Tracker.this.pick != null) {
                                    // empty if block
                                }
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 33) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 25);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 65) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 1);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 81) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 5);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 34) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 25);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 114) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.sobel = !(this).Tracker.this.sobel;
                                System.err.println("Sobel is now " + (this).Tracker.this.sobel);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 73) {
                                (this).Tracker.this.disp.toggleImage();
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 84) {
                                (this).Tracker.this.disp.showAllTraces = !(this).Tracker.this.disp.showAllTraces;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 71) {
                                (this).Tracker.this.disp.showTags = !(this).Tracker.this.disp.showTags;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.goodOnly = !(this).Tracker.this.disp.goodOnly;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 32) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent(0);
                                Tracker.this.info("Back to frame 0");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 35) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.pngs.size() - 1);
                                Tracker.this.info("To the end");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 27) {
                                (this).Tracker.this.escape_flag = true;
                                Tracker.this.info("Escape flag is set!");
                            }
                            if (arg0.getKeyCode() == 120) {
                                Tracker.this.saveImages();
                            }
                            if (arg0.getKeyCode() == 112) {
                                Tracker.this.setCursor(3);
                                Tracker.this.loadEverything(Dialogs.getOpenFile("dat", "load all cells from file"));
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 87) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 70) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.cells.clear();
                                (this).Tracker.this.cells.addAll(Tracker.this.findAllCells());
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 113) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.applyMinMax = !(this).Tracker.this.applyMinMax;
                                Tracker.this.info("Gamma correction is " + (this).Tracker.this.applyMinMax);
                                Tracker.this.setCurrent((this).Tracker.this.index);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 115) {
                                (this).Tracker.this.color_by_score = !(this).Tracker.this.color_by_score;
                                Tracker.this.info("Set color by score to: " + (this).Tracker.this.color_by_score);
                            }
                            if (arg0.getKeyCode() == 116) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveEverything(Dialogs.getSaveFile("dat", "Save all cells to file"));
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 117) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveToCSV(Dialogs.getSaveFile("csv", "Save all cell stats to file").getAbsolutePath());
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 118) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 82) {
                                Tracker.this.setCursor(3);
                                Tracker.this.optimizeCellsToTracks();
                                Tracker.this.setCursor(0);
                            }
                            (this).Tracker.this.finished_task = true;
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.disp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                int clickx = (int)Math.round((double)arg0.getX() / Tracker.this.disp.zoom);
                int clicky = (int)Math.round((double)arg0.getY() / Tracker.this.disp.zoom);
                if (arg0.getButton() == 1) {
                    if (Tracker.this.pick != null) {
                        if (!Tracker.this.ctrl_down && !Tracker.this.shift_down) {
                            Tracker.this.pick.addWaypoint(Tracker.this.index, clickx, clicky);
                            Tracker.this.paint();
                        } else if (Tracker.this.ctrl_down) {
                            DoublePoint com;
                            Cell host = null;
                            for (Cell c : Tracker.this.cells) {
                                if (!c.inside(clickx, clicky, Tracker.this.index) || c.equals(Tracker.this.pick)) continue;
                                host = c;
                                break;
                            }
                            if (host == null && (com = Tracker.this.pick.getCOM(Tracker.this.index)) != null) {
                                DoublePoint newpos = new DoublePoint(clickx, clicky);
                                DoublePoint vector = newpos.minus(com);
                                for (DoublePoint sp : Tracker.this.pick.points.get(Tracker.this.index)) {
                                    sp.x += (double)((int)vector.x);
                                    sp.y += (double)((int)vector.y);
                                }
                            }
                        }
                        Tracker.this.disp.updateUI();
                    }
                } else if (arg0.getButton() == 3) {
                    if (arg0.getClickCount() == 1) {
                        Tracker.this.pick = null;
                        for (Cell c : Tracker.this.cells) {
                            if (!c.inside(clickx, clicky, Tracker.this.index)) continue;
                            Tracker.this.pick = c;
                            break;
                        }
                        if (Tracker.this.pick != null) {
                            Tracker.this.info("Amoeba: " + Tracker.this.pick.id + " X:" + Tracker.this.pick.getCOM((int)Tracker.this.index).x + " Y:" + Tracker.this.pick.getCOM((int)Tracker.this.index).y + " A:" + Tracker.this.pick.getArea(Tracker.this.index));
                            Tracker.this.setTitle("Placing cell " + Tracker.this.pick.id + " x: " + Tracker.this.pick.getCOM((int)Tracker.this.index).x + " y: " + Tracker.this.pick.getCOM((int)Tracker.this.index).y + " area: " + Tracker.this.pick.getArea(Tracker.this.index));
                            Tracker.this.disp.updateUI();
                        }
                    } else if (arg0.getClickCount() == 2) {
                        if (Tracker.this.debug) {
                            System.err.println("Adding new cell");
                        }
                        Cell newcell = new Cell(Tracker.this.index, Tracker.this.getNextId(), (short)clickx, (short)clicky, 3.0);
                        Tracker.this.cells.add(newcell);
                        Tracker.this.pick = newcell;
                        Tracker.this.pick.finalize(Tracker.this.current, Tracker.this.index, 1.0f);
                        Tracker.this.setTitle("Created new cell for tracking: " + Tracker.this.pick.id);
                        Tracker.this.disp.updateUI();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.disp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                try {
                    Tracker.this.disp.zoom = e.getWheelRotation() > 0 ? (Tracker.this.disp.zoom *= 1.5) : (Tracker.this.disp.zoom /= 1.5);
                    Tracker.this.disp.zoom = Math.max(0.05, Math.min(20.0, Tracker.this.disp.zoom));
                    Tracker.this.disp.setPreferredSize(new Dimension((int)((double)Tracker.this.current.getWidth() * Tracker.this.disp.zoom), (int)((double)Tracker.this.current.getHeight() * Tracker.this.disp.zoom)));
                    Tracker.this.self.setPreferredSize(new Dimension(Tracker.this.self.getWidth(), Tracker.this.self.getHeight()));
                    Tracker.this.self.pack();
                    Tracker.this.paint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.disp.setPreferredSize(new Dimension(this.current.getWidth(), this.current.getHeight()));
        cp.add((Component)this.disp, "Center");
        cp.invalidate();
        this.pack();
        this.disp.requestFocus();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("TrackerMax by Max Shokhirev 2013. Signaling Systems Laboratory");
        this.setVisible(true);
    }

    private HashSet<Cell> getNearby(Cell cell, int distance, int time) {
        HashSet<Cell> nearby = new HashSet<Cell>();
        for (Cell c : this.cells) {
            if (!c.exists(time) || !(c.getCOM(time).squaredDistance(cell.getCOM(time)) <= (double)(distance * distance))) continue;
            nearby.add(c);
        }
        return nearby;
    }

    private void paint() {
        this.disp.paintImmediately(0, 0, this.disp.getWidth(), this.disp.getHeight());
    }

    private void optimizeCellsToTracks() {
        HashMap<Cell, HashSet<Cell>> nearbys = new HashMap<Cell, HashSet<Cell>>();
        int t = 1;
        while (t < this.pngs.size()) {
            this.setCurrent(t);
            int[][] field = Static.getIntArray(this.sobelImage);
            nearbys.clear();
            HashSet<Cell> currentCells = new HashSet<Cell>();
            for (Cell c : this.cells) {
                if (c.getWaypointPosition(t) == null) continue;
                currentCells.add(c);
            }
            for (Cell c : currentCells) {
                c.prepareOptimization(t);
                if (c.getPoints(t) != null) {
                    nearbys.put(c, this.getNearby(c, 10, t));
                    continue;
                }
                currentCells.remove(c);
            }
            boolean changing = true;
            while (changing) {
                changing = false;
                for (Cell c : currentCells) {
                    int result = c.iterate(field, (Collection)nearbys.get(c), t, c.getWaypointPosition(t));
                    if (result != 1) continue;
                    changing = true;
                }
            }
            for (Cell c : currentCells) {
                c.finalize(this.current, t, 1.0f);
            }
            this.info("Finished optimizing for frame = " + t);
            ++t;
        }
    }

    private void saveEverything(File saveFile) {
        try {
            PrintWriter pw = new PrintWriter(saveFile);
            for (Cell c : this.cells) {
                if (c.lifeSpan(this.pngs.size() - 1) <= 20) continue;
                c.saveSelf(pw);
            }
            pw.close();
            if (this.debug) {
                System.err.println("Saved everything");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadEverything(File openFile) {
        try {
            Scanner s = new Scanner(openFile);
            this.cells.clear();
            while (s.hasNextLine()) {
                Cell c = new Cell(s);
                this.cells.add(c);
                if (this.cells.size() % 10 != 0) continue;
                this.info("Loaded " + this.cells.size() + " cells.");
            }
            this.disp.updateUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean[][][] getClusteredHotspots(int maximum_radius, int[][] gradient, int edge_threshold, int accumulator_threshold, double min_vote, double vote_per_r) {
        int[][][] accumulator = new int[maximum_radius + 1][this.current.getWidth()][this.current.getHeight()];
        LinkedList<ShortPoint> edgePixels = new LinkedList<ShortPoint>();
        int i = 0;
        while (i < gradient.length) {
            int j = 0;
            while (j < gradient[i].length) {
                if (gradient[i][j] > edge_threshold) {
                    edgePixels.add(new ShortPoint(i, j));
                }
                ++j;
            }
            ++i;
        }
        ArrayList circlePoints = new ArrayList();
        int rr = 0;
        while (rr < maximum_radius) {
            circlePoints.add(new LinkedList());
            ++rr;
        }
        int i2 = -maximum_radius;
        while (i2 <= maximum_radius) {
            int j = -maximum_radius;
            while (j <= maximum_radius) {
                int r = (int)Math.round(Math.sqrt(i2 * i2 + j * j));
                if (r <= maximum_radius && r > 0) {
                    ((LinkedList)circlePoints.get(r - 1)).add(new ShortPoint(i2, j));
                }
                ++j;
            }
            ++i2;
        }
        int r = 1;
        while (r <= maximum_radius) {
            LinkedList points = (LinkedList)circlePoints.get(r - 1);
            for (ShortPoint point : edgePixels) {
                for (ShortPoint sp : points) {
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x + 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x - 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y + 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y - 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++r;
        }
        boolean[][][] clustered = new boolean[maximum_radius + 1][this.current.getWidth()][this.current.getHeight()];
        int r2 = maximum_radius - 1;
        while (r2 >= 1) {
            int threshold = (int)(min_vote + vote_per_r * Math.PI * (double)r2);
            int i3 = 0;
            while (i3 < accumulator[r2].length) {
                int j = 0;
                while (j < accumulator[r2][i3].length) {
                    if (accumulator[r2][i3][j] > threshold) {
                        LinkedList<ShortPoint> hotspot = Static.floodFillThreshold(accumulator[r2], gradient, i3, j, threshold, accumulator_threshold);
                        double centerx = 0.0;
                        double centery = 0.0;
                        for (ShortPoint sp : hotspot) {
                            centerx += (double)sp.x;
                            centery += (double)sp.y;
                            accumulator[r2][sp.x][sp.y] = 0;
                        }
                        int x = (int)Math.round(centerx / (double)hotspot.size());
                        int y = (int)Math.round(centery / (double)hotspot.size());
                        if (hotspot.size() > 1) {
                            clustered[r2][x][y] = true;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            --r2;
        }
        return clustered;
    }

    private ArrayList<Cell> findAllCells() {
        long time = System.nanoTime();
        ArrayList<Cell> list = new ArrayList<Cell>();
        Cell[][] map = new Cell[this.current.getWidth()][this.current.getHeight()];
        int maximum_radius = 7;
        int[][] gradient = Static.getIntArray(Static.getSobelTransformed(this.current));
        boolean[][][] clustered = this.getClusteredHotspots(maximum_radius, gradient, 15000, 30000, 25.0, 4.0);
        ArrayList<Cell> candidates = new ArrayList<Cell>();
        ArrayList<Integer> scores = new ArrayList<Integer>();
        int r = maximum_radius - 1;
        while (r >= 3) {
            int hotspots = 0;
            int success = 0;
            int i = 0;
            while (i < clustered[r].length) {
                int j = 0;
                while (j < clustered[r][i].length) {
                    if (clustered[r][i][j]) {
                        ++hotspots;
                        int addIndex = 0;
                        while (addIndex < candidates.size()) {
                            if ((Integer)scores.get(addIndex) <= r) break;
                            ++addIndex;
                        }
                        candidates.add(addIndex, new Cell(this.index, -1, i, j, r));
                        scores.add(addIndex, r);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.debug) {
                System.err.println("Finished  r=" + r + " there were " + hotspots + " hotspots and " + success + " candidates");
            }
            --r;
        }
        int i = 0;
        while (i < candidates.size()) {
            Cell newSpot = (Cell)candidates.get(i);
            int r2 = (Integer)scores.get(i);
            int overlap = 0;
            for (DoublePoint dp : newSpot.points.get(this.index)) {
                if (map[(int)Math.min((double)(map.length - 1), Math.max(0.0, dp.x))][(int)Math.min(Math.max(0.0, dp.y), (double)(map[0].length - 1))] == null) continue;
                ++overlap;
            }
            if (overlap == 0) {
                int x = -r2;
                while (x <= r2) {
                    int y = -r2;
                    while (y <= r2) {
                        map[(int)Math.min((double)((double)(map.length - 1)), (double)Math.max((double)0.0, (double)(newSpot.getCOM((int)this.index).x + (double)x)))][(int)Math.min((double)Math.max((double)0.0, (double)(newSpot.getCOM((int)this.index).y + (double)y)), (double)((double)(map[0].length - 1)))] = newSpot;
                        ++y;
                    }
                    ++x;
                }
                newSpot.id = this.getNextId();
                list.add(newSpot);
            }
            ++i;
        }
        if (this.debug) {
            System.err.println("Finding all spots took " + (System.nanoTime() - time) / 1000000L + " miliseconds");
        }
        return list;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private void saveToCSV(String filename) {
        if (this.debug) {
            System.err.println("Saving cell properties to csv file.");
        }
        try {
            int maximum_frame = this.pngs.size();
            PrintWriter pw = new PrintWriter(filename);
            String header = "Frame#";
            int i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Score " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Area " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Mass " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Compactness " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",X Cell " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Y Cell " + (i + 1);
                ++i;
            }
            pw.println(header);
            int t = 0;
            while (t < maximum_frame) {
                if (this.debug) {
                    System.err.println(String.valueOf(t) + "/" + maximum_frame);
                }
                double[][] data = new double[this.cells.size()][6];
                int count = 0;
                StringBuilder sb = new StringBuilder(t + 1);
                for (Cell c : this.cells) {
                    if (c.getStats(t) != null) {
                        data[count][0] = c.getStats((int)t).fate_score;
                        data[count][1] = c.getStats((int)t).area;
                        data[count][2] = c.getStats((int)t).mass;
                        data[count][3] = c.getStats((int)t).compactness;
                        data[count][4] = c.getStats((int)t).x;
                        data[count][5] = c.getStats((int)t).y;
                    } else if (c.lastFrame(maximum_frame) < t) {
                        int tt = c.lastFrame(t);
                        try {
                            data[count][0] = c.getStats((int)tt).fate_score;
                            data[count][1] = c.getStats((int)tt).area;
                            data[count][2] = c.getStats((int)tt).mass;
                            data[count][3] = c.getStats((int)tt).compactness;
                            data[count][4] = c.getStats((int)tt).x;
                            data[count][5] = c.getStats((int)tt).y;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++count;
                }
                sb.append(t);
                int i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][0]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][1]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][3]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][4]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][5]);
                    ++i2;
                }
                pw.println(sb.toString());
                if (t % 10 == 0) {
                    this.info("Saved frame " + t + " to " + filename);
                }
                ++t;
            }
            if (this.debug) {
                System.err.println("Saved everything " + this.cells.size() + " cells and " + maximum_frame + " frames");
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new Tracker();
    }

    private class FComparator
    implements Comparator<File> {
        private FComparator() {
        }

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

