/*
 * Decompiled with CFR 0.152.
 */
package semiAmoebaTracker;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;

public class Dialogs {
    public static File getOpenFile(final String suffix, String title) {
        suffix.replaceAll("\\\\.", "");
        JFileChooser fc = new JFileChooser(".");
        fc.setDialogTitle(title);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().endsWith(suffix) || arg0.isDirectory();
            }

            @Override
            public String getDescription() {
                return suffix;
            }
        });
        if (fc.showOpenDialog(null) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File getSaveDir(String title) {
        JFileChooser fc = new JFileChooser(".");
        fc.setDialogTitle(title);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(1);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directory";
            }
        });
        if (fc.showSaveDialog(null) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File getSaveFile(final String suffix, String title) {
        JFileChooser fc = new JFileChooser(".");
        fc.setDialogTitle(title);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().endsWith(suffix) || arg0.isDirectory();
            }

            @Override
            public String getDescription() {
                return suffix;
            }
        });
        if (fc.showSaveDialog(null) == 0) {
            if (fc.getSelectedFile().getName().endsWith(suffix)) {
                return fc.getSelectedFile();
            }
            return new File(String.valueOf(fc.getSelectedFile().getAbsolutePath()) + "." + suffix);
        }
        return null;
    }

    public static File[] getOpenFiles(final String suffix, String title) {
        JFileChooser fc = new JFileChooser(".");
        fc.setDialogTitle(title);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().endsWith(suffix) || arg0.isDirectory();
            }

            @Override
            public String getDescription() {
                return suffix;
            }
        });
        if (fc.showOpenDialog(null) == 0) {
            return fc.getSelectedFiles();
        }
        return new File[0];
    }

    public static String getSelection(Iterator<String> selections, String prompt) {
        ArrayList<String> list = new ArrayList<String>();
        while (selections.hasNext()) {
            list.add(selections.next());
        }
        String s = (String)JOptionPane.showInputDialog(null, prompt, "Choose one:", -1, null, list.toArray(), "ham");
        return s;
    }

    public static double getDouble(String prompt, double min, double max, double step, double suggested) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(suggested, min, max, step));
        JComponent[] inputs = new JComponent[]{new JLabel(prompt), spinner};
        JOptionPane.showMessageDialog(null, inputs, "Double:", -1);
        return (Double)spinner.getValue();
    }

    public static int getInt(String prompt, int min, int max, int step, int suggested) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(suggested, min, max, step));
        JComponent[] inputs = new JComponent[]{new JLabel(prompt), spinner};
        JOptionPane.showMessageDialog(null, inputs, "Integer:", -1);
        return (Integer)spinner.getValue();
    }

    public static void showBackgroundMessage(String string) {
        JFrame frame = new JFrame("Message:");
        JLabel lbl = new JLabel(string);
        frame.getContentPane().add(lbl);
        frame.setSize(string.length() * 10, 50);
        frame.setResizable(false);
        frame.pack();
        frame.setVisible(true);
    }
}

