/*
 * Decompiled with CFR 0.152.
 */
package semiAmoebaTracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import semiAmoebaTracker.Cell;
import semiAmoebaTracker.CircleCandidate;
import semiAmoebaTracker.Dialogs;
import semiAmoebaTracker.Display;
import semiAmoebaTracker.DoublePoint;
import semiAmoebaTracker.ShortPoint;
import semiAmoebaTracker.Static;

public class Tracker
extends JFrame {
    Tracker self = this;
    BufferedImage current = null;
    BufferedImage sobelImage = null;
    int index = 0;
    int[][] gradient;
    boolean[][][] clusteredSpots;
    int[][] current_averages;
    int[][][] img_averages;
    int total_images_processed = 0;
    boolean escape_flag = false;
    private int id = 0;
    boolean applyMinMax = false;
    boolean color_by_score = false;
    boolean sobel = false;
    boolean continuousStitch = false;
    boolean endStitch = false;
    private static int minTrackLength = 0;
    boolean finished_task = true;
    boolean debug = true;
    File dir;
    ArrayList<File> pngs = new ArrayList();
    Display disp;
    Cell pick;
    Cell daughter1 = null;
    Cell daughter2 = null;
    boolean ctrl_down = false;
    boolean shift_down = false;
    HashSet<Cell> cells = new HashSet();
    HashMap<Integer, Cell> idmap = new HashMap();
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH-mm-ss";

    public int getNextId() {
        int result = this.id++;
        return result;
    }

    private void setDir(File d) {
        this.dir = d;
        this.pngs.clear();
        if (this.debug) {
            System.err.println("Found " + d.list().length + " files in dir " + d.getName());
        }
        String[] strs = d.list();
        File[] files = d.listFiles();
        int i = 0;
        while (i < files.length) {
            if (strs[i].endsWith("png") || strs[i].endsWith("PNG")) {
                this.pngs.add(files[i]);
            }
            ++i;
        }
        Collections.sort(this.pngs, new FComparator());
        this.img_averages = new int[this.pngs.size()][1][1];
    }

    private void setCurrent(int new_index, boolean fitting) {
        if ((new_index %= this.pngs.size()) < 0) {
            new_index = this.pngs.size() + new_index;
        }
        this.current = null;
        this.current = this.applyMinMax ? Static.adjustMinMax(this.getImage(new_index)) : this.getImage(new_index);
        this.sobelImage = Static.getNegative(this.current);
        if (fitting) {
            this.gradient = Static.getIntArray(this.sobelImage);
            this.clusteredSpots = Tracker.getClusteredHotspots(10, this.gradient, 38000, 45000, 5.0, 3.5);
        } else {
            this.gradient = null;
            this.clusteredSpots = null;
        }
        this.total_images_processed = Math.max(this.total_images_processed, new_index + 1);
        this.index = new_index;
        this.setTitle("TrackerMax by Shokhirev M., Signaling Systems Laboratory (C) 2013. Current Frame = " + this.index + "/" + this.pngs.size());
    }

    private void optimizeCellsToTracks() {
        HashMap<Cell, HashSet<Cell>> nearbys = new HashMap<Cell, HashSet<Cell>>();
        int t = 1;
        while (t < this.pngs.size()) {
            if (this.escape_flag) {
                this.escape_flag = false;
                break;
            }
            this.setCurrent(t, true);
            nearbys.clear();
            ArrayList<Cell> currentCells = new ArrayList<Cell>();
            for (Cell c : this.cells) {
                if (c.getWaypointPosition(t) == null) continue;
                currentCells.add((int)(Math.random() * (double)currentCells.size()), c);
            }
            for (Cell c : currentCells) {
                c.prepareOptimization(t, this.gradient, this.clusteredSpots, c.getWaypointPosition(this.index));
                if (c.getPoints(t) != null) {
                    nearbys.put(c, this.getNearby(c, 10, t));
                    continue;
                }
                currentCells.remove(c);
            }
            boolean changing = true;
            while (changing) {
                changing = false;
                Collections.shuffle(currentCells);
                for (Cell c : currentCells) {
                    int result = c.iterate(this.gradient, (Collection)nearbys.get(c), t, c.getWaypointPosition(t));
                    if (result != 1) continue;
                    changing = true;
                }
                boolean drawing = false;
                if (!drawing) continue;
                this.paint();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (Cell c : currentCells) {
                c.finalize(this.current, t, 1.0f);
            }
            this.info("Finished optimizing for frame = " + t);
            ++t;
        }
    }

    private ArrayList<Cell> findAllCells() {
        long time = System.nanoTime();
        ArrayList<Cell> list = new ArrayList<Cell>();
        Cell[][] map = new Cell[this.current.getWidth()][this.current.getHeight()];
        int maximum_radius = 10;
        ArrayList<CircleCandidate> candidates = new ArrayList<CircleCandidate>();
        if (this.clusteredSpots == null) {
            this.setCurrent(this.index, true);
        }
        int r = maximum_radius - 1;
        while (r >= 3) {
            int j;
            int hotspots = 0;
            int success = 0;
            LinkedList<ShortPoint> circlePoints = new LinkedList<ShortPoint>();
            int i = -r;
            while (i <= r) {
                j = -r;
                while (j <= r) {
                    int cradius = (int)Math.round(Math.sqrt(i * i + j * j));
                    if (cradius == r) {
                        circlePoints.add(new ShortPoint(i, j));
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.clusteredSpots[r].length) {
                j = 0;
                while (j < this.clusteredSpots[r][i].length) {
                    if (this.clusteredSpots[r][i][j]) {
                        ++hotspots;
                        ArrayList<Integer> gradients = new ArrayList<Integer>();
                        for (ShortPoint sp : circlePoints) {
                            try {
                                int edgeness = this.gradient[sp.x + i][sp.y + j];
                                int ind = 0;
                                while (ind < gradients.size()) {
                                    if ((Integer)gradients.get(ind) > edgeness) break;
                                    ++ind;
                                }
                                gradients.add(ind, edgeness);
                            }
                            catch (Exception edgeness) {
                                // empty catch block
                            }
                        }
                        double score = r * (Integer)gradients.get(gradients.size() / 3);
                        if ((Integer)gradients.get(gradients.size() / 3) > 25000 && (Integer)gradients.get(gradients.size() - 1) > 45000) {
                            int ind = 0;
                            while (ind < candidates.size()) {
                                if (((CircleCandidate)candidates.get((int)ind)).score < score) break;
                                ++ind;
                            }
                            candidates.add(ind, new CircleCandidate(i, j, r, score));
                            System.err.println("r=" + r + " passed with score " + score + " gradients/3=" + gradients.get(gradients.size() / 3) + " max gradient: " + gradients.get(gradients.size() - 1));
                        } else {
                            System.err.println("r=" + r + " FAILED with score " + score + " gradients/3=" + gradients.get(gradients.size() / 3) + " max gradient: " + gradients.get(gradients.size() - 1));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (this.debug) {
                System.err.println("Finished  r=" + r + " there were " + hotspots + " hotspots and " + success + " candidates");
            }
            --r;
        }
        int i = 0;
        while (i < candidates.size()) {
            Cell newSpot = new Cell(this, this.gradient, this.clusteredSpots, this.index, this.getNextId(), ((CircleCandidate)candidates.get((int)i)).x, ((CircleCandidate)candidates.get((int)i)).y, ((CircleCandidate)candidates.get((int)i)).r);
            int overlap = 0;
            for (DoublePoint dp : newSpot.points.get(this.index)) {
                if (map[(int)Math.min((double)(map.length - 1), Math.max(0.0, dp.x))][(int)Math.min(Math.max(0.0, dp.y), (double)(map[0].length - 1))] == null) continue;
                ++overlap;
            }
            if (map[(int)Math.min((double)(map.length - 1), Math.max(0.0, newSpot.getCenter((int)this.index).x))][(int)Math.min(Math.max(0.0, newSpot.getCenter((int)this.index).y), (double)(map[0].length - 1))] != null) {
                ++overlap;
            }
            if (overlap == 0) {
                int r2 = ((CircleCandidate)candidates.get((int)i)).r;
                int x = -r2;
                while (x <= r2) {
                    int y = -r2;
                    while (y <= r2) {
                        map[(int)Math.min((double)((double)(map.length - 1)), (double)Math.max((double)0.0, (double)(newSpot.getCOM((int)this.index).x + (double)x)))][(int)Math.min((double)Math.max((double)0.0, (double)(newSpot.getCOM((int)this.index).y + (double)y)), (double)((double)(map[0].length - 1)))] = newSpot;
                        ++y;
                    }
                    ++x;
                }
                list.add(newSpot);
            }
            ++i;
        }
        if (this.debug) {
            System.err.println("Finding all spots took " + (System.nanoTime() - time) / 1000000L + " miliseconds");
        }
        return list;
    }

    public Tracker() {
        this.initialize();
    }

    public void addCell(Cell c) {
        this.cells.add(c);
        this.idmap.put(c.id, c);
    }

    public Cell getCellById(int cellid) {
        return this.idmap.get(cellid);
    }

    private BufferedImage getImage(int index) {
        if (this.dir != null) {
            try {
                return Static.getGrayscale(ImageIO.read(this.pngs.get(index % this.pngs.size())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void saveImages() {
        File dir = Dialogs.getSaveDir("Save images to dir");
        int i = 0;
        while (i < this.pngs.size()) {
            this.setCurrent(i, false);
            BufferedImage img = this.getImage(i);
            BufferedImage ioimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Static.paintOnGraphics((Graphics2D)ioimg.getGraphics(), img, false, true, true, true, false, null, 1.0, 0, 0, this.cells, this.index, this.pick);
            try {
                ImageIO.write((RenderedImage)ioimg, "PNG", new File(String.valueOf(dir.getAbsolutePath()) + File.separator + this.pngs.get(i).getName() + "_processed_" + String.format("%4d.png", i)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.info("Saved all images!");
    }

    private void info(String string) {
        this.disp.addMessage(string);
        this.paint();
    }

    private void initialize() {
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("Load");
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        boolean loading = true;
        while (loading) {
            int val = fc.showOpenDialog(this);
            if (val != 0 || !fc.getSelectedFile().isDirectory()) continue;
            this.setDir(fc.getSelectedFile());
            this.setCurrent(0, false);
            loading = false;
        }
        if (this.disp == null) {
            this.disp = new Display(this);
        }
        this.disp.addMessage("Welcome to TrackerMax 2013! Get ready to track some cells!");
        this.disp.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Tracker.this.ctrl_down = arg0.isControlDown();
                Tracker.this.shift_down = arg0.isShiftDown();
            }

            @Override
            public void keyReleased(final KeyEvent arg0) {
                if (arg0.getKeyCode() == 27 || arg0.getKeyCode() == 73 || arg0.getKeyCode() == 84 || arg0.getKeyCode() == 71 || Tracker.this.finished_task) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            (this).Tracker.this.finished_task = false;
                            (this).Tracker.this.ctrl_down = arg0.isControlDown();
                            (this).Tracker.this.shift_down = arg0.isShiftDown();
                            if (arg0.getKeyCode() == 68) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 1, false);
                                if ((this).Tracker.this.pick != null) {
                                    // empty if block
                                }
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 69) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 5, false);
                                if ((this).Tracker.this.pick != null) {
                                    // empty if block
                                }
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 33) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 25, false);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 65) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 1, false);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 81) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 5, false);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 34) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 25, false);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 114) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.sobel = !(this).Tracker.this.sobel;
                                System.err.println("Sobel is now " + (this).Tracker.this.sobel);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 73) {
                                (this).Tracker.this.disp.toggleImage();
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 84) {
                                (this).Tracker.this.disp.showAllTraces = !(this).Tracker.this.disp.showAllTraces;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 71) {
                                (this).Tracker.this.disp.showTags = !(this).Tracker.this.disp.showTags;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.goodOnly = !(this).Tracker.this.disp.goodOnly;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 32) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent(0, false);
                                Tracker.this.info("Back to frame 0");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 35) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.pngs.size() - 1, false);
                                Tracker.this.info("To the end");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 27) {
                                (this).Tracker.this.escape_flag = true;
                                Tracker.this.info("Escape flag is set!");
                            }
                            if (arg0.getKeyCode() == 120) {
                                Tracker.this.saveImages();
                            }
                            if (arg0.getKeyCode() == 112) {
                                Tracker.this.setCursor(3);
                                Tracker.this.loadEverything(Dialogs.getOpenFile("dat", "load all cells from file"));
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 87) {
                                Tracker.this.setCursor(3);
                                Cell best = null;
                                int earliest_waypoint = 999999;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end >= earliest_waypoint || c.Tdiv != -1 || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint, false);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 70) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.cells.clear();
                                for (Cell c : Tracker.this.findAllCells()) {
                                    Tracker.this.addCell(c);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 113) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.applyMinMax = !(this).Tracker.this.applyMinMax;
                                Tracker.this.info("Gamma correction is " + (this).Tracker.this.applyMinMax);
                                Tracker.this.setCurrent((this).Tracker.this.index, false);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 115) {
                                (this).Tracker.this.color_by_score = !(this).Tracker.this.color_by_score;
                                Tracker.this.info("Set color by score to: " + (this).Tracker.this.color_by_score);
                            }
                            if (arg0.getKeyCode() == 116) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveEverything(Dialogs.getSaveFile("dat", "Save all cells to file"));
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 117) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveToCSV(Dialogs.getSaveFile("csv", "Save all cell stats to file").getAbsolutePath());
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 118) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 82 && (this).Tracker.this.shift_down) {
                                Tracker.this.setCursor(3);
                                Tracker.this.optimizeCellsToTracks();
                                Tracker.this.setCursor(0);
                            }
                            (this).Tracker.this.finished_task = true;
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.disp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                int clickx = (int)Math.round((double)arg0.getX() / Tracker.this.disp.zoom);
                int clicky = (int)Math.round((double)arg0.getY() / Tracker.this.disp.zoom);
                if (arg0.getButton() == 1) {
                    if (Tracker.this.pick != null) {
                        if (!Tracker.this.ctrl_down && !Tracker.this.shift_down) {
                            Tracker.this.pick.addWaypoint(Tracker.this.index, clickx, clicky);
                            Tracker.this.paint();
                        } else if (Tracker.this.shift_down && !Tracker.this.ctrl_down) {
                            Tracker.this.pick.removeWaypoint(Tracker.this.index);
                            Tracker.this.paint();
                        } else if (Tracker.this.ctrl_down && Tracker.this.shift_down) {
                            if (Tracker.this.daughter1 == null) {
                                Tracker.this.daughter1 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                            } else {
                                Tracker.this.daughter2 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                                Tracker.this.addCell(Tracker.this.daughter1);
                                Tracker.this.addCell(Tracker.this.daughter2);
                                Tracker.this.daughter2 = null;
                                Tracker.this.daughter1 = null;
                                Tracker.this.pick.Tdiv = Tracker.this.index;
                                Tracker.this.paint();
                            }
                        }
                    }
                } else if (arg0.getButton() == 3) {
                    if (arg0.getClickCount() == 1) {
                        Tracker.this.pick = null;
                        for (Cell c : Tracker.this.cells) {
                            if (!c.insideSimple(clickx, clicky, Tracker.this.index)) continue;
                            Tracker.this.pick = c;
                            break;
                        }
                        if (Tracker.this.pick != null) {
                            Tracker.this.info("Amoeba: " + Tracker.this.pick.id + " X:" + Tracker.this.pick.getCOM((int)Tracker.this.index).x + " Y:" + Tracker.this.pick.getCOM((int)Tracker.this.index).y + " A:" + Tracker.this.pick.getArea(Tracker.this.index));
                            Tracker.this.setTitle("Placing cell " + Tracker.this.pick.id + " x: " + Tracker.this.pick.getCOM((int)Tracker.this.index).x + " y: " + Tracker.this.pick.getCOM((int)Tracker.this.index).y + " area: " + Tracker.this.pick.getArea(Tracker.this.index));
                        }
                        Tracker.this.paint();
                    } else if (arg0.getClickCount() == 2) {
                        if (Tracker.this.debug) {
                            System.err.println("Adding new cell");
                        }
                        if (Tracker.this.gradient == null) {
                            Tracker.this.setCurrent(Tracker.this.index, true);
                        }
                        Cell newcell = new Cell(Tracker.this.self, Tracker.this.gradient, Tracker.this.clusteredSpots, Tracker.this.index, Tracker.this.getNextId(), (short)clickx, (short)clicky);
                        Tracker.this.addCell(newcell);
                        Tracker.this.pick = newcell;
                        Tracker.this.pick.finalize(Tracker.this.current, Tracker.this.index, 1.0f);
                        Tracker.this.setTitle("Created new cell for tracking: " + Tracker.this.pick.id);
                        Tracker.this.disp.updateUI();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.disp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                try {
                    Tracker.this.disp.zoom = e.getWheelRotation() > 0 ? (Tracker.this.disp.zoom *= 1.5) : (Tracker.this.disp.zoom /= 1.5);
                    Tracker.this.disp.zoom = Math.max(0.05, Math.min(20.0, Tracker.this.disp.zoom));
                    Tracker.this.disp.setPreferredSize(new Dimension((int)((double)Tracker.this.current.getWidth() * Tracker.this.disp.zoom), (int)((double)Tracker.this.current.getHeight() * Tracker.this.disp.zoom)));
                    Tracker.this.self.setPreferredSize(new Dimension(Tracker.this.self.getWidth(), Tracker.this.self.getHeight()));
                    Tracker.this.self.pack();
                    Tracker.this.paint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.disp.setPreferredSize(new Dimension(this.current.getWidth(), this.current.getHeight()));
        cp.add((Component)this.disp, "Center");
        cp.invalidate();
        this.pack();
        this.disp.requestFocus();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("TrackerMax by Max Shokhirev 2013. Signaling Systems Laboratory");
        this.setVisible(true);
    }

    private HashSet<Cell> getNearby(Cell cell, int distance, int time) {
        HashSet<Cell> nearby = new HashSet<Cell>();
        for (Cell c : this.cells) {
            if (!c.exists(time) || !(c.getCOM(time).squaredDistance(cell.getCOM(time)) <= (double)(distance * distance))) continue;
            nearby.add(c);
        }
        return nearby;
    }

    private void paint() {
        this.disp.paintImmediately(0, 0, this.disp.getWidth(), this.disp.getHeight());
    }

    private void saveEverything(File saveFile) {
        try {
            PrintWriter pw = new PrintWriter(saveFile);
            for (Cell c : this.cells) {
                if (c.lifeSpan(this.pngs.size() - 1) <= 20) continue;
                c.saveSelf(pw);
            }
            pw.close();
            if (this.debug) {
                System.err.println("Saved everything");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadEverything(File openFile) {
        try {
            Scanner s = new Scanner(openFile);
            this.cells.clear();
            while (s.hasNextLine()) {
                Cell c = new Cell(this.self, s);
                this.addCell(c);
                if (this.cells.size() % 10 != 0) continue;
                this.info("Loaded " + this.cells.size() + " cells.");
            }
            this.disp.updateUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean[][][] getClusteredHotspots(int maximum_radius, int[][] gradient, int edge_threshold, int accumulator_threshold, double min_vote, double vote_per_r) {
        int[][][] accumulator = new int[maximum_radius + 1][gradient.length][gradient[0].length];
        LinkedList<ShortPoint> edgePixels = new LinkedList<ShortPoint>();
        int i = 0;
        while (i < gradient.length) {
            int j = 0;
            while (j < gradient[i].length) {
                if (gradient[i][j] > edge_threshold) {
                    edgePixels.add(new ShortPoint(i, j));
                }
                ++j;
            }
            ++i;
        }
        System.err.println("There were " + edgePixels.size() + " edge pixels found");
        ArrayList circlePoints = new ArrayList();
        int rr = 0;
        while (rr < maximum_radius) {
            circlePoints.add(new LinkedList());
            ++rr;
        }
        int i2 = -maximum_radius;
        while (i2 <= maximum_radius) {
            int j = -maximum_radius;
            while (j <= maximum_radius) {
                int r = (int)Math.round(Math.sqrt(i2 * i2 + j * j));
                if (r <= maximum_radius && r > 0) {
                    ((LinkedList)circlePoints.get(r - 1)).add(new ShortPoint(i2, j));
                }
                ++j;
            }
            ++i2;
        }
        int r = 1;
        while (r <= maximum_radius) {
            LinkedList points = (LinkedList)circlePoints.get(r - 1);
            for (ShortPoint point : edgePixels) {
                for (ShortPoint sp : points) {
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x + 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x - 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y + 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y - 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            System.err.println("Done with radius: " + r + " with a total of " + edgePixels.size());
            ++r;
        }
        boolean[][][] clustered = new boolean[maximum_radius + 1][gradient.length][gradient[0].length];
        int r2 = maximum_radius - 1;
        while (r2 >= 1) {
            int hotspots = 0;
            int threshold = (int)(min_vote + vote_per_r * Math.PI * (double)r2);
            int i3 = 0;
            while (i3 < accumulator[r2].length) {
                int j = 0;
                while (j < accumulator[r2][i3].length) {
                    if (accumulator[r2][i3][j] > threshold) {
                        LinkedList<ShortPoint> hotspot = Static.floodFillThreshold(accumulator[r2], gradient, i3, j, threshold, accumulator_threshold);
                        double centerx = 0.0;
                        double centery = 0.0;
                        for (ShortPoint sp : hotspot) {
                            centerx += (double)sp.x;
                            centery += (double)sp.y;
                            accumulator[r2][sp.x][sp.y] = 0;
                        }
                        int x = (int)Math.round(centerx / (double)hotspot.size());
                        int y = (int)Math.round(centery / (double)hotspot.size());
                        if (hotspot.size() > 1) {
                            clustered[r2][x][y] = true;
                            ++hotspots;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            System.err.println("r=" + r2 + "Found " + hotspots + " hotspots");
            --r2;
        }
        return clustered;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private void saveToCSV(String filename) {
        if (this.debug) {
            System.err.println("Saving cell properties to csv file.");
        }
        try {
            int maximum_frame = this.pngs.size();
            PrintWriter pw = new PrintWriter(filename);
            String header = "Frame#";
            int i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Score " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Area " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Mass " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Compactness " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",X Cell " + (i + 1);
                ++i;
            }
            i = 0;
            while (i < this.cells.size()) {
                header = String.valueOf(header) + ",Y Cell " + (i + 1);
                ++i;
            }
            pw.println(header);
            int t = 0;
            while (t < maximum_frame) {
                if (this.debug) {
                    System.err.println(String.valueOf(t) + "/" + maximum_frame);
                }
                double[][] data = new double[this.cells.size()][6];
                int count = 0;
                StringBuilder sb = new StringBuilder(t + 1);
                for (Cell c : this.cells) {
                    if (c.getStats(t) != null) {
                        data[count][0] = c.getStats((int)t).fate_score;
                        data[count][1] = c.getStats((int)t).area;
                        data[count][2] = c.getStats((int)t).mass;
                        data[count][3] = c.getStats((int)t).compactness;
                        data[count][4] = c.getStats((int)t).x;
                        data[count][5] = c.getStats((int)t).y;
                    } else if (c.lastFrame(maximum_frame) < t) {
                        int tt = c.lastFrame(t);
                        try {
                            data[count][0] = c.getStats((int)tt).fate_score;
                            data[count][1] = c.getStats((int)tt).area;
                            data[count][2] = c.getStats((int)tt).mass;
                            data[count][3] = c.getStats((int)tt).compactness;
                            data[count][4] = c.getStats((int)tt).x;
                            data[count][5] = c.getStats((int)tt).y;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++count;
                }
                sb.append(t);
                int i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][0]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][1]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][3]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][4]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i2][5]);
                    ++i2;
                }
                pw.println(sb.toString());
                if (t % 10 == 0) {
                    this.info("Saved frame " + t + " to " + filename);
                }
                ++t;
            }
            if (this.debug) {
                System.err.println("Saved everything " + this.cells.size() + " cells and " + maximum_frame + " frames");
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new Tracker();
    }

    private class FComparator
    implements Comparator<File> {
        private FComparator() {
        }

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

