/*
 * Decompiled with CFR 0.152.
 */
package semiTracker2;

import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Scanner;
import semiTracker2.CellStatistics;
import semiTracker2.CircleCandidate;
import semiTracker2.DoublePoint;
import semiTracker2.ShortPoint;
import semiTracker2.Static;
import semiTracker2.Tracker;
import semiTracker2.Waypoint;

public class Cell
implements Cloneable {
    private static final int pcount = 10;
    HashMap<Integer, ArrayList<DoublePoint>> points = new HashMap();
    LinkedList<Double> areas = new LinkedList();
    int window = 10;
    double avgArea = 0.0;
    ArrayList<DoublePoint> vs = new ArrayList();
    HashMap<Integer, CellStatistics> stats = new HashMap();
    ArrayList<Waypoint> waypoints = new ArrayList();
    Tracker track = null;
    int Tdiv = -1;
    int Tdie = -1;
    int Tgone = -1;
    int Tbirth = -1;
    int Tenter = -1;
    int id;
    int gen = 0;
    int motherId = -1;
    int iterations = 0;
    double expectedArea = 50.0;
    boolean debug = false;
    private static final int SearchRadius = 5;

    public int iterate(int[][] field, Collection<Cell> nearby, int index, DoublePoint to) {
        ++this.iterations;
        DoublePoint center = this.getCenter(index);
        boolean changing = false;
        double expectedRadius = Math.sqrt(this.avgArea / 2.7);
        double currentArea = this.getArea(index);
        double squaredSearch = 25.0;
        int p = 0;
        while (p < 10) {
            DoublePoint dp = this.points.get(index).get(p);
            DoublePoint force = DoublePoint.getORIGIN();
            int scount = 0;
            int i = -5;
            while (i <= 5) {
                int j = -5;
                while (j <= 5) {
                    DoublePoint delta = new DoublePoint(i, j);
                    if (delta.squaredDistance(0.0, 0.0) <= squaredSearch) {
                        try {
                            force.add(delta.normalized().scale((double)field[(int)(dp.x + delta.x)][(int)(dp.y + delta.y)] / (1.0 + delta.squaredDistance(0.0, 0.0))));
                            ++scount;
                        }
                        catch (Exception e) {
                            force.add(delta.normalized().scale(10000.0 / (1.0 + delta.squaredDistance(0.0, 0.0))));
                            ++scount;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            force.multiply(1.0 / (1.0 + (double)(scount * 1000)));
            DoublePoint dcenter = center.minus(dp);
            double currentRadius = dcenter.magnitude();
            if (currentArea < this.avgArea * 0.9 || currentRadius < expectedRadius * 0.9) {
                force.add(dcenter.normalized().scale(-0.5));
            } else if (currentArea > this.avgArea * 1.3 || currentRadius > expectedRadius * 1.2) {
                force.add(dcenter.normalized().scale(0.5));
            }
            force.add(dcenter.normalized().scale(-0.5));
            int left = p - 1;
            if (left < 0) {
                left = this.points.get(index).size() - 1;
            }
            int right = (p + 1) % this.points.get(index).size();
            DoublePoint dp2 = this.points.get(index).get(left);
            double d = dp.distanceTo(dp2);
            double theta = 0.7853981633974483;
            double l = expectedRadius * (-Math.cos(theta) + 1.0) * 1.0;
            double ddl = Math.pow(d - l, 2.0);
            double kpoint = 0.5;
            if (d - l > 0.0) {
                force.add(dp2.minus(dp).normalized().scale(kpoint * ddl));
            } else {
                force.add(dp2.minus(dp).normalized().scale(-kpoint * ddl));
            }
            dp2 = this.points.get(index).get(right);
            d = dp.distanceTo(dp2);
            double ddr = Math.pow(d - l, 2.0);
            if (d - l > 0.0) {
                force.add(dp2.minus(dp).normalized().scale(kpoint * ddr));
            } else {
                force.add(dp2.minus(dp).normalized().scale(-kpoint * ddr));
            }
            if (to != null) {
                force.add(to.minus(center).scale(0.001 * to.squaredDistance(center)));
            }
            if (nearby != null) {
                for (Cell a : nearby) {
                    if (a.id == this.id) continue;
                    DoublePoint acenter = a.getCenter(index);
                    double sd = acenter.squaredDistance(dp);
                    force.add(dp.minus(acenter).normalized().scale(20.0 / (1.0 + sd * sd)));
                    force.add(center.minus(acenter).normalized().scale(20.0 / (1.0 + acenter.squaredDistance(center))));
                }
            }
            if (Double.isNaN(force.x) || Double.isNaN(force.y)) {
                return -1;
            }
            this.vs.get(p).add(force);
            this.vs.get(p).multiply(10.0 / (double)(9 + this.iterations));
            if (this.vs.get(p).magnitude() > 0.5) {
                this.vs.get(p).multiply(0.5 / this.vs.get(p).magnitude());
            }
            dp.add(this.vs.get(p));
            if (this.vs.get(p).magnitude() > 0.3) {
                changing = true;
            }
            if (this.debug) {
                System.err.println(String.valueOf(p) + "=" + dp.toString() + ":" + this.vs.get(p).toString() + ":" + force.toString() + " currentR " + dp.distanceTo(center));
            }
            ++p;
        }
        if (changing) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareOptimization(int index, int[][] gradient, boolean[][][] clusteredSpots, DoublePoint pointOfInterest) {
        ArrayList list;
        ArrayList arrayList = list = new ArrayList();
        synchronized (arrayList) {
            int last_frame = this.lastFrame(index - 1);
            this.iterations = 0;
            this.areas.clear();
            if (index != this.Tbirth) {
                this.avgArea = 0.0;
                int i = 1;
                while (i < this.window) {
                    double a = this.getArea(last_frame - i);
                    if (a > 0.0) {
                        this.areas.add(a);
                        this.avgArea += a;
                    }
                    ++i;
                }
                this.avgArea /= (double)this.areas.size();
            } else {
                Cell mother = this.track.getCellById(this.motherId);
                this.avgArea = mother.getArea(mother.lastFrame(index));
            }
            int avgR = (int)Math.round(Math.sqrt(this.avgArea / 3.0));
            this.jumpToBestSpotNearby(gradient, clusteredSpots, (int)Math.round(pointOfInterest.x), (int)Math.round(pointOfInterest.y), 7, index, avgR - 1, avgR + 5);
            this.expectedArea = this.getArea(index);
            this.avgArea = (this.avgArea + this.expectedArea) / 2.0;
            this.vs.clear();
            if (this.vs.size() == 10) {
                int i = 0;
                while (i < 10) {
                    this.vs.get((int)i).x = 0.0;
                    this.vs.get((int)i).y = 0.0;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < 10) {
                    this.vs.add(DoublePoint.getORIGIN());
                    ++i;
                }
            }
        }
    }

    public void jumpToBestSpotNearby(int[][] gradient, boolean[][][] hotspots, int x, int y, int radius, int index, int minR, int maxR) {
        x = Math.abs(x);
        y = Math.abs(y);
        int lastIndex = this.lastFrame(index - 1);
        double lastA = this.getArea(lastIndex);
        double lastRadius = Math.sqrt(lastA / Math.PI);
        if (lastIndex == -1) {
            lastRadius = 3.0;
        }
        ArrayList<CircleCandidate> candidates = new ArrayList<CircleCandidate>();
        int r = Math.max(3, minR);
        while (r <= Math.min(hotspots.length - 1, maxR)) {
            int j;
            LinkedList<ShortPoint> circlePoints = new LinkedList<ShortPoint>();
            int i = -r;
            while (i <= r) {
                j = -r;
                while (j <= r) {
                    int cradius = (int)Math.round(Math.sqrt(i * i + j * j));
                    if (cradius == r) {
                        circlePoints.add(new ShortPoint(i, j));
                    }
                    ++j;
                }
                ++i;
            }
            i = Math.max(0, x - radius);
            while (i < Math.min(hotspots[r].length - 1, x + radius)) {
                j = Math.max(0, y - radius);
                while (j < Math.min(hotspots[r].length - 1, y + radius)) {
                    try {
                        if (hotspots[r][i][j]) {
                            int ind;
                            ArrayList<Integer> gradients = new ArrayList<Integer>();
                            for (ShortPoint sp : circlePoints) {
                                try {
                                    int edgeness = gradient[sp.x + i][sp.y + j];
                                    ind = 0;
                                    while (ind < gradients.size()) {
                                        if ((Integer)gradients.get(ind) > edgeness) break;
                                        ++ind;
                                    }
                                    gradients.add(ind, edgeness);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            DoublePoint vector = new DoublePoint(x, y);
                            if ((Integer)gradients.get(gradients.size() / 2) > 11000) {
                                double score = (double)(r * r * (Integer)gradients.get(gradients.size() / 2)) / (5.0 + vector.squaredDistance(i, j));
                                ind = 0;
                                while (ind < candidates.size()) {
                                    if (((CircleCandidate)candidates.get((int)ind)).score > score) break;
                                    ++ind;
                                }
                                candidates.add(ind, new CircleCandidate(i, j, r, score));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
            ++r;
        }
        if (candidates.size() == 0) {
            candidates.add(new CircleCandidate(x, y, (int)lastRadius, 3.0));
        }
        ArrayList<DoublePoint> list = new ArrayList<DoublePoint>();
        CircleCandidate cc = (CircleCandidate)candidates.get(candidates.size() - 1);
        cc.r = (int)((double)cc.r + 0.5);
        double theta = 0.0;
        while (theta < Math.PI * 2) {
            list.add(new DoublePoint((double)cc.x + (double)cc.r * Math.cos(theta), (double)cc.y + (double)cc.r * Math.sin(theta)));
            theta += 0.6283185307179586;
        }
        this.points.put(index, list);
    }

    public DoublePoint getCOM(int index) {
        ArrayList<DoublePoint> pixs = this.points.get(index);
        if (pixs == null) {
            return null;
        }
        return this.getCOMPixels(pixs);
    }

    public boolean insideSimple(double x, double y, int index) {
        try {
            double max_radius = 0.0;
            DoublePoint center = this.getCenter(index);
            for (DoublePoint dp : this.points.get(index)) {
                double r = dp.squaredDistance(center);
                if (!(r > max_radius)) continue;
                max_radius = r;
            }
            return center.squaredDistance(x, y) <= max_radius;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean inside(double x, double y, int index) {
        if (this.points.get(index) != null) {
            int left = 0;
            int right = 0;
            int i = 0;
            while (i < this.points.get(index).size() - 1) {
                int result = this.intersect(this.points.get((Object)Integer.valueOf((int)index)).get((int)i).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)i).y, this.points.get((Object)Integer.valueOf((int)index)).get((int)(i + 1)).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)(i + 1)).y, x, y);
                if (result == -1) {
                    ++left;
                } else if (result == 1) {
                    ++right;
                } else if (result == 0) {
                    return true;
                }
                ++i;
            }
            int result = this.intersect(this.points.get((Object)Integer.valueOf((int)index)).get((int)(this.points.get((Object)Integer.valueOf((int)index)).size() - 1)).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)(this.points.get((Object)Integer.valueOf((int)index)).size() - 1)).y, this.points.get((Object)Integer.valueOf((int)index)).get((int)0).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)0).y, x, y);
            if (result == -1) {
                ++left;
            } else if (result == 1) {
                ++right;
            } else if (result == 0) {
                return true;
            }
            return left % 2 == 1 && right % 2 == 1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int intersect(double x1, double y1, double x2, double y2, double x, double y) {
        if (x2 != x1 && y2 != y1) {
            double yint = y;
            double m = (y2 - y1) / (x2 - x1);
            double b = y1 - m * x1;
            double xint = (yint - b) / m;
            if (!(xint >= Math.min(x2, x1)) || !(xint <= Math.max(x2, x1))) return -3;
            if (xint < x) {
                return -1;
            }
            if (!(xint > x)) return 0;
            return 1;
        }
        if (x2 == x1) {
            if (!(y <= Math.max(y1, y2)) || !(y >= Math.min(y1, y2))) return -3;
            if (x1 < x) {
                return -1;
            }
            if (x1 > x) {
                return 1;
            }
            if (x1 != x) return 0;
            return 0;
        }
        if (y1 != y2) return 0;
        if (!(x <= Math.max(x1, x2)) || !(x >= Math.min(x1, x2))) return -3;
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DoublePoint getCOMPixels(ArrayList<DoublePoint> pts) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<DoublePoint> arrayList = pts;
        synchronized (arrayList) {
            for (DoublePoint dp : pts) {
                x += dp.x;
                y += dp.y;
            }
        }
        return new DoublePoint(x / (double)pts.size(), y / (double)pts.size());
    }

    public CellStatistics getStats(int index) {
        if (this.stats.get(index) != null) {
            return this.stats.get(index);
        }
        return null;
    }

    private void updateAvgArea(double newArea) {
        this.avgArea = this.areas.size() == this.window ? (this.avgArea * (double)this.window - this.areas.removeFirst() + newArea) / (double)this.window : (this.avgArea * (double)this.areas.size() + newArea) / (double)(this.areas.size() + 1);
        this.areas.addLast(newArea);
    }

    public Cell(Tracker track, int[][] gradient, boolean[][][] hotspots, int index, int id, int x, int y) {
        this.track = track;
        this.Tenter = index;
        this.id = id;
        this.jumpToBestSpotNearby(gradient, hotspots, x, y, 5, index, 2, 10);
    }

    public Cell(Tracker track, int[][] gradient, boolean[][][] hotspots, int index, int id, int x, int y, int radius) {
        this.track = track;
        this.Tenter = index;
        this.id = id;
        this.jumpToBestSpotNearby(gradient, hotspots, x, y, 5, index, radius, radius);
    }

    public Cell(int index, int id, int x, int y, Cell mother) {
        this.track = mother.track;
        this.Tbirth = index;
        mother.Tdiv = index;
        this.id = id;
        this.motherId = mother.id;
        this.gen = mother.gen + 1;
        this.waypoints.add(new Waypoint(index, index, x, y, x, y));
    }

    public Cell(Tracker track, Scanner s) {
        this.track = track;
        try {
            String[] split;
            String[] header = s.nextLine().split(",");
            this.id = Integer.parseInt(header[0]);
            this.Tdiv = Integer.parseInt(header[1]);
            this.Tdie = Integer.parseInt(header[2]);
            this.Tgone = Integer.parseInt(header[3]);
            this.Tbirth = Integer.parseInt(header[4]);
            this.Tenter = Integer.parseInt(header[5]);
            this.gen = Integer.parseInt(header[6]);
            this.motherId = Integer.parseInt(header[7]);
            String line = s.nextLine();
            while (line.compareTo("PIXELS") != 0) {
                if (line.length() > 0) {
                    split = line.split(",");
                    this.stats.put(Integer.parseInt(split[0]), new CellStatistics(Float.parseFloat(split[1]), Short.parseShort(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]), Short.parseShort(split[5]), Short.parseShort(split[6]), Short.parseShort(split[7]), Float.parseFloat(split[8])));
                }
                line = s.nextLine();
            }
            line = s.nextLine();
            while (line.compareTo("WAYPOINTS") != 0 && line.compareTo("END CELL") != 0) {
                split = line.split(",");
                ArrayList<DoublePoint> list = new ArrayList<DoublePoint>();
                int i = 1;
                while (i < split.length - 1) {
                    list.add(new DoublePoint(Double.parseDouble(split[i]), Double.parseDouble(split[i + 1])));
                    i += 2;
                }
                this.points.put(Integer.parseInt(split[0]), list);
                line = s.nextLine();
            }
            if (line.compareTo("WAYPOINTS") == 0) {
                line = s.nextLine();
                while (line.compareTo("END CELL") != 0) {
                    split = line.split(",");
                    Waypoint w = new Waypoint(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]));
                    this.waypoints.add(w);
                    line = s.nextLine();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error when reading a cell from file: " + e.getMessage());
        }
    }

    public void removeWaypoint(int t) {
        int insert = 0;
        while (insert < this.waypoints.size()) {
            if (this.waypoints.get(insert).contains(t)) {
                if (insert > 0 && insert < this.waypoints.size() - 1) {
                    Waypoint before = this.waypoints.get(insert - 1);
                    Waypoint after = this.waypoints.get(insert + 1);
                    int x = (before.x2 + after.x1) / 2;
                    int y = (before.y2 + after.y1) / 2;
                    int newt = (before.end + after.start) / 2;
                    before.x2 = after.x1 = x;
                    before.y2 = after.y1 = y;
                    before.end = after.start = newt;
                    this.waypoints.remove(insert);
                    break;
                }
                this.waypoints.remove(insert);
                break;
            }
            ++insert;
        }
    }

    public void addWaypoint(int t, int x, int y) {
        if (this.waypoints.size() > 0) {
            int mint = this.waypoints.get((int)0).start;
            int maxt = this.waypoints.get((int)(this.waypoints.size() - 1)).end;
            if (mint > t) {
                Waypoint first = this.waypoints.get(0);
                this.waypoints.add(new Waypoint(t, first.start, x, y, first.x1, first.y1));
            } else if (maxt < t) {
                Waypoint last = this.waypoints.get(this.waypoints.size() - 1);
                this.waypoints.add(new Waypoint(last.end, t, last.x2, last.y2, x, y));
            } else {
                int insert = 0;
                while (insert < this.waypoints.size()) {
                    if (this.waypoints.get(insert).contains(t)) {
                        Waypoint replaced = this.waypoints.get(insert);
                        Waypoint newpoint1 = new Waypoint(replaced.start, t, replaced.x1, replaced.y1, x, y);
                        this.waypoints.remove(insert);
                        Waypoint newpoint2 = new Waypoint(t, replaced.end, x, y, replaced.x2, replaced.y2);
                        if (newpoint2.end != newpoint2.start) {
                            this.waypoints.add(insert, newpoint2);
                        }
                        if (newpoint1.end != newpoint1.start) {
                            this.waypoints.add(insert, newpoint1);
                        }
                    }
                    ++insert;
                }
            }
        } else {
            int last = this.lastFrame(t);
            this.waypoints.add(new Waypoint(last, t, x, y, x, y));
        }
    }

    public DoublePoint getWaypointPosition(int t) {
        for (Waypoint w : this.waypoints) {
            if (!w.contains(t)) continue;
            return w.getPoint(t);
        }
        return null;
    }

    public Waypoint getWaypointAt(int t) {
        for (Waypoint w : this.waypoints) {
            if (!w.contains(t)) continue;
            return w;
        }
        return null;
    }

    public boolean exists(int index) {
        return this.points.get(index) != null;
    }

    public int lifeSpan(int index) {
        int temp = Math.max(this.Tdiv, Math.max(this.Tgone, this.Tdie));
        if (temp == -1) {
            temp = index;
        }
        return temp - Math.max(this.Tenter, this.Tbirth);
    }

    public int lifeSpan() {
        return this.points.size();
    }

    public int lastFrame(int index) {
        int enterTime;
        int leaveTime = Math.max(this.Tdiv, Math.max(this.Tdie, this.Tgone));
        if (leaveTime == -1 || leaveTime > index) {
            leaveTime = index;
        }
        if ((enterTime = Math.max(this.Tenter, this.Tbirth)) == -1) {
            enterTime = 0;
        }
        int t = leaveTime;
        while (t >= enterTime) {
            if (this.getWaypointPosition(t) != null) {
                return t;
            }
            --t;
        }
        return enterTime;
    }

    public int lastPointFrame(int index) {
        int enterTime;
        int leaveTime = Math.max(this.Tdiv, Math.max(this.Tdie, this.Tgone));
        if (leaveTime == -1) {
            leaveTime = index;
        }
        if ((enterTime = Math.max(this.Tenter, this.Tbirth)) == -1) {
            enterTime = 0;
        }
        int t = leaveTime;
        while (t >= enterTime) {
            if (this.points.get(t) != null) {
                return t;
            }
            --t;
        }
        return 0;
    }

    public double getArea(int index) {
        ArrayList<DoublePoint> pts = this.points.get(index);
        if (pts != null) {
            double sum = 0.0;
            int i = 0;
            while (i < pts.size() - 1) {
                sum += pts.get((int)i).x * pts.get((int)(i + 1)).y - pts.get((int)i).y * pts.get((int)(i + 1)).x;
                ++i;
            }
            return Math.abs(0.5 * (sum += pts.get((int)(pts.size() - 1)).x * pts.get((int)0).y - pts.get((int)(pts.size() - 1)).y * pts.get((int)0).x));
        }
        return Double.NaN;
    }

    public DoublePoint getCenter(int index) {
        double x = 0.0;
        double y = 0.0;
        for (DoublePoint dp : this.points.get(index)) {
            x += dp.x;
            y += dp.y;
        }
        if (this.points.get(index).size() > 0) {
            return new DoublePoint(x, y).scale(1.0 / (double)this.points.get(index).size());
        }
        return DoublePoint.getORIGIN();
    }

    public void circularize(int index) {
        ArrayList<DoublePoint> newpoints = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> pts = this.points.get(index);
        ArrayList<ShortPoint> sortedConnections = new ArrayList<ShortPoint>();
        ArrayList<Double> distances = new ArrayList<Double>();
        int i = 0;
        while (i < pts.size()) {
            int j = i + 1;
            while (j < pts.size()) {
                double d = pts.get(i).squaredDistance(pts.get(j));
                int ind = 0;
                while (ind < sortedConnections.size()) {
                    if (!((Double)distances.get(ind) < d)) break;
                    ++ind;
                }
                sortedConnections.add(ind, new ShortPoint(i, j));
                distances.add(ind, d);
                ++j;
            }
            ++i;
        }
        int[] ecounts = new int[pts.size()];
        HashMap<Integer, ShortPoint> directions = new HashMap<Integer, ShortPoint>();
        ArrayList<ShortPoint> edges = new ArrayList<ShortPoint>();
        while (sortedConnections.size() > 0) {
            ShortPoint next = (ShortPoint)sortedConnections.remove(0);
            if (ecounts[next.x] >= 2 || ecounts[next.y] >= 2) continue;
            short s = next.x;
            ecounts[s] = ecounts[s] + 1;
            short s2 = next.y;
            ecounts[s2] = ecounts[s2] + 1;
            if (directions.get(next.x) != null) {
                directions.put(Integer.valueOf(next.x), new ShortPoint(((ShortPoint)directions.get((Object)Integer.valueOf((int)next.x))).x, next.y));
            } else {
                directions.put(Integer.valueOf(next.x), new ShortPoint((int)next.y, -1));
            }
            if (directions.get(next.y) != null) {
                directions.put(Integer.valueOf(next.y), new ShortPoint(((ShortPoint)directions.get((Object)Integer.valueOf((int)next.y))).x, next.x));
            } else {
                directions.put(Integer.valueOf(next.y), new ShortPoint((int)next.x, -1));
            }
            edges.add(next);
        }
        ArrayList<Integer> left = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < ecounts.length) {
            if (ecounts[i2] < 2) {
                left.add(i2);
            }
            ++i2;
        }
        DoublePoint center = this.getCenter(index);
        while (left.size() > 0) {
            double best = 9.9999999E7;
            int best_id = -1;
            int i3 = 0;
            while (i3 < left.size()) {
                double d = pts.get(i3).squaredDistance(center);
                if (d < best) {
                    best = d;
                    best_id = (Integer)left.get(i3);
                }
                ++i3;
            }
            ShortPoint bestEdge = (ShortPoint)edges.get(0);
            best = 9.99999999E8;
            int i4 = 1;
            while (i4 < edges.size()) {
                double d = 0.5 * (pts.get(((ShortPoint)edges.get((int)i4)).x).distanceTo(pts.get(best_id)) + pts.get(((ShortPoint)edges.get((int)i4)).y).distanceTo(pts.get(best_id)));
                if (d < best) {
                    best = d;
                    bestEdge = (ShortPoint)edges.get(i4);
                }
                ++i4;
            }
            short a = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.x))).x;
            short b = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.x))).y;
            short c = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.y))).x;
            short d = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.y))).y;
            if (a == bestEdge.y) {
                directions.put(Integer.valueOf(bestEdge.x), new ShortPoint(best_id, (int)b));
            } else {
                directions.put(Integer.valueOf(bestEdge.x), new ShortPoint((int)a, best_id));
            }
            if (c == bestEdge.x) {
                directions.put(Integer.valueOf(bestEdge.y), new ShortPoint(best_id, (int)d));
            } else {
                directions.put(Integer.valueOf(bestEdge.y), new ShortPoint((int)c, best_id));
            }
            directions.put(best_id, new ShortPoint((int)bestEdge.x, (int)bestEdge.y));
            left.remove(left.indexOf(best_id));
            edges.remove(bestEdge);
            edges.add(new ShortPoint((int)bestEdge.x, (int)bestEdge.y));
        }
        int current = 0;
        int previous = -1;
        while (newpoints.size() < pts.size()) {
            if (current == -1) {
                System.err.println("!");
            }
            newpoints.add(pts.get(current).clone());
            ShortPoint sp = (ShortPoint)directions.get(current);
            if (sp.x != previous) {
                previous = current;
                current = sp.x;
                continue;
            }
            previous = current;
            current = sp.y;
        }
        this.points.put(index, newpoints);
    }

    public void finalize(BufferedImage img, int index, float fate_score) {
        if (this.points.get(index) != null) {
            if (this.Tdiv < index) {
                this.Tdiv = -1;
            }
            if (this.Tdie < index) {
                this.Tdie = -1;
            }
            if (this.Tgone < index) {
                this.Tgone = -1;
            }
            DoublePoint com = this.getCOM(index);
            try {
                double area = this.getArea(index);
                this.updateAvgArea(area);
                float avg_area_save = (float)this.avgArea;
                CellStatistics cs = new CellStatistics((float)(4.1887902047863905 * Math.pow(area / Math.PI, 1.5)), (short)area, (float)this.getCompactness(index), avg_area_save, (short)com.x, (short)com.y, 0, fate_score);
                this.stats.put(index, cs);
            }
            catch (NullPointerException e) {
                System.err.println("NULL");
            }
        }
    }

    public LinkedList<DoublePoint> getPoints(int index) {
        LinkedList<DoublePoint> result = new LinkedList<DoublePoint>();
        double oldx = 0.0;
        double oldy = 0.0;
        int i = 0;
        while (i < this.points.get(index).size() - 1) {
            DoublePoint v = this.points.get(index).get(i + 1).minus(this.points.get(index).get(i)).normalized().scale(0.5);
            DoublePoint current = this.points.get(index).get(i);
            while (current.squaredDistance(this.points.get(index).get(i + 1)) > 0.15) {
                double newx = current.x;
                double newy = current.y;
                if (newx != oldx || newy != oldy) {
                    result.add(new DoublePoint(newx, newy));
                }
                oldx = newx;
                oldy = newy;
                current = current.plus(v);
            }
            ++i;
        }
        DoublePoint v = this.points.get(index).get(0).minus(this.points.get(index).get(this.points.get(index).size() - 1)).normalized().scale(0.5);
        DoublePoint current = this.points.get(index).get(this.points.get(index).size() - 1);
        while (current.squaredDistance(this.points.get(index).get(0)) > 0.15) {
            double newx = current.x;
            double newy = current.y;
            if (newx != oldx || newy != oldy) {
                result.add(new DoublePoint(newx, newy));
            }
            oldx = newx;
            oldy = newy;
            current = current.plus(v);
        }
        return result;
    }

    public double squaredDistanceTo(Cell amoeba, int index) {
        return this.getCenter(index).squaredDistance(amoeba.getCenter(index));
    }

    public double getCompactness(int index) {
        return Math.PI * 4 * this.getArea(index) / Math.pow(this.getPerimeter(index), 2.0);
    }

    private double getPerimeter(int index) {
        double perimeter = 0.0;
        int i = 1;
        while (i < this.points.get(index).size()) {
            perimeter += this.points.get(index).get(i).distanceTo(this.points.get(index).get(i - 1));
            ++i;
        }
        return perimeter + this.points.get(index).get(0).distanceTo(this.points.get(index).get(this.points.get(index).size() - 1));
    }

    public short getAverageNonEdgeBrightness(BufferedImage img, int index) {
        double avg = 0.0;
        LinkedList<DoublePoint> pix = this.getPoints(index);
        for (DoublePoint sp : pix) {
            short brightness = (short)Static.gray(img, (int)Math.round(sp.x), (int)Math.round(sp.y));
            avg += (double)brightness;
        }
        return (short)(avg /= (double)pix.size());
    }

    public void setModeledMasses() {
        double d = 1000.0;
        double r = 0.001;
        double m0 = 100.0;
        double currentError = 0.0;
        int count = 0;
        for (int t : this.stats.keySet()) {
            if (this.getStats(t) == null) continue;
            double mass = this.getStats((int)t).mass;
            ++count;
            double model = m0;
            if ((double)t > d) {
                model = m0 * Math.pow(1.0 + r, (double)t - d);
            }
            currentError += Math.pow(model - mass, 2.0);
        }
        currentError /= (double)count;
        double Tmax = 1000.0;
        double Tmin = Tmax / 1000.0;
        double T = Tmax;
        Random gen = new Random();
        while (T > Tmin) {
            count = 0;
            double d2 = Math.max(0.0, (1.0 + gen.nextGaussian() * 0.05) * d + gen.nextGaussian() * 5.0);
            double r2 = r + gen.nextGaussian() * 0.001;
            if (gen.nextDouble() < 0.05) {
                r2 = r + gen.nextGaussian() * 0.1;
            }
            double m02 = Math.max(0.0, (1.0 + gen.nextGaussian() * 0.05) * m0 + gen.nextGaussian() * 2.0);
            double error = 0.0;
            for (int t : this.stats.keySet()) {
                if (this.getStats(t) == null) continue;
                double mass = this.getStats((int)t).mass;
                ++count;
                double model = m02;
                if ((double)t > d2) {
                    model = m02 * Math.pow(1.0 + r2, (double)t - d2);
                }
                error += Math.pow(model - mass, 2.0);
            }
            double chance = Math.exp((currentError - (error /= (double)count)) / T);
            if (gen.nextDouble() < chance) {
                d = d2;
                r = r2;
                m0 = m02;
                currentError = error;
            }
            T *= 0.99;
        }
        for (int t : this.stats.keySet()) {
            double model = m0;
            if ((double)t > d) {
                model = m0 * Math.pow(1.0 + r, (double)t - d);
            }
            this.stats.get((Object)Integer.valueOf((int)t)).modeledMass = (float)model;
        }
    }

    public void saveSelf(PrintWriter pw) {
        int t;
        String out = "";
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        sb.append(",");
        sb.append(this.Tdiv);
        sb.append(",");
        sb.append(this.Tdie);
        sb.append(",");
        sb.append(this.Tgone);
        sb.append(",");
        sb.append(this.Tbirth);
        sb.append(",");
        sb.append(this.Tenter);
        sb.append(",");
        sb.append(this.gen);
        sb.append(",");
        sb.append(this.motherId);
        sb.append(Static.newline);
        Iterator<Object> iterator = this.stats.keySet().iterator();
        while (iterator.hasNext()) {
            t = iterator.next();
            if (this.stats.get(t) == null) continue;
            sb.append(t);
            sb.append(",");
            sb.append(this.stats.get(t).toString());
        }
        sb.append(Static.newline);
        sb.append("PIXELS" + Static.newline);
        iterator = this.points.keySet().iterator();
        while (iterator.hasNext()) {
            t = iterator.next();
            if (this.points.get(t) == null) continue;
            sb.append(t);
            for (DoublePoint dp : this.points.get(t)) {
                sb.append(String.format(",%3.3f,%3.3f", dp.x, dp.y));
            }
            sb.append(Static.newline);
        }
        sb.append("WAYPOINTS" + Static.newline);
        for (Waypoint w : this.waypoints) {
            sb.append(String.valueOf(w.start) + "," + w.end + "," + w.x1 + "," + w.y1 + "," + w.x2 + "," + w.y2 + Static.newline);
        }
        sb.append("END CELL" + Static.newline);
        pw.print(sb.toString());
    }
}

