/*
 * Decompiled with CFR 0.152.
 */
package semiTracker3;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Scanner;
import semiTracker3.CellStatistics;
import semiTracker3.CircleCandidate;
import semiTracker3.DoublePoint;
import semiTracker3.ShortPoint;
import semiTracker3.Static;
import semiTracker3.Tracker;
import semiTracker3.Waypoint;

public class Cell
implements Cloneable {
    int pcount = 10;
    HashMap<Integer, ArrayList<DoublePoint>> points = new HashMap();
    int window = 50;
    double avgArea = 0.0;
    ArrayList<DoublePoint> vs = new ArrayList();
    HashMap<Integer, CellStatistics> stats = new HashMap();
    ArrayList<Waypoint> waypoints = new ArrayList();
    Tracker track = null;
    int Tdiv = -1;
    int Tdie = -1;
    int Tgone = -1;
    int Tbirth = -1;
    int Tenter = -1;
    int id;
    int gen = 0;
    int motherId = -1;
    int Tmin = 999999;
    int Tmax = 0;
    double RMSD = -1.0;
    double startv = 0.0;
    double exponent = 0.0;
    int inflection = 0;
    int wmin = 999999;
    int wmax = 0;
    int iterations = 0;
    double expectedArea = 50.0;
    boolean debug = false;
    double pEdgeThreshold;
    double pEdge;
    double pKappa;
    double pGamma;
    double pFactor;
    double pExpectedRadius;
    double pCellSize;
    double pTooLittle;
    double pTooLarge;
    double pSpaceFill;
    double pShape;
    double pWaypoint;
    double pNeighborLin;
    double pNeighborSq;
    double pCoolDown;
    private final int offset = 10;

    public int iterate(int[][] field, Collection<Cell> nearby, int index, DoublePoint to, double strength) {
        ++this.iterations;
        DoublePoint center = this.getCenter(index);
        boolean changing = false;
        double expectedRadius = Math.sqrt(this.avgArea / Math.PI);
        double currentArea = this.getArea(index);
        int gradientRadius = (int)(this.pCellSize * 1.5);
        double squaredSearch = gradientRadius * gradientRadius;
        int p = 0;
        while (p < this.pcount) {
            int left;
            DoublePoint dp = this.points.get(index).get(p);
            DoublePoint force = DoublePoint.getORIGIN();
            DoublePoint edgeVector = DoublePoint.getORIGIN();
            int scount = 0;
            int ecount = 0;
            int badCount = 0;
            double squaredCellRadius = this.pCellSize * this.pCellSize;
            int i = -gradientRadius;
            while (i <= gradientRadius) {
                int j = -gradientRadius;
                while (j <= gradientRadius) {
                    DoublePoint delta = new DoublePoint(i, j);
                    if (delta.squaredDistance(0.0, 0.0) <= squaredSearch) {
                        try {
                            force.add(delta.normalized().scale((double)field[(int)Math.round(dp.x + delta.x)][(int)Math.round(dp.y + delta.y)] / (1.0 + delta.squaredDistance(0.0, 0.0))));
                            ++scount;
                            if (delta.squaredDistance(0.0, 0.0) <= squaredCellRadius && (double)field[(int)Math.round(dp.x + delta.x)][(int)Math.round(dp.y + delta.y)] > this.pEdgeThreshold) {
                                edgeVector.add(delta.normalized());
                                ++ecount;
                            }
                        }
                        catch (Exception e) {
                            force.add(delta.normalized().scale(this.pEdgeThreshold / (1.0 + delta.squaredDistance(0.0, 0.0))));
                            ++scount;
                            ++badCount;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            force.multiply(1.0 / (1.0 + (double)scount * this.pEdge));
            DoublePoint dcenter = center.minus(dp);
            double dot = edgeVector.scale(1.0 / (double)ecount).dotProduct(dcenter.normalized());
            double distanceToCenter = center.squaredDistance(field.length / 2, field[0].length / 2);
            double kappa = this.pKappa * distanceToCenter / ((double)(field.length * field.length) * 0.25 + (double)(field[0].length * field[0].length) * 0.25);
            double velocity = this.getWaypointAt(index).getVelocity();
            double gamma = this.pGamma * Math.min(1.0, velocity / 4.0);
            double factor = this.pFactor + kappa + gamma + this.pExpectedRadius * expectedRadius * expectedRadius;
            if (factor > 1.0) {
                factor = 1.0;
            }
            if (currentArea < this.avgArea * this.pTooLittle && (this.Tdie == -1 || index < this.Tdie) || currentArea < this.pCellSize * 2.0) {
                force.add(dcenter.normalized().scale(-factor));
            } else if (currentArea > this.avgArea * this.pTooLarge) {
                force.add(dcenter.normalized().scale(factor));
            }
            force.add(dcenter.normalized().scale(-factor * this.pSpaceFill));
            if ((ecount < this.pcount || dot > 0.6) && badCount == 0) {
                force.add(dcenter.normalized().scale(factor * 0.5));
            }
            if ((left = p - 1) < 0) {
                left = this.points.get(index).size() - 1;
            }
            int right = (p + 1) % this.points.get(index).size();
            DoublePoint dp2 = this.points.get(index).get(left);
            double d = dp.distanceTo(dp2);
            double theta = Math.PI * 2 / (double)(this.pcount - 2);
            double l = expectedRadius * (-Math.cos(theta) + 1.0) * 1.0;
            double ddl = Math.pow(d - l, 2.0);
            double kpoint = this.pShape;
            if (d - l > 0.0) {
                force.add(dp2.minus(dp).normalized().scale(kpoint * ddl));
            } else {
                force.add(dp2.minus(dp).normalized().scale(-kpoint * ddl));
            }
            dp2 = this.points.get(index).get(right);
            d = dp.distanceTo(dp2);
            double ddr = Math.pow(d - l, 2.0);
            if (d - l > 0.0) {
                force.add(dp2.minus(dp).normalized().scale(kpoint * ddr));
            } else {
                force.add(dp2.minus(dp).normalized().scale(-kpoint * ddr));
            }
            if (to != null) {
                force.add(to.minus(center).scale(this.pWaypoint * strength * to.squaredDistance(center)));
            }
            if (nearby != null) {
                for (Cell a : nearby) {
                    double totalRadii = this.pNeighborLin * (Math.sqrt(a.getArea(index) / Math.PI) + expectedRadius);
                    if (a.id == this.id) continue;
                    DoublePoint acenter = a.getCenter(index);
                    force.add(center.minus(acenter).normalized().scale(totalRadii / (1.0 + acenter.squaredDistance(center))));
                    force.add(center.minus(acenter).normalized().scale(this.pNeighborSq / (1.0 + acenter.distanceTo(center))));
                }
            }
            if (Double.isNaN(force.x) || Double.isNaN(force.y)) {
                return -1;
            }
            this.vs.get(p).add(force);
            this.vs.get(p).multiply(this.pCoolDown / (this.pCoolDown - 1.0 + (double)this.iterations));
            if (this.vs.get(p).magnitude() > 0.75) {
                this.vs.get(p).multiply(0.75 / this.vs.get(p).magnitude());
            }
            dp.add(this.vs.get(p));
            if (this.vs.get(p).magnitude() > 0.25) {
                changing = true;
            }
            if (this.debug) {
                System.err.println(String.valueOf(p) + "=" + dp.toString() + ":" + this.vs.get(p).toString() + ":" + force.toString() + " currentR " + dp.distanceTo(center));
            }
            ++p;
        }
        if (changing) {
            return 1;
        }
        return 0;
    }

    public void volumize(int[][] field, int index) {
        if (this.points.get(index) != null) {
            DoublePoint center = this.getCenter(index);
            int originalSum = 0;
            int count = 0;
            for (DoublePoint dp : this.points.get(index)) {
                try {
                    double edgeness = field[(int)Math.round(dp.x)][(int)Math.round(dp.y)];
                    originalSum = (int)((double)originalSum + edgeness);
                    ++count;
                }
                catch (Exception edgeness) {
                    // empty catch block
                }
            }
            if (count == 0) {
                count = 1;
            }
            originalSum /= count;
            double best = 0.0;
            double bestm = 1.0;
            int bestx = 0;
            int besty = 0;
            double m = 0.9;
            while (m <= 1.1) {
                int x = -2;
                while (x <= 2) {
                    int y = -2;
                    while (y <= 2) {
                        double sum = 0.0;
                        count = 0;
                        for (DoublePoint dp : this.points.get(index)) {
                            DoublePoint multiplied = center.plus(dp.minus(center).scale(m));
                            try {
                                double edgeness = field[(int)Math.round(multiplied.x) + x][(int)Math.round(multiplied.y) + y];
                                sum += edgeness;
                                ++count;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((sum /= (double)count) > best) {
                            best = sum;
                            bestm = m;
                            bestx = x;
                            besty = y;
                        }
                        ++y;
                    }
                    ++x;
                }
                m += 0.04;
            }
            if (best > (double)originalSum * 1.9) {
                for (DoublePoint dp : this.points.get(index)) {
                    DoublePoint dp2 = center.plus(dp.minus(center).scale(bestm));
                    dp.x = dp2.x + (double)bestx;
                    dp.y = dp2.y + (double)besty;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareOptimizationNoSpots(int index, int[][] gradient, DoublePoint pointOfInterest) {
        ArrayList<DoublePoint> list;
        this.pEdgeThreshold = ((Integer)this.track.pEdgeThreshold.getValue()).intValue();
        this.pEdge = ((Integer)this.track.pEdge.getValue()).intValue();
        this.pKappa = (Double)this.track.pKappa.getValue();
        this.pGamma = (Double)this.track.pGamma.getValue();
        this.pFactor = (Double)this.track.pFactor.getValue();
        this.pExpectedRadius = (Double)this.track.pExpectedRadius.getValue();
        this.pTooLittle = (Double)this.track.pTooSmall.getValue();
        this.pTooLarge = (Double)this.track.pTooLarge.getValue();
        this.pCellSize = ((Integer)this.track.cellRadius.getValue()).intValue();
        this.pSpaceFill = (Double)this.track.pSpaceFill.getValue();
        this.pShape = (Double)this.track.pShape.getValue();
        this.pWaypoint = (Double)this.track.pWaypoint.getValue();
        this.pNeighborLin = (Double)this.track.pNeighborLin.getValue();
        this.pNeighborSq = (Double)this.track.pNeighborSq.getValue();
        this.pCoolDown = ((Integer)this.track.pCool.getValue()).intValue();
        ArrayList<DoublePoint> arrayList = list = new ArrayList<DoublePoint>();
        synchronized (arrayList) {
            int last_frame = this.lastPointFrame(index - 1);
            this.iterations = 0;
            int counts = 0;
            if (index != this.Tbirth) {
                this.avgArea = 0.0;
                int i = 1;
                while (i < this.window) {
                    double a = this.getArea(last_frame - i);
                    if (a > 0.0) {
                        ++counts;
                        this.avgArea += a;
                    }
                    ++i;
                }
                this.avgArea = counts > 0 ? (this.avgArea /= (double)counts) : 30.0;
                if (this.points.get(last_frame) == null) {
                    CircleCandidate cc = new CircleCandidate((int)Math.round(pointOfInterest.x), (int)Math.round(pointOfInterest.y), (int)Math.round(Math.sqrt(this.avgArea / Math.PI)), 0.0);
                    cc.r = (int)((double)cc.r + 0.5);
                    double theta = 0.0;
                    while (theta < Math.PI * 2) {
                        list.add(new DoublePoint((double)cc.x + (double)cc.r * Math.cos(theta), (double)cc.y + (double)cc.r * Math.sin(theta)));
                        theta += Math.PI * 2 / (double)this.pcount;
                    }
                    this.points.put(index, list);
                } else {
                    ArrayList<DoublePoint> newlist = new ArrayList<DoublePoint>();
                    for (DoublePoint dp : this.points.get(last_frame)) {
                        newlist.add(dp.clone());
                    }
                    this.points.put(index, newlist);
                }
            } else {
                Cell mother = this.track.getCellById(this.motherId);
                int daughterR = 3;
                try {
                    double daughterVolume = Math.pow(Math.sqrt(mother.getArea(mother.lastPointFrame(index - 1)) / Math.PI), 3.0) / 2.0;
                    daughterR = (int)Math.round(Math.cbrt(daughterVolume));
                }
                catch (Exception daughterVolume) {
                    // empty catch block
                }
                CircleCandidate cc = new CircleCandidate((int)Math.round(pointOfInterest.x), (int)Math.round(pointOfInterest.y), daughterR, 0.0);
                cc.r = (int)((double)cc.r + 0.5);
                double theta = 0.0;
                while (theta < Math.PI * 2) {
                    list.add(new DoublePoint((double)cc.x + (double)cc.r * Math.cos(theta), (double)cc.y + (double)cc.r * Math.sin(theta)));
                    theta += Math.PI * 2 / (double)this.pcount;
                }
                this.points.put(index, list);
                this.avgArea = Math.PI * (double)daughterR * (double)daughterR;
            }
            int avgR = (int)Math.round(Math.sqrt(this.avgArea / 3.14159));
            if (avgR == 0) {
                avgR = 1;
            }
            this.vs.clear();
            if (this.vs.size() == this.pcount) {
                int i = 0;
                while (i < this.pcount) {
                    this.vs.get((int)i).x = 0.0;
                    this.vs.get((int)i).y = 0.0;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.pcount) {
                    this.vs.add(DoublePoint.getORIGIN());
                    ++i;
                }
            }
        }
    }

    public void jumpToBestSpotNearby(int[][] gradient, boolean[][][] hotspots, int x, int y, int radius, int index, int minR, int maxR) {
        x = Math.abs(x);
        y = Math.abs(y);
        ArrayList<CircleCandidate> goodCandidates = new ArrayList<CircleCandidate>();
        ArrayList<CircleCandidate> badCandidates = new ArrayList<CircleCandidate>();
        ArrayList<CircleCandidate> reallybadCandidates = new ArrayList<CircleCandidate>();
        int r = Math.max(2, minR);
        while (r <= Math.min(hotspots.length - 1, maxR)) {
            LinkedList<ShortPoint> circlePoints = this.track.circlePoints.get(r - 1);
            int i = Math.max(0, x - radius);
            while (i < Math.min(hotspots[r].length - 1, x + radius)) {
                int j = Math.max(0, y - radius);
                while (j < Math.min(hotspots[r][i].length - 1, y + radius)) {
                    try {
                        if (hotspots[r][i][j]) {
                            int ind;
                            double score;
                            ArrayList<Integer> gradients = new ArrayList<Integer>();
                            for (ShortPoint sp : circlePoints) {
                                try {
                                    int edgeness = gradient[sp.x + i][sp.y + j];
                                    int ind2 = 0;
                                    while (ind2 < gradients.size()) {
                                        if ((Integer)gradients.get(ind2) > edgeness) break;
                                        ++ind2;
                                    }
                                    gradients.add(ind2, edgeness);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            DoublePoint vector = new DoublePoint(x, y);
                            double grad1 = ((Integer)gradients.get(gradients.size() / 4)).intValue();
                            double grad3 = ((Integer)gradients.get(gradients.size() - 1)).intValue();
                            if (this.debug) {
                                System.err.println("Candidate with r = " + r + " grad1 = " + grad1 + " grad3=" + grad3);
                            }
                            if (grad1 > 17000.0 && grad3 > 60000.0) {
                                score = (double)(r * r) * grad1 / (1.0 + vector.squaredDistance(i, j));
                                ind = 0;
                                while (ind < goodCandidates.size()) {
                                    if (((CircleCandidate)goodCandidates.get((int)ind)).score > score) break;
                                    ++ind;
                                }
                                goodCandidates.add(ind, new CircleCandidate(i, j, r, score));
                            } else if (grad1 > 8000.0 && grad3 > 35000.0) {
                                score = (double)(r * r) * grad1 / (1.0 + vector.squaredDistance(i, j));
                                ind = 0;
                                while (ind < badCandidates.size()) {
                                    if (((CircleCandidate)badCandidates.get((int)ind)).score > score) break;
                                    ++ind;
                                }
                                badCandidates.add(ind, new CircleCandidate(i, j, r, score));
                            } else if (grad1 > 4000.0 && grad3 > 15000.0) {
                                score = (double)(r * r) * grad1 / (1.0 + vector.squaredDistance(i, j));
                                ind = 0;
                                while (ind < reallybadCandidates.size()) {
                                    if (((CircleCandidate)reallybadCandidates.get((int)ind)).score > score) break;
                                    ++ind;
                                }
                                reallybadCandidates.add(ind, new CircleCandidate(i, j, r, score));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
            ++r;
        }
        if (goodCandidates.size() == 0) {
            goodCandidates.addAll(badCandidates);
        }
        if (goodCandidates.size() == 0) {
            goodCandidates.addAll(reallybadCandidates);
        }
        if (goodCandidates.size() == 0) {
            goodCandidates.add(new CircleCandidate(x, y, minR, 0.0));
        }
        Collections.sort(goodCandidates, new Comparator<CircleCandidate>(){

            @Override
            public int compare(CircleCandidate o1, CircleCandidate o2) {
                if (o1.score > o2.score) {
                    return 1;
                }
                if (o1.score < o2.score) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<DoublePoint> list = new ArrayList<DoublePoint>();
        CircleCandidate cc = (CircleCandidate)goodCandidates.get(goodCandidates.size() - 1);
        cc.r = (int)((double)cc.r + 0.5);
        double theta = 0.0;
        while (theta < Math.PI * 2) {
            list.add(new DoublePoint((double)cc.x + (double)cc.r * Math.cos(theta), (double)cc.y + (double)cc.r * Math.sin(theta)));
            theta += Math.PI * 2 / (double)this.pcount;
        }
        this.points.put(index, list);
    }

    public synchronized DoublePoint getCOM(int index) {
        ArrayList<DoublePoint> pixs = this.points.get(index);
        if (pixs == null) {
            return null;
        }
        return this.getCOMPixels(pixs);
    }

    public synchronized boolean insideSimple(double x, double y, int index) {
        try {
            double max_radius = 0.0;
            DoublePoint center = this.getCenter(index);
            for (DoublePoint dp : this.points.get(index)) {
                double r = dp.squaredDistance(center);
                if (!(r > max_radius)) continue;
                max_radius = r;
            }
            return center.squaredDistance(x, y) <= max_radius;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean inside(double x, double y, int index) {
        if (this.points.get(index) != null) {
            int left = 0;
            int right = 0;
            int i = 0;
            while (i < this.points.get(index).size() - 1) {
                int result = this.intersect(this.points.get((Object)Integer.valueOf((int)index)).get((int)i).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)i).y, this.points.get((Object)Integer.valueOf((int)index)).get((int)(i + 1)).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)(i + 1)).y, x, y);
                if (result == -1) {
                    ++left;
                } else if (result == 1) {
                    ++right;
                } else if (result == 0) {
                    return true;
                }
                ++i;
            }
            int result = this.intersect(this.points.get((Object)Integer.valueOf((int)index)).get((int)(this.points.get((Object)Integer.valueOf((int)index)).size() - 1)).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)(this.points.get((Object)Integer.valueOf((int)index)).size() - 1)).y, this.points.get((Object)Integer.valueOf((int)index)).get((int)0).x, this.points.get((Object)Integer.valueOf((int)index)).get((int)0).y, x, y);
            if (result == -1) {
                ++left;
            } else if (result == 1) {
                ++right;
            } else if (result == 0) {
                return true;
            }
            return left % 2 == 1 && right % 2 == 1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int intersect(double x1, double y1, double x2, double y2, double x, double y) {
        if (x2 != x1 && y2 != y1) {
            double yint = y;
            double m = (y2 - y1) / (x2 - x1);
            double b = y1 - m * x1;
            double xint = (yint - b) / m;
            if (!(xint >= Math.min(x2, x1)) || !(xint <= Math.max(x2, x1))) return -3;
            if (xint < x) {
                return -1;
            }
            if (!(xint > x)) return 0;
            return 1;
        }
        if (x2 == x1) {
            if (!(y <= Math.max(y1, y2)) || !(y >= Math.min(y1, y2))) return -3;
            if (x1 < x) {
                return -1;
            }
            if (x1 > x) {
                return 1;
            }
            if (x1 != x) return 0;
            return 0;
        }
        if (y1 != y2) return 0;
        if (!(x <= Math.max(x1, x2)) || !(x >= Math.min(x1, x2))) return -3;
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DoublePoint getCOMPixels(ArrayList<DoublePoint> pts) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<DoublePoint> arrayList = pts;
        synchronized (arrayList) {
            for (DoublePoint dp : pts) {
                x += dp.x;
                y += dp.y;
            }
        }
        return new DoublePoint(x / (double)pts.size(), y / (double)pts.size());
    }

    public synchronized CellStatistics getStats(int index) {
        if (this.stats.get(index) != null) {
            return this.stats.get(index);
        }
        return null;
    }

    public Cell(Tracker track, int[][] gradient, boolean[][][] hotspots, int index, int id, int x, int y) {
        this.track = track;
        this.Tenter = index;
        this.id = id;
        this.pcount = (Integer)track.numberOfPoints.getValue();
        int cellRadius = (Integer)track.cellRadius.getValue();
        this.jumpToBestSpotNearby(gradient, hotspots, x, y, cellRadius * 2, index, cellRadius / 2, cellRadius * 2);
        this.updateMinMaxTimes(index);
    }

    public Cell(Tracker track, int[][] gradient, boolean[][][] hotspots, int index, int id, int x, int y, int radius) {
        this.track = track;
        this.Tenter = index;
        this.id = id;
        this.pcount = (Integer)track.numberOfPoints.getValue();
        int cellRadius = (Integer)track.cellRadius.getValue();
        this.jumpToBestSpotNearby(gradient, hotspots, x, y, cellRadius * 2, index, cellRadius / 2, cellRadius * 2);
        this.updateMinMaxTimes(index);
    }

    public Cell(int index, int id, int x, int y, Cell mother) {
        this.track = mother.track;
        this.Tbirth = index;
        mother.Tdiv = index;
        this.id = id;
        this.motherId = mother.id;
        this.gen = mother.gen > -1 ? mother.gen + 1 : -1;
        this.waypoints.add(new Waypoint(index, index, x, y, x, y));
        this.updateMinMaxTimes(index);
    }

    public Cell(Tracker track, Scanner s) {
        this.track = track;
        try {
            String[] split;
            String[] header = s.nextLine().split(",");
            this.id = Integer.parseInt(header[0]);
            this.Tdiv = Integer.parseInt(header[1]);
            this.Tdie = Integer.parseInt(header[2]);
            this.Tgone = Integer.parseInt(header[3]);
            this.Tbirth = Integer.parseInt(header[4]);
            this.Tenter = Integer.parseInt(header[5]);
            this.gen = Integer.parseInt(header[6]);
            this.motherId = Integer.parseInt(header[7]);
            String line = s.nextLine();
            while (line.compareTo("PIXELS") != 0) {
                if (line.length() > 0) {
                    split = line.split(",");
                    int index = Integer.parseInt(split[0]);
                    this.stats.put(index, new CellStatistics(Float.parseFloat(split[1]), Short.parseShort(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]), Short.parseShort(split[5]), Short.parseShort(split[6]), Short.parseShort(split[7]), Float.parseFloat(split[8])));
                    if (index > this.Tmax) {
                        this.Tmax = index;
                    }
                    if (index < this.Tmin) {
                        this.Tmin = index;
                    }
                }
                line = s.nextLine();
            }
            line = s.nextLine();
            while (line.compareTo("WAYPOINTS") != 0 && line.compareTo("END CELL") != 0) {
                split = line.split(",");
                ArrayList<DoublePoint> list = new ArrayList<DoublePoint>();
                int i = 1;
                while (i < split.length - 1) {
                    list.add(new DoublePoint(Double.parseDouble(split[i]), Double.parseDouble(split[i + 1])));
                    i += 2;
                }
                int t = Integer.parseInt(split[0]);
                this.updateMinMaxTimes(t);
                this.points.put(t, list);
                this.pcount = list.size();
                line = s.nextLine();
            }
            if (line.compareTo("WAYPOINTS") == 0) {
                line = s.nextLine();
                while (line.compareTo("END CELL") != 0) {
                    split = line.split(",");
                    Waypoint w = new Waypoint(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]));
                    if (w.start < this.wmin) {
                        this.wmin = w.start;
                    }
                    if (w.end > this.wmax) {
                        this.wmax = w.end;
                    }
                    this.waypoints.add(w);
                    line = s.nextLine();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error when reading a cell from file: " + e.getMessage());
        }
    }

    public void removeWaypoint(int t) {
        int insert = 0;
        while (insert < this.waypoints.size()) {
            if (this.waypoints.get(insert).contains(t)) {
                if (insert > 0 && insert < this.waypoints.size() - 1) {
                    Waypoint before = this.waypoints.get(insert - 1);
                    Waypoint after = this.waypoints.get(insert + 1);
                    int x = (before.x2 + after.x1) / 2;
                    int y = (before.y2 + after.y1) / 2;
                    int newt = (before.end + after.start) / 2;
                    before.x2 = after.x1 = x;
                    before.y2 = after.y1 = y;
                    before.end = after.start = newt;
                    this.waypoints.remove(insert);
                    break;
                }
                this.waypoints.remove(insert);
                this.wmin = 9999999;
                this.wmax = 0;
                break;
            }
            ++insert;
        }
    }

    public void addWaypoint(int t, int x, int y) {
        if (t < this.wmin) {
            this.wmin = t;
        }
        if (t > this.wmax) {
            this.wmax = t;
        }
        if (this.waypoints.size() > 0) {
            int mint = this.waypoints.get((int)0).start;
            int maxt = this.waypoints.get((int)(this.waypoints.size() - 1)).end;
            if (mint > t) {
                Waypoint first = this.waypoints.get(0);
                this.waypoints.add(new Waypoint(t, first.start, x, y, first.x1, first.y1));
            } else if (maxt < t) {
                Waypoint last = this.waypoints.get(this.waypoints.size() - 1);
                this.waypoints.add(new Waypoint(last.end, t, last.x2, last.y2, x, y));
            } else {
                int insert = 0;
                while (insert < this.waypoints.size()) {
                    if (this.waypoints.get(insert).contains(t)) {
                        Waypoint replaced = this.waypoints.get(insert);
                        Waypoint newpoint1 = new Waypoint(replaced.start, t, replaced.x1, replaced.y1, x, y);
                        this.waypoints.remove(insert);
                        Waypoint newpoint2 = new Waypoint(t, replaced.end, x, y, replaced.x2, replaced.y2);
                        if (newpoint2.end != newpoint2.start) {
                            this.waypoints.add(insert, newpoint2);
                        }
                        if (newpoint1.end != newpoint1.start) {
                            this.waypoints.add(insert, newpoint1);
                        }
                    }
                    ++insert;
                }
            }
        } else {
            int last = this.lastFrame(t);
            this.waypoints.add(new Waypoint(last, t, x, y, x, y));
        }
    }

    public DoublePoint getWaypointPosition(int t) {
        for (Waypoint w : this.waypoints) {
            if (!w.contains(t)) continue;
            return w.getPoint(t);
        }
        return null;
    }

    public Waypoint getWaypointAt(int t) {
        for (Waypoint w : this.waypoints) {
            if (!w.contains(t)) continue;
            return w;
        }
        return null;
    }

    public synchronized boolean exists(int index) {
        return this.points.get(index) != null;
    }

    public synchronized int lifeSpan(int index) {
        int temp = Math.max(this.Tdiv, Math.max(this.Tgone, this.Tdie));
        if (temp == -1) {
            temp = index;
        }
        return temp - Math.max(this.Tenter, this.Tbirth);
    }

    public int lifeSpan() {
        return this.points.size();
    }

    public synchronized int lastFrame(int index) {
        int enterTime;
        int leaveTime = Math.max(this.Tdiv, Math.max(this.Tdie, this.Tgone));
        if (leaveTime == -1 || leaveTime > index) {
            leaveTime = index;
        }
        if ((enterTime = Math.max(this.Tenter, this.Tbirth)) == -1) {
            enterTime = 0;
        }
        int t = leaveTime;
        while (t >= enterTime) {
            if (this.getWaypointPosition(t) != null) {
                return t;
            }
            --t;
        }
        return enterTime;
    }

    public synchronized int lastPointFrame(int index) {
        int enterTime;
        int leaveTime = this.Tmax;
        if (leaveTime == -1) {
            leaveTime = index;
        }
        if ((enterTime = this.Tmin) == -1) {
            enterTime = 0;
        }
        int t = leaveTime;
        while (t >= enterTime) {
            if (this.points.get(t) != null) {
                return t;
            }
            --t;
        }
        return 0;
    }

    public synchronized double getArea(int index) {
        ArrayList<DoublePoint> pts = this.points.get(index);
        if (pts != null) {
            double sum = 0.0;
            int i = 0;
            while (i < pts.size() - 1) {
                sum += pts.get((int)i).x * pts.get((int)(i + 1)).y - pts.get((int)i).y * pts.get((int)(i + 1)).x;
                ++i;
            }
            return Math.abs(0.5 * (sum += pts.get((int)(pts.size() - 1)).x * pts.get((int)0).y - pts.get((int)(pts.size() - 1)).y * pts.get((int)0).x));
        }
        return Double.NaN;
    }

    public synchronized DoublePoint getCenter(int index) {
        double x = 0.0;
        double y = 0.0;
        if (this.points.get(index) == null) {
            return null;
        }
        for (DoublePoint dp : this.points.get(index)) {
            x += dp.x;
            y += dp.y;
        }
        if (this.points.get(index).size() > 0) {
            return new DoublePoint(x, y).scale(1.0 / (double)this.points.get(index).size());
        }
        return DoublePoint.getORIGIN();
    }

    public void circularize(int index) {
        ArrayList<DoublePoint> newpoints = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> pts = this.points.get(index);
        ArrayList<ShortPoint> sortedConnections = new ArrayList<ShortPoint>();
        ArrayList<Double> distances = new ArrayList<Double>();
        int i = 0;
        while (i < pts.size()) {
            int j = i + 1;
            while (j < pts.size()) {
                double d = pts.get(i).squaredDistance(pts.get(j));
                int ind = 0;
                while (ind < sortedConnections.size()) {
                    if (!((Double)distances.get(ind) < d)) break;
                    ++ind;
                }
                sortedConnections.add(ind, new ShortPoint(i, j));
                distances.add(ind, d);
                ++j;
            }
            ++i;
        }
        int[] ecounts = new int[pts.size()];
        HashMap<Integer, ShortPoint> directions = new HashMap<Integer, ShortPoint>();
        ArrayList<ShortPoint> edges = new ArrayList<ShortPoint>();
        while (sortedConnections.size() > 0) {
            ShortPoint next = (ShortPoint)sortedConnections.remove(0);
            if (ecounts[next.x] >= 2 || ecounts[next.y] >= 2) continue;
            short s = next.x;
            ecounts[s] = ecounts[s] + 1;
            short s2 = next.y;
            ecounts[s2] = ecounts[s2] + 1;
            if (directions.get(next.x) != null) {
                directions.put(Integer.valueOf(next.x), new ShortPoint(((ShortPoint)directions.get((Object)Integer.valueOf((int)next.x))).x, next.y));
            } else {
                directions.put(Integer.valueOf(next.x), new ShortPoint((int)next.y, -1));
            }
            if (directions.get(next.y) != null) {
                directions.put(Integer.valueOf(next.y), new ShortPoint(((ShortPoint)directions.get((Object)Integer.valueOf((int)next.y))).x, next.x));
            } else {
                directions.put(Integer.valueOf(next.y), new ShortPoint((int)next.x, -1));
            }
            edges.add(next);
        }
        ArrayList<Integer> left = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < ecounts.length) {
            if (ecounts[i2] < 2) {
                left.add(i2);
            }
            ++i2;
        }
        DoublePoint center = this.getCenter(index);
        while (left.size() > 0) {
            double best = 9.9999999E7;
            int best_id = -1;
            int i3 = 0;
            while (i3 < left.size()) {
                double d = pts.get(i3).squaredDistance(center);
                if (d < best) {
                    best = d;
                    best_id = (Integer)left.get(i3);
                }
                ++i3;
            }
            ShortPoint bestEdge = (ShortPoint)edges.get(0);
            best = 9.99999999E8;
            int i4 = 1;
            while (i4 < edges.size()) {
                double d = 0.5 * (pts.get(((ShortPoint)edges.get((int)i4)).x).distanceTo(pts.get(best_id)) + pts.get(((ShortPoint)edges.get((int)i4)).y).distanceTo(pts.get(best_id)));
                if (d < best) {
                    best = d;
                    bestEdge = (ShortPoint)edges.get(i4);
                }
                ++i4;
            }
            short a = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.x))).x;
            short b = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.x))).y;
            short c = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.y))).x;
            short d = ((ShortPoint)directions.get((Object)Integer.valueOf((int)bestEdge.y))).y;
            if (a == bestEdge.y) {
                directions.put(Integer.valueOf(bestEdge.x), new ShortPoint(best_id, (int)b));
            } else {
                directions.put(Integer.valueOf(bestEdge.x), new ShortPoint((int)a, best_id));
            }
            if (c == bestEdge.x) {
                directions.put(Integer.valueOf(bestEdge.y), new ShortPoint(best_id, (int)d));
            } else {
                directions.put(Integer.valueOf(bestEdge.y), new ShortPoint((int)c, best_id));
            }
            directions.put(best_id, new ShortPoint((int)bestEdge.x, (int)bestEdge.y));
            left.remove(left.indexOf(best_id));
            edges.remove(bestEdge);
            edges.add(new ShortPoint((int)bestEdge.x, (int)bestEdge.y));
        }
        int current = 0;
        int previous = -1;
        while (newpoints.size() < pts.size()) {
            if (current == -1) {
                System.err.println("!");
            }
            newpoints.add(pts.get(current).clone());
            ShortPoint sp = (ShortPoint)directions.get(current);
            if (sp.x != previous) {
                previous = current;
                current = sp.x;
                continue;
            }
            previous = current;
            current = sp.y;
        }
        this.points.put(index, newpoints);
    }

    private void updateMinMaxTimes(int index) {
        if (this.Tmax < index) {
            this.Tmax = index;
        }
        if (this.Tmin > index) {
            this.Tmin = index;
        }
    }

    public void finalize(BufferedImage img, int index, float fate_score) {
        if (this.points.get(index) != null) {
            DoublePoint com = this.getCOM(index);
            try {
                double area = this.getArea(index);
                float avg_area_save = (float)this.avgArea;
                float cubicmicrons = (float)(4.1887902047863905 * Math.pow(Math.sqrt(area / Math.PI) * (Double)this.track.micrometerMultiplier.getValue(), 3.0));
                CellStatistics cs = new CellStatistics(cubicmicrons, (short)area, (float)this.getCompactness(index), avg_area_save, (short)com.x, (short)com.y, 0, fate_score);
                this.stats.put(index, cs);
                this.updateMinMaxTimes(index);
            }
            catch (NullPointerException e) {
                System.err.println("NULL");
            }
        }
    }

    public int Tmin() {
        if (this.stats.get(this.Tmin) == null) {
            this.accurateUpdateMinMaxTimes();
        }
        return this.Tmin;
    }

    public int Tmax() {
        if (this.stats.get(this.Tmax) == null) {
            this.accurateUpdateMinMaxTimes();
        }
        return this.Tmax;
    }

    private void accurateUpdateMinMaxTimes() {
        int min = 9999999;
        int max = -9999999;
        for (Integer i : this.points.keySet()) {
            if (i > max) {
                max = i;
                continue;
            }
            if (i >= min) continue;
            min = i;
        }
        this.Tmax = max;
        this.Tmin = min;
    }

    public synchronized LinkedList<DoublePoint> getPoints(int index) {
        LinkedList<DoublePoint> result = new LinkedList<DoublePoint>();
        double oldx = 0.0;
        double oldy = 0.0;
        int i = 0;
        while (i < this.points.get(index).size() - 1) {
            DoublePoint v = this.points.get(index).get(i + 1).minus(this.points.get(index).get(i)).normalized().scale(0.5);
            DoublePoint current = this.points.get(index).get(i);
            while (current.squaredDistance(this.points.get(index).get(i + 1)) > 0.15) {
                double newx = current.x;
                double newy = current.y;
                if (newx != oldx || newy != oldy) {
                    result.add(new DoublePoint(newx, newy));
                }
                oldx = newx;
                oldy = newy;
                current = current.plus(v);
            }
            ++i;
        }
        DoublePoint v = this.points.get(index).get(0).minus(this.points.get(index).get(this.points.get(index).size() - 1)).normalized().scale(0.5);
        DoublePoint current = this.points.get(index).get(this.points.get(index).size() - 1);
        while (current.squaredDistance(this.points.get(index).get(0)) > 0.15) {
            double newx = current.x;
            double newy = current.y;
            if (newx != oldx || newy != oldy) {
                result.add(new DoublePoint(newx, newy));
            }
            oldx = newx;
            oldy = newy;
            current = current.plus(v);
        }
        return result;
    }

    public double squaredDistanceTo(Cell amoeba, int index) {
        return this.getCenter(index).squaredDistance(amoeba.getCenter(index));
    }

    public double getCompactness(int index) {
        return Math.PI * 4 * this.getArea(index) / Math.pow(this.getPerimeter(index), 2.0);
    }

    private double getPerimeter(int index) {
        double perimeter = 0.0;
        int i = 1;
        while (i < this.points.get(index).size()) {
            perimeter += this.points.get(index).get(i).distanceTo(this.points.get(index).get(i - 1));
            ++i;
        }
        return perimeter + this.points.get(index).get(0).distanceTo(this.points.get(index).get(this.points.get(index).size() - 1));
    }

    public short getAverageNonEdgeBrightness(BufferedImage img, int index) {
        double avg = 0.0;
        LinkedList<DoublePoint> pix = this.getPoints(index);
        for (DoublePoint sp : pix) {
            short brightness = (short)Static.gray(img, (int)Math.round(sp.x), (int)Math.round(sp.y));
            avg += (double)brightness;
        }
        return (short)(avg /= (double)pix.size());
    }

    public void setModeledMasses() {
        double d = 500 + Math.max(this.Tbirth, this.Tenter);
        double r = 0.001;
        double m0 = 200.0;
        double currentError = 0.0;
        int count = 0;
        for (int t : this.stats.keySet()) {
            if (this.getStats(t) == null) continue;
            double mass = this.getStats((int)t).mass;
            ++count;
            double model = m0;
            if ((double)t > d) {
                model = m0 * Math.pow(1.0 + r, (double)t - d);
            }
            currentError += Math.pow(model - mass, 2.0);
        }
        currentError /= (double)count;
        double Tmax = 1000.0;
        double Tmin = Tmax / 1000.0;
        double T = Tmax;
        Random gen = new Random();
        while (T > Tmin) {
            count = 0;
            double d2 = Math.max(0.0, (1.0 + gen.nextGaussian() * 0.05) * d + gen.nextGaussian() * 5.0);
            double r2 = r + gen.nextGaussian() * 0.001;
            if (gen.nextDouble() < 0.05) {
                r2 = r + gen.nextGaussian() * 0.1;
            }
            double m02 = Math.max(0.0, (1.0 + gen.nextGaussian() * 0.05) * m0 + gen.nextGaussian() * 2.0);
            double error = 0.0;
            for (int t : this.stats.keySet()) {
                if (this.getStats(t) == null) continue;
                double mass = this.getStats((int)t).mass;
                ++count;
                double model = m02;
                if ((double)t > d2) {
                    model = m02 * Math.pow(1.0 + r2, (double)t - d2);
                }
                error += Math.pow(model - mass, 2.0);
            }
            double chance = Math.exp((currentError - (error /= (double)count)) / T);
            if (gen.nextDouble() < chance) {
                d = d2;
                r = r2;
                m0 = m02;
                currentError = error;
            }
            T *= 0.99;
        }
        for (int t : this.stats.keySet()) {
            double model = m0;
            if ((double)t > d) {
                model = m0 * Math.pow(1.0 + r, (double)t - d);
            }
            this.stats.get((Object)Integer.valueOf((int)t)).modeledMass = (float)model;
            this.stats.get((Object)Integer.valueOf((int)t)).fate_score = (float)(Math.sqrt(Math.pow(model - (double)this.stats.get((Object)Integer.valueOf((int)t)).mass, 2.0)) / (0.5 * model + 0.5 + (double)this.stats.get((Object)Integer.valueOf((int)t)).mass));
        }
    }

    public void setModeledMasses2() {
        double best = 9.99999999E8;
        int bestc = this.Tmin;
        double bestM0 = 0.0;
        double bestb = 0.0;
        int max = Math.max(this.Tgone, Math.max(this.Tdie, this.Tdiv));
        if (max == -1) {
            max = this.Tmax;
        }
        int c = this.Tmin;
        while (c < max) {
            double M0 = 0.0;
            int beforeCount = 0;
            int t = 0;
            while (t <= c) {
                if (this.stats.get(t) != null) {
                    M0 += (double)this.stats.get((Object)Integer.valueOf((int)t)).mass;
                    ++beforeCount;
                }
                ++t;
            }
            double b = 0.0;
            double lm0 = Math.log(M0 /= (double)beforeCount);
            double numerator = 0.0;
            double denominator = 0.0;
            int t2 = c + 1;
            while (t2 < max) {
                int x = t2 - c;
                if (this.stats.get(t2) != null) {
                    numerator += (Math.log(this.stats.get((Object)Integer.valueOf((int)t2)).mass) - lm0) * (double)x;
                    denominator += (double)(x * x);
                }
                ++t2;
            }
            b = numerator / denominator;
            double sumofsquares = 0.0;
            int squarecount = 0;
            int t3 = this.Tmin;
            while (t3 < max) {
                if (this.stats.get(t3) != null) {
                    double mass = this.stats.get((Object)Integer.valueOf((int)t3)).mass;
                    double model = M0;
                    if (t3 > c) {
                        model = M0 * Math.exp(b * (double)(t3 - c));
                    }
                    sumofsquares += Math.pow(mass - model, 2.0);
                    ++squarecount;
                }
                ++t3;
            }
            if ((sumofsquares /= (double)squarecount) < best) {
                best = sumofsquares;
                bestc = c;
                bestM0 = M0;
                bestb = b;
            }
            c += 5;
        }
        int count = 0;
        this.RMSD = 0.0;
        this.inflection = bestc;
        this.exponent = bestb;
        this.startv = bestM0;
        int t = this.Tmin;
        while (t <= max) {
            if (this.stats.get(t) != null) {
                double model = bestM0;
                if (t > bestc) {
                    model = bestM0 * Math.exp(bestb * (double)(t - bestc));
                }
                this.stats.get((Object)Integer.valueOf((int)t)).modeledMass = (float)model;
                this.stats.get((Object)Integer.valueOf((int)t)).fate_score = (float)(Math.abs(model - (double)this.stats.get((Object)Integer.valueOf((int)t)).mass) / model);
                this.RMSD += Math.pow(model - (double)this.stats.get((Object)Integer.valueOf((int)t)).mass, 2.0);
                ++count;
            }
            ++t;
        }
        this.RMSD = Math.sqrt(this.RMSD / (double)count);
    }

    public void saveSelf(BufferedWriter pw) {
        int t;
        String out = "";
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        sb.append(",");
        sb.append(this.Tdiv);
        sb.append(",");
        sb.append(this.Tdie);
        sb.append(",");
        sb.append(this.Tgone);
        sb.append(",");
        sb.append(this.Tbirth);
        sb.append(",");
        sb.append(this.Tenter);
        sb.append(",");
        sb.append(this.gen);
        sb.append(",");
        sb.append(this.motherId);
        sb.append(Static.newline);
        Iterator<Object> iterator = this.stats.keySet().iterator();
        while (iterator.hasNext()) {
            t = iterator.next();
            if (this.stats.get(t) == null) continue;
            sb.append(t);
            sb.append(",");
            sb.append(this.stats.get(t).toString());
        }
        sb.append(Static.newline);
        sb.append("PIXELS" + Static.newline);
        iterator = this.points.keySet().iterator();
        while (iterator.hasNext()) {
            t = iterator.next();
            if (this.points.get(t) == null) continue;
            sb.append(t);
            for (DoublePoint dp : this.points.get(t)) {
                sb.append(String.format(",%3.3f,%3.3f", dp.x, dp.y));
            }
            sb.append(Static.newline);
        }
        sb.append("WAYPOINTS" + Static.newline);
        for (Waypoint w : this.waypoints) {
            sb.append(String.valueOf(w.start) + "," + w.end + "," + w.x1 + "," + w.y1 + "," + w.x2 + "," + w.y2 + Static.newline);
        }
        sb.append("END CELL" + Static.newline);
        try {
            pw.write(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public float[] getRawVolumeOverLifetime(int steps, int startTime) {
        int max;
        float[] result = new float[steps];
        float averageStartingMass = (float)this.getAverageStartingMass();
        double t = this.Tmin;
        if (this.gen == 0) {
            t = -startTime;
        }
        if ((max = Math.max(this.Tgone, Math.max(this.Tdie, this.Tdiv))) == -1) {
            max = this.Tmax;
        }
        double step = ((double)max - t) / (double)steps;
        int i = 0;
        while (i < steps) {
            if (t >= (double)this.Tmin) {
                try {
                    result[i] = t <= (double)(this.Tmin + 25) ? averageStartingMass : this.stats.get((Object)Integer.valueOf((int)((int)t))).mass;
                }
                catch (Exception e) {
                    result[i] = i > 0 ? result[i - 1] : averageStartingMass;
                }
                t += step;
            } else {
                result[i] = averageStartingMass;
                t += step;
            }
            ++i;
        }
        return result;
    }

    public float[] getNormalizedSizeOverLifetime(int steps) {
        float[] result = new float[steps];
        if (this.Tmax > this.Tmin) {
            if (this.RMSD == -1.0) {
                this.setModeledMasses2();
            }
            double tstep = (this.Tmax - this.Tmin) / steps;
            double t = this.Tmin;
            int i = 0;
            while (i < steps) {
                result[i] = t < (double)this.inflection ? 1.0f : (float)Math.exp((t - (double)this.inflection) * this.exponent);
                t += tstep;
                ++i;
            }
        }
        return result;
    }

    public void killAt(int index) {
        this.Tgone = -1;
        this.Tdiv = -1;
        this.Tmax = this.Tdie = index;
    }

    public void leaveAt(int index) {
        this.Tgone = index;
        this.Tdiv = -1;
        this.Tdie = -1;
        this.Tmax = this.Tgone;
        HashMap<Integer, ArrayList<DoublePoint>> newPoints = new HashMap<Integer, ArrayList<DoublePoint>>();
        HashMap<Integer, CellStatistics> newStats = new HashMap<Integer, CellStatistics>();
        for (Integer t : this.points.keySet()) {
            if (t >= this.Tgone) continue;
            newPoints.put(t, this.points.get(t));
            newStats.put(t, this.stats.get(t));
        }
        this.points = newPoints;
        this.stats = newStats;
        boolean found = false;
        int i = 0;
        while (i < this.waypoints.size()) {
            if (!found) {
                if (this.waypoints.get(i).contains(index)) {
                    this.waypoints.get((int)i).end = index;
                    found = true;
                }
            } else {
                this.waypoints.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void takeOver(Cell other, int index) {
        Waypoint his = other.getWaypointAt(index);
        DoublePoint hispoint = his.getPoint(index);
        int hisindex = other.waypoints.indexOf(his);
        Waypoint mine = this.getWaypointAt(index);
        if (mine == null) {
            return;
        }
        Waypoint copymine = new Waypoint(mine.start, mine.end, mine.x1, mine.y1, mine.x2, mine.y2);
        int mineindex = this.waypoints.indexOf(mine);
        DoublePoint minepoint = mine.getPoint(index);
        if (his != null) {
            ArrayList<Waypoint> tail = new ArrayList<Waypoint>();
            int t = hisindex + 1;
            while (t < other.waypoints.size()) {
                tail.add(other.waypoints.remove(t));
                --t;
                ++t;
            }
            if (mine != null) {
                ArrayList<Waypoint> mytail = new ArrayList<Waypoint>();
                int t2 = mineindex + 1;
                while (t2 < this.waypoints.size()) {
                    mytail.add(this.waypoints.remove(t2));
                    --t2;
                    ++t2;
                }
                mine.x2 = (int)Math.round(minepoint.x);
                mine.y2 = (int)Math.round(minepoint.y);
                this.waypoints.add(new Waypoint(index, his.end, mine.x2, mine.y2, his.x2, his.y2));
                this.waypoints.addAll(tail);
                his.end = index;
                his.x2 = (int)Math.round(hispoint.x);
                his.y2 = (int)Math.round(hispoint.y);
                other.waypoints.add(new Waypoint(index, copymine.end, his.x2, his.y2, copymine.x2, copymine.y2));
                other.waypoints.addAll(mytail);
            }
            int tempid = other.id;
            other.id = this.id;
            this.id = tempid;
            int tempTdiv = other.Tdiv;
            other.Tdiv = this.Tdiv;
            this.Tdiv = tempTdiv;
            int tempTdie = other.Tdie;
            other.Tdie = this.Tdie;
            this.Tdie = tempTdie;
            int tempTgone = other.Tgone;
            other.Tgone = this.Tgone;
            this.Tgone = tempTgone;
            int temp = other.Tmax;
            other.Tmax = this.Tmax;
            this.Tmax = temp;
        }
    }

    public String toString() {
        String end = "";
        if (this.Tdie > -1) {
            end = " Tdie@" + this.Tdie;
        } else if (this.Tdiv > -1) {
            end = " Tdiv@" + this.Tdiv;
        } else if (this.Tgone > -1) {
            end = " Tleave@" + this.Tgone;
        }
        return "C" + this.gen + ": " + this.id + "[" + this.wmin + "-" + this.wmax + "]" + end;
    }

    public int response() {
        double[] masses = new double[5];
        int min = this.Tmin();
        int max = this.Tmax();
        int i = 0;
        while (i < masses.length) {
            int t = i * (max - min - 20) / masses.length + min + 10;
            try {
                masses[i] = this.stats.get((Object)Integer.valueOf((int)t)).mass;
            }
            catch (Exception e) {
                return 0;
            }
            ++i;
        }
        boolean didntshrink = true;
        int growCount = 0;
        int i2 = 0;
        while (i2 < masses.length - 1) {
            if (masses[i2 + 1] < masses[i2 + 1] * 0.75) {
                didntshrink = false;
            }
            if (masses[i2] * (1.0 + 0.5 / (double)masses.length) < masses[i2 + 1]) {
                ++growCount;
            }
            ++i2;
        }
        if (didntshrink && growCount > 1 && masses[masses.length - 1] > 1.4 * masses[0]) {
            return 1;
        }
        if (!didntshrink || growCount == 0 || masses[masses.length - 1] < 1.4 * masses[0]) {
            return -1;
        }
        return 0;
    }

    public int response2() {
        double[] volumes = new double[Math.min(this.Tmax - this.Tmin, 30)];
        int t = 0;
        while (t < volumes.length) {
            volumes[t] = this.stats.get((Object)Integer.valueOf((int)(this.Tmin() + t))).mass;
            ++t;
        }
        double lastVolume = this.stats.get((Object)Integer.valueOf((int)this.Tmax())).mass;
        double sd = Static.std(volumes);
        if (lastVolume > this.startv + 3.0 * sd) {
            return 1;
        }
        if (lastVolume <= this.startv + 3.0 * sd) {
            return -1;
        }
        return 0;
    }

    public int response3() {
        double growthThreshold = 1.75;
        int window = 30;
        if (this.lifeSpan() < window) {
            return -3;
        }
        int min = Math.max(this.Tbirth, this.Tenter);
        int max = Math.max(this.Tgone, Math.max(this.Tdie, this.Tdiv)) - 1;
        if (max < min) {
            max = this.Tmax() - 1;
        }
        double[] svolumes = new double[Math.min(max - min, window)];
        double[] evolumes = new double[Math.min(max - min, window)];
        int t = 0;
        while (t < svolumes.length) {
            try {
                svolumes[t] = this.stats.get((Object)Integer.valueOf((int)(min + t))).mass;
                evolumes[t] = this.stats.get((Object)Integer.valueOf((int)(max - t))).mass;
            }
            catch (Exception e) {
                return -3;
            }
            ++t;
        }
        double avgStart = Static.average(svolumes);
        double avgEnd = Static.average(evolumes);
        if (avgEnd >= growthThreshold * avgStart) {
            return 1;
        }
        boolean grew = false;
        double[] w = new double[window];
        int t2 = min;
        while (t2 <= max) {
            try {
                double[] neww = new double[window];
                int i = 0;
                while (i < neww.length - 1) {
                    neww[i] = w[i + 1];
                    ++i;
                }
                neww[window - 1] = this.stats.get((Object)Integer.valueOf((int)t2)).mass;
                double avg = Static.average(neww);
                w = neww;
                if (avg > growthThreshold * avgStart) {
                    grew = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++t2;
        }
        if (grew) {
            return 0;
        }
        return -1;
    }

    public int response4() {
        double growthThreshold = ((Integer)this.track.growthThreshold.getValue()).intValue();
        double endingThreshold = ((Integer)this.track.endingSizeThreshold.getValue()).intValue();
        int window = Math.min(30, Math.max(1, this.track.pngs.size() / 10));
        if (this.lifeSpan() < window) {
            return -3;
        }
        int min = Math.max(this.Tbirth, this.Tenter);
        int max = Math.max(this.Tgone, Math.max(this.Tdie, this.Tdiv)) - 1;
        if (max < min) {
            max = this.Tmax() - 1;
        }
        double[] svolumes = new double[Math.min(max - min, window)];
        double[] evolumes = new double[Math.min(max - min, window)];
        int t = 0;
        while (t < svolumes.length) {
            try {
                svolumes[t] = this.stats.get((Object)Integer.valueOf((int)(min + t))).mass;
                evolumes[t] = this.stats.get((Object)Integer.valueOf((int)(max - t))).mass;
            }
            catch (Exception e) {
                return -3;
            }
            ++t;
        }
        double avgStart = Static.average(svolumes);
        double avgEnd = Static.average(evolumes);
        if (avgEnd >= growthThreshold + avgStart || avgEnd >= endingThreshold) {
            return 1;
        }
        boolean grew = false;
        double[] w = new double[window];
        int t2 = min;
        while (t2 <= max) {
            try {
                double[] neww = new double[window];
                int i = 0;
                while (i < neww.length - 1) {
                    neww[i] = w[i + 1];
                    ++i;
                }
                neww[window - 1] = this.stats.get((Object)Integer.valueOf((int)t2)).mass;
                double avg = Static.average(neww);
                w = neww;
                if (avg > growthThreshold + avgStart) {
                    grew = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++t2;
        }
        if (grew) {
            return 0;
        }
        return -1;
    }

    public double getAverageStartingMass() {
        double avg = 0.0;
        int count = 0;
        int i = 0;
        while (i < 25) {
            try {
                avg += (double)this.stats.get((Object)Integer.valueOf((int)(this.Tmin + i + 1))).mass;
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return avg / (double)count;
    }

    public double getAverageEndingMass() {
        double avg = 0.0;
        int count = 0;
        int i = 0;
        while (i < 25) {
            try {
                int max = Math.max(this.Tgone, Math.max(this.Tdie, this.Tdiv));
                if (max == -1) {
                    max = this.Tmax;
                }
                avg += (double)this.stats.get((Object)Integer.valueOf((int)(max - i - 1))).mass;
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return avg / (double)count;
    }

    public int getTrueFateAge(int startingTime) {
        if (this.Tdiv == -1 && this.Tdie == -1) {
            return this.Tmax() - this.Tmin();
        }
        if (this.gen == 0) {
            return Math.max(this.Tdiv, this.Tdie) + startingTime - this.Tmin;
        }
        return Math.max(this.Tdiv, this.Tdie) - this.Tmin;
    }

    public int getTrueFateTime(int startingTime) {
        if (this.Tdiv == -1 && this.Tdie == -1) {
            return startingTime + this.Tmax();
        }
        return Math.max(this.Tdiv, this.Tdie) + startingTime;
    }

    public int getTrueDivAge(int startingTime) {
        if (this.Tdiv != -1) {
            if (this.gen == 0) {
                return this.Tdiv + startingTime - this.Tmin;
            }
            return this.Tdiv - this.Tmin;
        }
        return -1;
    }

    public int getTrueDecideAge(int startingTime) {
        if (this.gen == 0) {
            return this.inflection + startingTime - this.Tmin;
        }
        return this.inflection - this.Tmin;
    }

    public int getTrueDieAge(int startingTime) {
        if (this.Tdie != -1) {
            if (this.gen == 0) {
                return this.Tdie + startingTime - this.Tmin;
            }
            return this.Tdie - this.Tmin;
        }
        return -1;
    }

    public String getFate() {
        if (this.Tdiv != -1) {
            return "Divided";
        }
        if (this.Tdie != -1) {
            return "Died";
        }
        if (this.Tgone != -1) {
            return "Left";
        }
        return "Survived";
    }
}

