/*
 * Decompiled with CFR 0.152.
 */
package semiTracker3;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import semiTracker3.BinaryTreeNode;
import semiTracker3.Cell;
import semiTracker3.CellDisplay;
import semiTracker3.CellRegion;
import semiTracker3.CircleCandidate;
import semiTracker3.Dialogs;
import semiTracker3.Display;
import semiTracker3.DoublePoint;
import semiTracker3.ShortPoint;
import semiTracker3.Static;
import semiTracker3.Waypoint;

public class Tracker
extends JFrame {
    Tracker self = this;
    BufferedImage current = null;
    BufferedImage sobelImage = null;
    int index = 0;
    static int[][] gradient;
    static final int hotspotRadius = 10;
    ArrayList<LinkedList<ShortPoint>> circlePoints = new ArrayList();
    int[][] current_averages;
    int[][][] img_averages;
    int total_images_processed = 0;
    boolean escape_flag = false;
    private int id = 0;
    boolean applyMinMax = false;
    boolean color_by_score = false;
    boolean animateBlobs = false;
    boolean sobel = false;
    boolean continuousStitch = false;
    boolean endStitch = false;
    boolean finished_task = true;
    boolean debug = false;
    boolean timing = false;
    boolean justsaved = false;
    boolean running = false;
    File dir;
    ArrayList<File> pngs = new ArrayList();
    Display disp;
    CellDisplay cdisp;
    Cell pick;
    Cell daughter1 = null;
    Cell daughter2 = null;
    boolean ctrl_down = false;
    boolean shift_down = false;
    int mX = -1;
    int mY = -1;
    int cx = -1;
    int cy = -1;
    int startingTime = 150;
    int minFateTime = 1440 - this.startingTime;
    KeyEvent currentKeyPressed = null;
    boolean pressed = false;
    boolean donePressAction = true;
    HashSet<Cell> cells = new HashSet();
    HashMap<Integer, Cell> idmap = new HashMap();
    int region_size = 30;
    CellRegion[][] regions;
    JList<Cell> dividing = new JList(new DefaultListModel());
    JList<Cell> dying = new JList(new DefaultListModel());
    JList<Cell> leaving = new JList(new DefaultListModel());
    JList<Cell> unprocessed = new JList(new DefaultListModel());
    JList<Cell> placeholders = new JList(new DefaultListModel());
    JTabbedPane tabber;
    JSpinner pEdge;
    JSpinner pShape;
    JSpinner pKappa;
    JSpinner pGamma;
    JSpinner pFactor;
    JSpinner pExpectedRadius;
    JSpinner pTooSmall;
    JSpinner pTooLarge;
    JSpinner pSpaceFill;
    JSpinner pEdgeThreshold;
    JSpinner pWaypoint;
    JSpinner pNeighborLin;
    JSpinner pNeighborSq;
    JSpinner pCool;
    JSpinner cellRadius;
    JSpinner numberOfPoints;
    JSpinner growthThreshold;
    JSpinner endingSizeThreshold;
    JSpinner micrometerMultiplier;
    Timer autosaver = new Timer(600000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Tracker.this.justsaved && !Tracker.this.running && Tracker.this.getCursor().getType() == 0) {
                File autosaveFile = new File("autosave.dat");
                try {
                    BufferedWriter pw = new BufferedWriter(new FileWriter(autosaveFile));
                    for (Cell c : Tracker.this.cells) {
                        c.saveSelf(pw);
                    }
                    pw.close();
                    Tracker.this.justsaved = true;
                    if (Tracker.this.debug) {
                        System.err.println("Saved everything");
                    }
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
        }
    });
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH-mm-ss";
    private static Color[] colors;

    static {
        colors = new Color[]{Color.blue, Color.green.darker(), Color.yellow.darker(), Color.MAGENTA.darker(), Color.cyan, Color.red, Color.cyan.darker(), Color.green.brighter().brighter(), Color.blue.brighter().brighter(), Color.yellow.darker(), Color.orange, Color.magenta.brighter()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLists() {
        JList<Cell> jList = this.dividing;
        synchronized (jList) {
            JList<Cell> jList2 = this.dying;
            synchronized (jList2) {
                JList<Cell> jList3 = this.leaving;
                synchronized (jList3) {
                    JList<Cell> jList4 = this.unprocessed;
                    synchronized (jList4) {
                        JList<Cell> jList5 = this.placeholders;
                        synchronized (jList5) {
                            ((DefaultListModel)this.dividing.getModel()).removeAllElements();
                            ((DefaultListModel)this.dying.getModel()).removeAllElements();
                            ((DefaultListModel)this.leaving.getModel()).removeAllElements();
                            ((DefaultListModel)this.unprocessed.getModel()).removeAllElements();
                            ((DefaultListModel)this.placeholders.getModel()).removeAllElements();
                            int pick_list = -1;
                            int pick_index = -1;
                            HashSet<Cell> hashSet = this.cells;
                            synchronized (hashSet) {
                                for (Cell c : this.cells) {
                                    if (c.gen > -1) {
                                        if (c.Tdiv != -1) {
                                            ((DefaultListModel)this.dividing.getModel()).addElement(c);
                                            if (!c.equals(this.pick)) continue;
                                            pick_list = 0;
                                            pick_index = this.dividing.getModel().getSize() - 1;
                                            continue;
                                        }
                                        if (c.Tdie != -1) {
                                            ((DefaultListModel)this.dying.getModel()).addElement(c);
                                            if (!c.equals(this.pick)) continue;
                                            pick_list = 1;
                                            pick_index = this.dying.getModel().getSize() - 1;
                                            continue;
                                        }
                                        if (c.Tgone != -1) {
                                            ((DefaultListModel)this.leaving.getModel()).addElement(c);
                                            if (!c.equals(this.pick)) continue;
                                            pick_list = 2;
                                            pick_index = this.leaving.getModel().getSize() - 1;
                                            continue;
                                        }
                                        ((DefaultListModel)this.unprocessed.getModel()).addElement(c);
                                        if (!c.equals(this.pick)) continue;
                                        pick_list = 3;
                                        pick_index = this.unprocessed.getModel().getSize() - 1;
                                        continue;
                                    }
                                    ((DefaultListModel)this.placeholders.getModel()).addElement(c);
                                    if (!c.equals(this.pick)) continue;
                                    pick_list = 4;
                                    pick_index = this.placeholders.getModel().getSize() - 1;
                                }
                                if (pick_list != -1) {
                                    System.err.println("pick list is " + pick_list + " pick index is " + pick_index);
                                    switch (pick_list) {
                                        case 0: {
                                            this.dividing.setSelectedIndex(pick_index);
                                            break;
                                        }
                                        case 1: {
                                            this.dying.setSelectedIndex(pick_index);
                                            break;
                                        }
                                        case 2: {
                                            this.leaving.setSelectedIndex(pick_index);
                                            break;
                                        }
                                        case 3: {
                                            this.unprocessed.setSelectedIndex(pick_index);
                                            break;
                                        }
                                        case 4: {
                                            this.placeholders.setSelectedIndex(pick_index);
                                        }
                                    }
                                    this.tabber.setSelectedIndex(pick_list);
                                }
                            }
                        }
                    }
                }
            }
            this.tabber.paintImmediately(0, 0, this.tabber.getWidth(), this.tabber.getHeight());
        }
    }

    private void rescaleAndSave(File savefolder, int min, int max) {
        int counter = 0;
        long time = System.nanoTime();
        for (File f : this.pngs) {
            if (this.escape_flag) {
                this.escape_flag = false;
                return;
            }
            try {
                ImageIO.write((RenderedImage)Static.renormalize(Static.getGrayscale(ImageIO.read(f)), min, max, false), "png", new File(String.valueOf(savefolder.getAbsolutePath()) + File.separator + f.getName()));
                long elapsed = (System.nanoTime() - time) / 1000000000L;
                int remaining = (int)((double)(elapsed / (long)(counter + 1) * (long)(this.pngs.size() - counter)) / 60.0);
                this.info("Image rescaled to " + min + "-" + max + " and saved to " + savefolder.getName() + " " + counter++ + "/" + this.pngs.size() + " come back in " + remaining + " minutes.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.info("Saved all rescaled images!");
    }

    public int getNextId() {
        int result = this.id++;
        return result;
    }

    private void setDir(File d) {
        this.dir = d;
        this.pngs.clear();
        if (this.debug) {
            System.err.println("Found " + d.list().length + " files in dir " + d.getName());
        }
        String[] strs = d.list();
        File[] files = d.listFiles();
        int i = 0;
        while (i < files.length) {
            if (strs[i].toLowerCase().endsWith("png") || strs[i].toLowerCase().endsWith("jpg")) {
                this.pngs.add(files[i]);
            }
            ++i;
        }
        Collections.sort(this.pngs, new FComparator());
        this.img_averages = new int[this.pngs.size()][1][1];
    }

    public void setCurrent(int new_index) {
        if (this.pngs.size() > 0) {
            if ((new_index %= this.pngs.size()) < 0) {
                new_index = this.pngs.size() + new_index;
            }
            this.current = null;
            this.current = this.applyMinMax ? Static.adjustMinMax(this.getImage(new_index)) : this.getImage(new_index);
            this.sobelImage = Static.getSobelTransformed(this.current);
            this.regions = null;
            gradient = Static.getIntArray(this.sobelImage);
            this.total_images_processed = Math.max(this.total_images_processed, new_index + 1);
            this.index = new_index;
            this.setTitle("Force Algorithm Semi-automated Tracker V2 (C) Max Shokhirev Signaling Systems Lab 2013-2014. Current Frame = " + this.index + "/" + this.pngs.size());
        } else {
            this.info("No images loaded");
        }
    }

    public void setCurrentNoGradient(int new_index) {
        if (this.pngs.size() > 0) {
            if ((new_index %= this.pngs.size()) < 0) {
                new_index = this.pngs.size() + new_index;
            }
            this.current = null;
            this.current = this.applyMinMax ? Static.adjustMinMax(this.getImage(new_index)) : this.getImage(new_index);
            this.regions = null;
            this.total_images_processed = Math.max(this.total_images_processed, new_index + 1);
            this.index = new_index;
            this.setTitle("Force Algorithm Semi-automated Tracker(C) Max Shokhirev Signaling Systems Lab 2013. Current Frame = " + this.index + "/" + this.pngs.size());
        } else {
            this.info("No images loaded");
        }
    }

    private void predictAllTracks(boolean multithread) {
        LinkedList<Cell> goodCells = new LinkedList<Cell>();
        goodCells.addAll(this.cells);
        if (multithread) {
            int cores = Runtime.getRuntime().availableProcessors() - 1;
            boolean tracking = true;
            while (tracking) {
                if (this.escape_flag) {
                    this.escape_flag = false;
                    break;
                }
                tracking = false;
                this.setCurrentNoGradient(this.index + 1);
                int count = 0;
                LinkedList<LinkedList<Cell>> cellGroups = Static.splitList(goodCells, cores);
                LinkedList<Predictor> predictors = new LinkedList<Predictor>();
                for (LinkedList linkedList : cellGroups) {
                    predictors.add(new Predictor(linkedList, this.index));
                }
                goodCells.clear();
                for (Predictor predictor : predictors) {
                    try {
                        predictor.join();
                        count += predictor.count;
                        goodCells.addAll(predictor.remaining);
                        tracking |= predictor.tracking;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.info("Predicted " + count + " cells for a step");
            }
        } else {
            boolean tracking = true;
            while (tracking) {
                if (this.escape_flag) {
                    this.escape_flag = false;
                    break;
                }
                tracking = false;
                this.setCurrentNoGradient(this.index + 1);
                int count = 0;
                LinkedList<Cell> newGoods = new LinkedList<Cell>();
                for (Cell c : goodCells) {
                    boolean bl = this.predictTrackOneStep(c);
                    tracking |= bl;
                    if (!bl) continue;
                    ++count;
                    newGoods.add(c);
                }
                goodCells = newGoods;
                this.info("Predicted " + count + " cells for a step");
            }
        }
    }

    private void predictTrack(Cell c) {
        block15: {
            if (c.getWaypointAt(this.index) != null) {
                return;
            }
            int searchRadius = 15;
            double distanceNoise = 1.0;
            double thresholdProbability = 0.95;
            double cumulativeThreshold = 1.0E-6;
            double cumulativeThreshold2 = 1.0E-9;
            try {
                int step = 1;
                while (true) {
                    LinkedList<Cell> candidates;
                    if (this.escape_flag) {
                        this.escape_flag = false;
                        break block15;
                    }
                    DoublePoint dp = c.getWaypointPosition(this.index - step);
                    if (dp == null) {
                        dp = c.getCenter(this.index - step);
                    }
                    if (dp == null) {
                        dp = new DoublePoint(c.waypoints.get((int)(c.waypoints.size() - 1)).x2, c.waypoints.get((int)(c.waypoints.size() - 1)).y2);
                    }
                    if ((candidates = this.getCellCandidatesNearby((int)Math.round(dp.x), (int)Math.round(dp.y), searchRadius, 2, 10)).size() > 0) {
                        ArrayList<Cell> orderedCells = new ArrayList<Cell>();
                        ArrayList<Double> probabilities = new ArrayList<Double>();
                        double cumulativeP = 0.0;
                        for (Cell candidate : candidates) {
                            double distance = candidate.getCenter(this.index).distanceTo(dp);
                            double p = Math.exp(-distance / distanceNoise);
                            cumulativeP += p;
                            int i = 0;
                            while (i < orderedCells.size()) {
                                if ((Double)probabilities.get(i) < p) break;
                                ++i;
                            }
                            orderedCells.add(i, candidate);
                            probabilities.add(i, p);
                        }
                        double bestProbability = (Double)probabilities.get(0) / cumulativeP;
                        System.err.println(String.valueOf(this.index) + " bestProbability=" + bestProbability + " cumulative is " + cumulativeP + " index=" + this.index + " number of candidates: " + probabilities.size());
                        if (bestProbability >= thresholdProbability && (probabilities.size() > 1 && cumulativeP > cumulativeThreshold || probabilities.size() == 1 && cumulativeP > cumulativeThreshold2)) {
                            c.addWaypoint(this.index, (int)Math.round(((Cell)orderedCells.get((int)0)).getCenter((int)this.index).x), (int)Math.round(((Cell)orderedCells.get((int)0)).getCenter((int)this.index).y));
                            this.paint();
                            if (bestProbability == cumulativeP && step < 5) {
                                ++step;
                            }
                            if (this.index + step < this.pngs.size()) {
                                this.setCurrentNoGradient(this.index + step);
                                continue;
                            }
                        } else {
                            if (step > 1) {
                                this.setCurrentNoGradient(this.index - 1);
                                --step;
                                continue;
                            }
                            this.setCurrentNoGradient(this.index - step);
                        }
                        break block15;
                    }
                    System.err.println("No candidates!");
                    if (step <= 1) break;
                    this.setCurrentNoGradient(this.index - 1);
                    --step;
                }
                this.setCurrentNoGradient(this.index - step);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean predictTrackOneStep(Cell c) {
        if (c.waypoints.size() > 0 && c.waypoints.get((int)(c.waypoints.size() - 1)).end >= this.index) {
            return false;
        }
        int searchRadius = 15;
        double distanceNoise = 1.0;
        double thresholdProbability = 0.95;
        double cumulativeThreshold = 1.0E-6;
        double cumulativeThreshold2 = 1.0E-9;
        try {
            LinkedList<Cell> candidates;
            DoublePoint dp = c.getWaypointPosition(this.index - 1);
            if (dp == null) {
                dp = c.getCenter(this.index - 1);
            }
            if (dp == null) {
                try {
                    dp = new DoublePoint(c.waypoints.get((int)(c.waypoints.size() - 1)).x2, c.waypoints.get((int)(c.waypoints.size() - 1)).y2);
                }
                catch (Exception e) {
                    dp = c.getCenter(c.Tmax());
                }
            }
            if ((candidates = this.getCellCandidatesNearby((int)Math.round(dp.x), (int)Math.round(dp.y), searchRadius, 2, 10)).size() > 0) {
                ArrayList<Cell> orderedCells = new ArrayList<Cell>();
                ArrayList<Double> probabilities = new ArrayList<Double>();
                double cumulativeP = 0.0;
                for (Cell candidate : candidates) {
                    double distance = candidate.getCenter(this.index).distanceTo(dp);
                    double p = Math.exp(-distance / distanceNoise);
                    cumulativeP += p;
                    int i = 0;
                    while (i < orderedCells.size()) {
                        if ((Double)probabilities.get(i) < p) break;
                        ++i;
                    }
                    orderedCells.add(i, candidate);
                    probabilities.add(i, p);
                }
                double bestProbability = (Double)probabilities.get(0) / cumulativeP;
                System.err.println(String.valueOf(this.index) + " bestProbability=" + bestProbability + " cumulative is " + cumulativeP + " index=" + this.index + " number of candidates: " + probabilities.size());
                if (bestProbability >= thresholdProbability && (probabilities.size() > 1 && cumulativeP > cumulativeThreshold || probabilities.size() == 1 && cumulativeP > cumulativeThreshold2)) {
                    c.addWaypoint(this.index, (int)Math.round(((Cell)orderedCells.get((int)0)).getCenter((int)this.index).x), (int)Math.round(((Cell)orderedCells.get((int)0)).getCenter((int)this.index).y));
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private LinkedList<Cell> getCellCandidatesNearby(int x, int y, int rad, int rmin, int rmax) {
        int i;
        boolean[][][] clusteredSpots = this.getClusteredHotspots(x, rad, y, rad, rmin, rmax);
        LinkedList<CircleCandidate> goodCandidates = new LinkedList<CircleCandidate>();
        LinkedList<CircleCandidate> badCandidates = new LinkedList<CircleCandidate>();
        LinkedList<CircleCandidate> reallyBadCandidates = new LinkedList<CircleCandidate>();
        int hotspots = 0;
        int r = Math.max(0, rmin);
        while (r <= Math.min(clusteredSpots.length - 1, rmax)) {
            LinkedList<ShortPoint> cps = this.circlePoints.get(r);
            i = Math.max(0, x - rad);
            while (i <= Math.min(clusteredSpots[r].length - 1, x + rad)) {
                int j = Math.max(0, y - rad);
                while (j <= Math.min(clusteredSpots[r][i].length - 1, y + rad)) {
                    if (clusteredSpots[r][i][j]) {
                        int ind;
                        double score;
                        ArrayList<Integer> gradients = new ArrayList<Integer>();
                        for (ShortPoint sp : cps) {
                            try {
                                int edgeness = gradient[sp.x + i][sp.y + j];
                                int ind2 = 0;
                                while (ind2 < gradients.size()) {
                                    if ((Integer)gradients.get(ind2) > edgeness) break;
                                    ++ind2;
                                }
                                gradients.add(ind2, edgeness);
                            }
                            catch (Exception edgeness) {
                                // empty catch block
                            }
                        }
                        ++hotspots;
                        DoublePoint vector = new DoublePoint(x, y);
                        double grad1 = ((Integer)gradients.get(gradients.size() / 4)).intValue();
                        double grad3 = ((Integer)gradients.get(gradients.size() - 1)).intValue();
                        if (grad1 > 5000.0 && grad3 > 40000.0) {
                            score = (double)(r * r) * grad1 / (1.0 + vector.squaredDistance(i, j));
                            ind = 0;
                            while (ind < goodCandidates.size()) {
                                if (((CircleCandidate)goodCandidates.get((int)ind)).score > score) break;
                                ++ind;
                            }
                            goodCandidates.add(ind, new CircleCandidate(i, j, r, score));
                        } else if (grad1 > 500.0 && grad3 > 2000.0) {
                            score = (double)(r * r) * grad1 / (1.0 + vector.squaredDistance(i, j));
                            ind = 0;
                            while (ind < badCandidates.size()) {
                                if (((CircleCandidate)badCandidates.get((int)ind)).score > score) break;
                                ++ind;
                            }
                            badCandidates.add(ind, new CircleCandidate(i, j, r, score));
                        } else if (grad1 > 500000.0 && grad3 > 0.0) {
                            score = (double)(r * r) * grad1 / (1.0 + vector.squaredDistance(i, j));
                            ind = 0;
                            while (ind < reallyBadCandidates.size()) {
                                if (((CircleCandidate)reallyBadCandidates.get((int)ind)).score > score) break;
                                ++ind;
                            }
                            reallyBadCandidates.add(ind, new CircleCandidate(i, j, r, score));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++r;
        }
        Cell[][] map = new Cell[gradient.length][gradient[0].length];
        LinkedList<Cell> list = new LinkedList<Cell>();
        if (goodCandidates.size() == 0) {
            goodCandidates.addAll(badCandidates);
        }
        if (goodCandidates.size() == 0) {
            goodCandidates.addAll(reallyBadCandidates);
        }
        i = 0;
        while (i < goodCandidates.size()) {
            Cell newSpot = new Cell(this, gradient, clusteredSpots, this.index, -99, ((CircleCandidate)goodCandidates.get((int)i)).x, ((CircleCandidate)goodCandidates.get((int)i)).y, ((CircleCandidate)goodCandidates.get((int)i)).r);
            int overlap = 0;
            for (DoublePoint dp : newSpot.points.get(this.index)) {
                if (map[(int)Math.min((double)(map.length - 1), Math.max(0.0, dp.x))][(int)Math.min(Math.max(0.0, dp.y), (double)(map[0].length - 1))] == null) continue;
                ++overlap;
            }
            if (map[(int)Math.min((double)(map.length - 1), Math.max(0.0, newSpot.getCenter((int)this.index).x))][(int)Math.min(Math.max(0.0, newSpot.getCenter((int)this.index).y), (double)(map[0].length - 1))] != null) {
                ++overlap;
            }
            if (overlap == 0) {
                int r2 = ((CircleCandidate)goodCandidates.get((int)i)).r;
                int xx = -r2;
                while (xx <= r2) {
                    int yy = -r2;
                    while (yy <= r2) {
                        map[(int)Math.min((double)((double)(map.length - 1)), (double)Math.max((double)0.0, (double)(newSpot.getCOM((int)this.index).x + (double)xx)))][(int)Math.min((double)Math.max((double)0.0, (double)(newSpot.getCOM((int)this.index).y + (double)yy)), (double)((double)(map[0].length - 1)))] = newSpot;
                        ++yy;
                    }
                    ++xx;
                }
                list.add(newSpot);
            }
            ++i;
        }
        return list;
    }

    private void populateCellRegions() {
        this.regions = new CellRegion[this.current.getWidth() / this.region_size][this.current.getHeight() / this.region_size];
        for (Cell c : this.cells) {
            if (!c.exists(this.index)) continue;
            DoublePoint center = c.getCenter(this.index);
            int x = (int)(center.x / (double)this.region_size);
            int y = (int)(center.y / (double)this.region_size);
            try {
                if (this.regions[x][y] == null) {
                    this.regions[x][y] = new CellRegion();
                }
                this.regions[x][y].addCell(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void queryStartMechanicalDeathTimes() {
        this.startingTime = Dialogs.getInt("Please enter the start time in frames:", 0, 10000, 1, 150);
        this.minFateTime = Dialogs.getInt("Minimum cell fate time in frames (to avoid counting mechanical death. Start time will  be subtracted to get actual frame):", 0, 10000, 1, 1440);
    }

    private void optimizeCellsToTracks() {
        this.running = true;
        HashMap<Cell, HashSet<Cell>> nearbys = new HashMap<Cell, HashSet<Cell>>();
        double avgTime = 0.0;
        long timer = 0L;
        int cores = Runtime.getRuntime().availableProcessors() - 1;
        int t = Math.max(this.index, 1);
        while (t < this.pngs.size()) {
            long time;
            if (this.escape_flag) {
                this.escape_flag = false;
                break;
            }
            timer = time = System.currentTimeMillis();
            this.setCurrent(t);
            nearbys.clear();
            ArrayList<Cell> currentCells = new ArrayList<Cell>();
            for (Cell c : this.cells) {
                if (c.getWaypointPosition(t) == null) continue;
                currentCells.add((int)(Math.random() * (double)currentCells.size()), c);
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + " Setting current cells took " + (System.currentTimeMillis() - timer) + " ms current Cells: " + currentCells.size());
                timer = System.currentTimeMillis();
            }
            LinkedList<LinkedList<Cell>> cellGroups = Static.splitList(currentCells, cores);
            LinkedList<Preparer> preparers = new LinkedList<Preparer>();
            for (LinkedList linkedList : cellGroups) {
                preparers.add(new Preparer(linkedList, t));
            }
            for (Preparer preparer : preparers) {
                try {
                    preparer.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + "Preparing cells took " + (System.currentTimeMillis() - timer) + " ms current Cells: " + currentCells.size());
                timer = System.currentTimeMillis();
            }
            this.populateCellRegions();
            for (Cell cell : currentCells) {
                if (cell.getPoints(t) != null) {
                    nearbys.put(cell, this.getNearby(cell, t));
                    continue;
                }
                currentCells.remove(cell);
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + " Assigning nearby cells took  " + (System.currentTimeMillis() - timer) + " ms");
                timer = System.currentTimeMillis();
            }
            boolean bl = true;
            if (this.animateBlobs) {
                boolean bl2;
                while (bl2) {
                    bl2 = false;
                    Collections.shuffle(currentCells);
                    for (Cell c : currentCells) {
                        int result;
                        Waypoint wp = c.getWaypointAt(t);
                        double d = Math.pow(wp.x1 - wp.x2, 2.0) + Math.pow(wp.y1 - wp.y2, 2.0) * (double)(wp.end - wp.start) / 10.0;
                        if (wp == null || (result = c.iterate(gradient, (Collection<Cell>)nearbys.get(c), t, wp.getPoint(t), 1.0 / (1.0 + d))) != 1) continue;
                        bl2 = true;
                    }
                    this.paint();
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                LinkedList<Iterator> iterators = new LinkedList<Iterator>();
                for (LinkedList linkedList : cellGroups) {
                    iterators.add(new Iterator(linkedList, t, nearbys));
                }
                for (Iterator iterator : iterators) {
                    try {
                        iterator.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + "amoeba physics took " + (System.currentTimeMillis() - timer) + " ms");
            }
            for (Cell c : currentCells) {
                c.finalize(this.current, t, 1.0f);
            }
            double seconds = (double)(System.currentTimeMillis() - time) / 1000.0;
            avgTime = (avgTime * (double)(t - 1) + seconds) / (double)t;
            double minutes_left = (double)(this.pngs.size() - t) * avgTime / 60.0;
            this.info(String.format("Finished frame: %d cells %d. Took %3.2f s, Avg %3.2f s, ETA in %3.2f m", t, currentCells.size(), seconds, avgTime, minutes_left));
            ++t;
        }
        this.running = false;
    }

    public Tracker() {
        this.initializeCirclePoints();
        this.initialize();
    }

    private HashSet<Cell> getNearby(Cell cell, int time) {
        if (this.regions == null) {
            this.populateCellRegions();
        }
        HashSet<Cell> nearby = new HashSet<Cell>();
        DoublePoint center = cell.getCenter(time);
        int x = (int)(center.x / (double)this.region_size);
        int y = (int)(center.y / (double)this.region_size);
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                try {
                    nearby.addAll(this.regions[x + i][y + j].getCells());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return nearby;
    }

    private void initializeCirclePoints() {
        this.circlePoints.clear();
        int rr = 0;
        while (rr < this.getMaxRadius()) {
            this.circlePoints.add(new LinkedList());
            ++rr;
        }
        int i = -this.getMaxRadius();
        while (i <= this.getMaxRadius()) {
            int j = -this.getMaxRadius();
            while (j <= this.getMaxRadius()) {
                int r = (int)Math.round(Math.sqrt(i * i + j * j));
                if (r <= this.getMaxRadius() && r > 0) {
                    this.circlePoints.get(r - 1).add(new ShortPoint(i, j));
                }
                ++j;
            }
            ++i;
        }
    }

    public int getMaxRadius() {
        if (this.cellRadius != null) {
            return (Integer)this.cellRadius.getValue() * 2;
        }
        return 14;
    }

    public void addCell(Cell c) {
        this.cells.add(c);
        this.idmap.put(c.id, c);
    }

    public Cell getCellById(int cellid) {
        return this.idmap.get(cellid);
    }

    private BufferedImage getImage(int index) {
        if (this.dir != null) {
            try {
                return Static.getGrayscale(ImageIO.read(this.pngs.get(index % this.pngs.size())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private IIOImage getIIOImage(int index) {
        if (this.dir != null) {
            try {
                ImageReader imgRdr = ImageIO.getImageReadersByFormatName("png").next();
                ImageInputStream imgInStrm = ImageIO.createImageInputStream(this.pngs.get(index));
                imgRdr.setInput(imgInStrm);
                IIOImage iioImg = new IIOImage(imgRdr.read(0), null, imgRdr.getImageMetadata(0));
                return iioImg;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void saveImages(final File dir, final int startIndex) {
        Thread t = new Thread(){

            @Override
            public void run() {
                int i = startIndex;
                while (i < Tracker.this.pngs.size()) {
                    if (Tracker.this.escape_flag) {
                        Tracker.this.escape_flag = false;
                        Tracker.this.info("Stopped saving images!");
                        break;
                    }
                    BufferedImage img = Tracker.this.getImage(i);
                    BufferedImage ioimg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                    Static.paintOnGraphics((Graphics2D)ioimg.getGraphics(), img, false, true, true, true, false, false, null, 1.0, 0, 0, Tracker.this.cells, i, null);
                    try {
                        File output = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + Tracker.this.pngs.get(i).getName() + "_processed_" + String.format("%4d.jpg", i));
                        ImageIO.write((RenderedImage)ioimg, "jpg", output);
                        Tracker.this.info("Saved image: " + output.getName());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                Tracker.this.info("Saved all images!");
            }
        };
        t.start();
    }

    private void info(String string) {
        this.disp.addMessage(string);
        this.paint();
    }

    private void initialize() {
        JTabbedPane menu = new JTabbedPane();
        JPanel filePanel = new JPanel();
        menu.addTab("File", filePanel);
        JButton loadImagesBtn = new JButton("Load Images");
        loadImagesBtn.setToolTipText("Load directory of PNG images containing cells to be tracked.");
        loadImagesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setApproveButtonText("Load");
                fc.setCurrentDirectory(new File("."));
                fc.setFileSelectionMode(1);
                fc.setMultiSelectionEnabled(false);
                boolean loading = true;
                while (loading) {
                    int val = fc.showOpenDialog(Tracker.this.self);
                    if (val != 0 || !fc.getSelectedFile().isDirectory()) continue;
                    Tracker.this.setDir(fc.getSelectedFile());
                    Tracker.this.setCurrent(0);
                    loading = false;
                }
                if (Tracker.this.disp != null && Tracker.this.current != null) {
                    Tracker.this.disp.setPreferredSize(new Dimension(Tracker.this.current.getWidth(), Tracker.this.current.getHeight()));
                }
                Tracker.this.disp.paintImmediately(0, 0, Tracker.this.current.getWidth(), Tracker.this.current.getHeight());
                Tracker.this.disp.requestFocus();
            }
        });
        JButton saveImagesBtn = new JButton("Save Images");
        saveImagesBtn.setToolTipText("Save images with overlayed tracked cell tracks starting with current image to folder (JPEG).");
        saveImagesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File folder = Dialogs.getSaveDir("Save Images to Folder");
                if (folder != null) {
                    Tracker.this.saveImages(folder, Tracker.this.index);
                }
            }
        });
        JButton saveRescaledBtn = new JButton("Save Rescaled");
        saveRescaledBtn.setToolTipText("Save original images with intensity values rescaled to min/max for all loaded images to the specified folder.");
        saveRescaledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File folder = Dialogs.getSaveDir("Save Rescaled Images to Folder");
                if (folder != null) {
                    Tracker.this.rescaleAndSave(folder, Dialogs.getInt("Minimum:", 0, Static.getMaxValue(Tracker.this.current), 100, 0), Dialogs.getInt("Maximum:", 0, Static.getMaxValue(Tracker.this.current), 100, Static.getMaxValue(Tracker.this.current)));
                }
            }
        });
        JButton loadCellsBtn = new JButton("Load Cells");
        loadCellsBtn.setToolTipText("Load cell tracks from file.");
        loadCellsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File where = Dialogs.getOpenFile("dat", "Load cell data from file.");
                if (where != null) {
                    Tracker.this.loadEverything(where);
                }
            }
        });
        JButton saveCellsBtn = new JButton("Save Cells");
        saveCellsBtn.setToolTipText("Save cell tracks to file.");
        saveCellsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File where = Dialogs.getSaveFile("dat", "Save cell data to file.");
                if (where != null) {
                    Tracker.this.saveEverything(where);
                }
            }
        });
        JButton saveStatsBtn = new JButton("Save Statistics");
        saveStatsBtn.setToolTipText("Save all cell statistics to file (well tracked non-placeholder non-leaving cell statistics are saved to a csv file.");
        saveStatsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File where = Dialogs.getSaveFile("csv", "Save cell statistics to file.");
                if (where != null) {
                    Tracker.this.queryStartMechanicalDeathTimes();
                    Tracker.this.setCurrent(3);
                    Tracker.this.saveDistributions(where.getAbsolutePath());
                    Tracker.this.setCurrent(0);
                }
            }
        });
        JButton saveTrajectoriesBtn = new JButton("Save Trajectories");
        saveTrajectoriesBtn.setToolTipText("Save all cell score, area, volume, and modeled volume statistics as a function of frame.");
        saveTrajectoriesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File where = Dialogs.getSaveFile("", "Save cell trajectories to file (one file per generation)");
                if (where != null) {
                    Tracker.this.saveToCSV(where.getAbsolutePath());
                }
            }
        });
        JButton saveTreeBtn = new JButton("Save Cell Tree");
        saveTreeBtn.setToolTipText("Saves a family tree lifespan representation of the well-modeled cells in png format.");
        saveTreeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = Dialogs.getSaveFile("png", "Save family tree");
                if (f != null) {
                    int delta = Dialogs.getInt("Maximum width of branches (represents volume)?", 1, 100, 5, 1);
                    Tracker.this.queryStartMechanicalDeathTimes();
                    Tracker.this.saveFamilyTree(f.getAbsolutePath(), delta);
                }
            }
        });
        filePanel.setPreferredSize(new Dimension(200, 800));
        filePanel.add(loadImagesBtn);
        filePanel.add(saveImagesBtn);
        filePanel.add(saveRescaledBtn);
        filePanel.add(loadCellsBtn);
        filePanel.add(saveCellsBtn);
        filePanel.add(saveStatsBtn);
        filePanel.add(saveTrajectoriesBtn);
        filePanel.add(saveTreeBtn);
        if (this.cdisp == null) {
            this.cdisp = new CellDisplay(this);
        }
        this.cdisp.setPreferredSize(new Dimension(250, 150));
        if (this.disp == null) {
            this.disp = new Display(this);
        }
        this.disp.addMessage("Welcome to FAST (Force Algorithm Semi-Automated Tracker) 2013! Get ready to track some cells!");
        KeyListener kl = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Tracker.this.ctrl_down = arg0.isControlDown();
                Tracker.this.shift_down = arg0.isShiftDown();
                Tracker.this.currentKeyPressed = arg0;
                Tracker.this.pressed = true;
                if (!Tracker.this.running && Tracker.this.donePressAction) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            long lastTime = 0L;
                            while ((this).Tracker.this.pressed && System.currentTimeMillis() - lastTime > 100L && (this).Tracker.this.donePressAction) {
                                (this).Tracker.this.donePressAction = false;
                                lastTime = System.currentTimeMillis();
                                if ((this).Tracker.this.currentKeyPressed.getKeyCode() == 68) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.ctrl_down) {
                                        (this).Tracker.this.pick.addWaypoint((this).Tracker.this.index, (this).Tracker.this.mX, (this).Tracker.this.mY);
                                    }
                                    if ((this).Tracker.this.shift_down) {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index + 100);
                                    } else {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index + 1);
                                    }
                                    Tracker.this.paint();
                                }
                                if ((this).Tracker.this.currentKeyPressed.getKeyCode() == 69) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.ctrl_down) {
                                        (this).Tracker.this.pick.addWaypoint((this).Tracker.this.index, (this).Tracker.this.mX, (this).Tracker.this.mY);
                                    }
                                    if ((this).Tracker.this.shift_down) {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index + 20);
                                    } else {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index + 5);
                                    }
                                    Tracker.this.paint();
                                }
                                if ((this).Tracker.this.currentKeyPressed.getKeyCode() == 33) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.ctrl_down) {
                                        (this).Tracker.this.pick.addWaypoint((this).Tracker.this.index, (this).Tracker.this.mX, (this).Tracker.this.mY);
                                    }
                                    Tracker.this.setCurrentNoGradient((this).Tracker.this.index + 25);
                                    Tracker.this.paint();
                                }
                                if ((this).Tracker.this.currentKeyPressed.getKeyCode() == 65) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.ctrl_down) {
                                        (this).Tracker.this.pick.addWaypoint((this).Tracker.this.index, (this).Tracker.this.mX, (this).Tracker.this.mY);
                                    }
                                    if ((this).Tracker.this.shift_down) {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index - 100);
                                    } else {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index - 1);
                                    }
                                    Tracker.this.paint();
                                }
                                if ((this).Tracker.this.currentKeyPressed.getKeyCode() == 81) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.ctrl_down) {
                                        (this).Tracker.this.pick.addWaypoint((this).Tracker.this.index, (this).Tracker.this.mX, (this).Tracker.this.mY);
                                    }
                                    if ((this).Tracker.this.shift_down) {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index - 20);
                                    } else {
                                        Tracker.this.setCurrentNoGradient((this).Tracker.this.index - 5);
                                    }
                                    Tracker.this.paint();
                                }
                                if ((this).Tracker.this.currentKeyPressed.getKeyCode() == 34) {
                                    Tracker.this.setCursor(3);
                                    Tracker.this.setCurrentNoGradient((this).Tracker.this.index - 25);
                                    Tracker.this.paint();
                                    Tracker.this.setCursor(0);
                                }
                                (this).Tracker.this.donePressAction = true;
                            }
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void keyReleased(final KeyEvent arg0) {
                if (arg0.getKeyCode() == 27 || Tracker.this.finished_task) {
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            int targetID;
                            int earliest_waypoint;
                            (this).Tracker.this.finished_task = false;
                            if (arg0.getKeyCode() == 112) {
                                Tracker.this.setCursor(3);
                                File open = Dialogs.getOpenFile("dat", "load all cells from file");
                                if (open != null) {
                                    Tracker.this.loadEverything(open);
                                }
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 113) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.applyMinMax = !(this).Tracker.this.applyMinMax;
                                Tracker.this.info("Gamma correction is " + (this).Tracker.this.applyMinMax);
                                Tracker.this.setCurrent((this).Tracker.this.index);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 114) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.sobel = !(this).Tracker.this.sobel;
                                System.err.println("Sobel is now " + (this).Tracker.this.sobel);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 115) {
                                (this).Tracker.this.disp.toggleImage();
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 116) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveEverything(Dialogs.getSaveFile("dat", "Save all cells to file"));
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 117) {
                                Tracker.this.setCursor(3);
                                String saveFile = Dialogs.getSaveFile("csv", "Save all cell values to file").getAbsolutePath();
                                Tracker.this.saveToCSV(saveFile);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 118) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveDistributions(Dialogs.getSaveFile("csv", "Save all population statistics to file").getAbsolutePath());
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 119) {
                                Tracker.this.setCursor(3);
                                File dir = Dialogs.getSaveDir("Save images to directory");
                                if (dir != null) {
                                    Tracker.this.saveImages(dir, (this).Tracker.this.index);
                                }
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 120) {
                                (this).Tracker.this.animateBlobs = !(this).Tracker.this.animateBlobs;
                                Tracker.this.info("Animate Blobs sets to " + (this).Tracker.this.animateBlobs);
                            }
                            if (arg0.getKeyCode() == 121) {
                                Tracker.this.setCursor(3);
                                File f = Dialogs.getSaveFile("png", "Save family tree");
                                if (f != null) {
                                    int delta = Dialogs.getInt("Maximum width of branches (represents volume)?", 1, 100, 5, 1);
                                    Tracker.this.saveFamilyTree(f.getAbsolutePath(), delta);
                                }
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 122) {
                                (this).Tracker.this.color_by_score = !(this).Tracker.this.color_by_score;
                                Tracker.this.info("Set color by score to: " + (this).Tracker.this.color_by_score);
                            }
                            if (arg0.getKeyCode() == 82 && (this).Tracker.this.shift_down && (this).Tracker.this.ctrl_down) {
                                Tracker.this.queryStartMechanicalDeathTimes();
                                Tracker.this.setCursor(3);
                                File folder = Dialogs.getSaveDir("Process and save analysis to folder: ");
                                Tracker.this.optimizeCellsToTracks();
                                Tracker.this.saveEverything(new File(String.valueOf(folder.getAbsolutePath()) + File.separator + folder.getName() + "_cells.dat"));
                                Tracker.this.saveToCSV(String.valueOf(folder.getAbsolutePath()) + File.separator + folder.getName() + "_results.csv");
                                Tracker.this.saveDistributions(String.valueOf(folder.getAbsolutePath()) + File.separator + folder.getName() + "_stats.csv");
                                Tracker.this.saveImages(folder, 0);
                                Tracker.this.saveFamilyTree(String.valueOf(folder.getAbsolutePath()) + File.separator + folder.getName() + "_tree.png", 1);
                                Tracker.this.saveFamilyTree(String.valueOf(folder.getAbsolutePath()) + File.separator + folder.getName() + "_tree2.png", 10);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 84) {
                                (this).Tracker.this.disp.showAllTraces = !(this).Tracker.this.disp.showAllTraces;
                                Tracker.this.paint();
                            }
                            if ((this).Tracker.this.pick != null && arg0.getKeyCode() == 70 && (this).Tracker.this.ctrl_down) {
                                (this).Tracker.this.pick.gen = (this).Tracker.this.pick.gen == -1 ? 0 : -1;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 71) {
                                (this).Tracker.this.disp.showTags = !(this).Tracker.this.disp.showTags;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 74) {
                                (this).Tracker.this.disp.centerx += 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 76) {
                                (this).Tracker.this.disp.centerx -= 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 73) {
                                (this).Tracker.this.disp.centery -= 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 75) {
                                (this).Tracker.this.disp.centery += 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 85) {
                                (this).Tracker.this.disp.zoom *= 1.25;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.zoom *= 0.75;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 127 && (this).Tracker.this.pick != null) {
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.info(String.valueOf((this).Tracker.this.pick.toString()) + " deleted!");
                                    (this).Tracker.this.cells.remove((this).Tracker.this.pick);
                                    Tracker.this.updateLists();
                                } else {
                                    int i = 0;
                                    while (i < (this).Tracker.this.pick.waypoints.size()) {
                                        if ((this).Tracker.this.pick.waypoints.get((int)i).end > (this).Tracker.this.index) {
                                            (this).Tracker.this.pick.waypoints.remove(i);
                                            --i;
                                        }
                                        ++i;
                                    }
                                }
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 32) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent(0);
                                Tracker.this.info("Back to frame 0");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 35) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.pngs.size() - 1);
                                Tracker.this.info("To the end");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 27) {
                                (this).Tracker.this.escape_flag = true;
                                Tracker.this.info("Stopping the tracking early...");
                            }
                            if (arg0.getKeyCode() == 78) {
                                Tracker.this.setCursor(3);
                                Cell best = null;
                                earliest_waypoint = 999999;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end >= earliest_waypoint || c.waypoints.get((int)(c.waypoints.size() - 1)).end <= (this).Tracker.this.index || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 66) {
                                Tracker.this.setCursor(3);
                                Cell best = null;
                                earliest_waypoint = 0;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end <= earliest_waypoint || c.waypoints.get((int)(c.waypoints.size() - 1)).end >= (this).Tracker.this.index || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 88 && (this).Tracker.this.ctrl_down && (this).Tracker.this.pick != null) {
                                Tracker.this.info("Cell " + (this).Tracker.this.pick.id + " died at " + (this).Tracker.this.index);
                                (this).Tracker.this.pick.killAt((this).Tracker.this.index);
                                Tracker.this.updateLists();
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 90 && (this).Tracker.this.ctrl_down && (this).Tracker.this.pick != null) {
                                Tracker.this.info("Cell " + (this).Tracker.this.pick.id + " left at " + (this).Tracker.this.index);
                                (this).Tracker.this.pick.leaveAt((this).Tracker.this.index);
                                Tracker.this.updateLists();
                                (this).Tracker.this.pick = null;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 67 && (this).Tracker.this.ctrl_down && (this).Tracker.this.shift_down && (this).Tracker.this.pick != null) {
                                HashSet<Cell> toConvert = new HashSet<Cell>();
                                toConvert.add((this).Tracker.this.pick);
                                while (toConvert.size() > 0) {
                                    HashSet<Cell> newset = new HashSet<Cell>();
                                    for (Cell c : toConvert) {
                                        c.gen = -1;
                                        Tracker.this.info("Cell " + c.id + " was converted to a placeholder.");
                                        if (c.Tdiv <= -1) continue;
                                        for (Cell cc : (this).Tracker.this.cells) {
                                            if (cc.motherId != c.id) continue;
                                            newset.add(cc);
                                        }
                                    }
                                    toConvert = newset;
                                }
                                Tracker.this.updateLists();
                                (this).Tracker.this.pick = null;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 87 && (this).Tracker.this.pick != null) {
                                if ((this).Tracker.this.shift_down) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.pick.waypoints.size() > 0) {
                                        Tracker.this.setCurrent((this).Tracker.this.pick.waypoints.get((int)((this).Tracker.this.pick.waypoints.size() - 1)).end);
                                        Tracker.this.paint();
                                    }
                                } else {
                                    Waypoint current = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index);
                                    if (current != null) {
                                        if ((this).Tracker.this.index < current.end) {
                                            Tracker.this.setCurrent(current.end);
                                        } else {
                                            Waypoint next = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index + 1);
                                            if (next != null) {
                                                Tracker.this.setCurrent(next.end);
                                            }
                                        }
                                        Tracker.this.paint();
                                    }
                                }
                            }
                            if (arg0.getKeyCode() == 70 && (this).Tracker.this.shift_down) {
                                Tracker.this.setCursor(3);
                                int t = 0;
                                while (t < (this).Tracker.this.pngs.size()) {
                                    BufferedImage img = Tracker.this.getImage(t);
                                    for (Cell c : (this).Tracker.this.cells) {
                                        if (!c.exists(t)) continue;
                                        c.finalize(img, t, (float)c.getWaypointPosition(t).squaredDistance(c.getCenter(t)));
                                    }
                                    Tracker.this.info("Finalized all cells for time  " + t);
                                    ++t;
                                }
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 83) {
                                Waypoint current;
                                if ((this).Tracker.this.shift_down) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.pick.waypoints.size() > 0) {
                                        Tracker.this.setCurrent((this).Tracker.this.pick.waypoints.get((int)0).start);
                                        Tracker.this.paint();
                                    }
                                } else if ((this).Tracker.this.pick != null && (current = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index)) != null) {
                                    if ((this).Tracker.this.index > current.start) {
                                        Tracker.this.setCurrent(current.start);
                                    } else {
                                        Waypoint next = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index - 1);
                                        if (next != null) {
                                            Tracker.this.setCurrent(next.start);
                                        }
                                    }
                                    Tracker.this.paint();
                                }
                            }
                            if (arg0.getKeyCode() == 82 && (this).Tracker.this.shift_down && !(this).Tracker.this.ctrl_down) {
                                Tracker.this.setCursor(3);
                                Tracker.this.optimizeCellsToTracks();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 70 && !(this).Tracker.this.shift_down && !(this).Tracker.this.ctrl_down && (this).Tracker.this.idmap.get(targetID = Dialogs.getInt("Select cell by id:", 0, 99999, 1, 0)) != null) {
                                (this).Tracker.this.pick = (this).Tracker.this.idmap.get(targetID);
                                if ((this).Tracker.this.pick != null) {
                                    Cell cell = (this).Tracker.this.pick;
                                    synchronized (cell) {
                                        DoublePoint com = (this).Tracker.this.pick.getCenter((this).Tracker.this.index);
                                        if (com != null) {
                                            double area = (this).Tracker.this.pick.getArea((this).Tracker.this.index);
                                            double v = 4.1887902047863905 * Math.pow(Math.sqrt(area / Math.PI) * 1.02, 3.0);
                                            Tracker.this.info(String.format("Cell: %d, at (%d,%d) area: (%d) volume (%d) um^3 ", (this).Tracker.this.pick.id, (int)com.x, (int)com.y, (int)area, (int)v));
                                        }
                                        Tracker.this.updateLists();
                                    }
                                }
                            }
                            if (arg0.getKeyCode() == 82 && !(this).Tracker.this.shift_down && !(this).Tracker.this.ctrl_down) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.pick != null) {
                                    Tracker.this.info("Extending track for current cell " + (this).Tracker.this.pick.toString());
                                    Tracker.this.predictTrack((this).Tracker.this.pick);
                                }
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 80 && (this).Tracker.this.shift_down) {
                                Tracker.this.setCursor(3);
                                Tracker.this.predictAllTracks(false);
                                Tracker.this.setCursor(0);
                            }
                            (this).Tracker.this.finished_task = true;
                            (this).Tracker.this.pressed = false;
                            (this).Tracker.this.ctrl_down = false;
                            (this).Tracker.this.shift_down = false;
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        };
        this.disp.addKeyListener(kl);
        this.disp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent arg0) {
                Tracker.this.disp.requestFocus();
                int clickx = (int)Math.round((double)(arg0.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                int clicky = (int)Math.round((double)(arg0.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                if (arg0.getButton() == 3 && arg0.getClickCount() == 1 && Tracker.this.ctrl_down) {
                    Tracker.this.cx = clickx;
                    Tracker.this.cy = clicky;
                }
                System.err.println("Clicked: " + Tracker.this.cx + "," + Tracker.this.cy);
                if (arg0.getButton() == 1) {
                    if (Tracker.this.pick != null) {
                        if (!Tracker.this.ctrl_down && !Tracker.this.shift_down) {
                            Tracker.this.pick.addWaypoint(Tracker.this.index, clickx, clicky);
                            Tracker.this.paint();
                        } else if (Tracker.this.shift_down && !Tracker.this.ctrl_down) {
                            Cell best = null;
                            double best_distance = 9999999.0;
                            for (Cell c : Tracker.this.cells) {
                                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                                if (position == null || !(position.squaredDistance(clickx, clicky) < best_distance)) continue;
                                best = c;
                                best_distance = position.squaredDistance(clickx, clicky);
                            }
                            if (best != null && best_distance < 25.0) {
                                Tracker.this.pick.takeOver(best, Tracker.this.index);
                                Tracker.this.updateLists();
                                Tracker.this.paint();
                            }
                        } else if (!Tracker.this.shift_down && Tracker.this.ctrl_down) {
                            Cell best = null;
                            double best_distance = 9999999.0;
                            for (Cell c : Tracker.this.cells) {
                                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                                if (position == null || !(position.squaredDistance(clickx, clicky) < best_distance)) continue;
                                best = c;
                                best_distance = position.squaredDistance(clickx, clicky);
                            }
                            if (best != null && best_distance < 25.0) {
                                boolean found = false;
                                int w = 0;
                                while (w < best.waypoints.size()) {
                                    if (found || best.waypoints.get(w).contains(Tracker.this.index)) {
                                        found = true;
                                        Tracker.this.pick.addWaypoint(best.waypoints.get((int)w).end, best.waypoints.get((int)w).x2 - 2, best.waypoints.get((int)w).y2 - 2);
                                    }
                                    ++w;
                                }
                                Tracker.this.updateLists();
                                Tracker.this.paint();
                            }
                        } else if (Tracker.this.ctrl_down && Tracker.this.shift_down) {
                            if (Tracker.this.daughter1 == null) {
                                Tracker.this.daughter1 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                            } else {
                                Tracker.this.daughter2 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                                Tracker.this.addCell(Tracker.this.daughter1);
                                Tracker.this.addCell(Tracker.this.daughter2);
                                Tracker.this.pick.Tdiv = Tracker.this.index;
                                Tracker.this.pick = Tracker.this.daughter1;
                                Tracker.this.daughter2 = null;
                                Tracker.this.daughter1 = null;
                                Tracker.this.updateLists();
                                Tracker.this.paint();
                            }
                        }
                    }
                } else if (arg0.getButton() == 3) {
                    if (arg0.getClickCount() == 1 && !Tracker.this.ctrl_down) {
                        Tracker.this.pick = null;
                        for (Cell c : Tracker.this.cells) {
                            if (!c.insideSimple(clickx, clicky, Tracker.this.index)) continue;
                            Tracker.this.pick = c;
                            Tracker.this.cdisp.paintImmediately(0, 0, Tracker.this.cdisp.getWidth(), Tracker.this.cdisp.getHeight());
                            break;
                        }
                        if (Tracker.this.pick != null) {
                            Cell c;
                            c = Tracker.this.pick;
                            synchronized (c) {
                                DoublePoint com = Tracker.this.pick.getCenter(Tracker.this.index);
                                if (com != null) {
                                    double area = Tracker.this.pick.getArea(Tracker.this.index);
                                    double v = 4.1887902047863905 * Math.pow(Math.sqrt(area / Math.PI), 3.0);
                                    Tracker.this.info(String.format("Cell: %d, at (%d,%d) area: (%d) volume (%d) ", Tracker.this.pick.id, (int)com.x, (int)com.y, (int)area, (int)v));
                                }
                                Tracker.this.updateLists();
                            }
                        } else {
                            Cell best = null;
                            double best_distance = 9999999.0;
                            for (Cell c : Tracker.this.cells) {
                                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                                if (position == null || !(position.squaredDistance(clickx, clicky) < best_distance)) continue;
                                best = c;
                                best_distance = position.squaredDistance(clickx, clicky);
                            }
                            if (best != null && best_distance < 25.0) {
                                Tracker.this.pick = best;
                                Tracker.this.info("Selected " + best.id);
                                Tracker.this.paint();
                            }
                        }
                        Tracker.this.paint();
                    } else if (arg0.getClickCount() == 2) {
                        if (Tracker.this.debug) {
                            System.err.println("Adding new cell");
                        }
                        boolean[][][] clusteredSpots = Tracker.this.getClusteredHotspots(clickx, 10.0, clicky, 10.0, 2, 12);
                        Cell newcell = new Cell(Tracker.this.self, gradient, clusteredSpots, Tracker.this.index, Tracker.this.getNextId(), (short)clickx, (short)clicky);
                        if (Tracker.this.shift_down) {
                            newcell.gen = -1;
                        }
                        Tracker.this.addCell(newcell);
                        Tracker.this.pick = newcell;
                        Tracker.this.pick.finalize(Tracker.this.current, Tracker.this.index, 1.0f);
                        Tracker.this.setTitle("Created new cell for tracking: " + Tracker.this.pick.id);
                        Tracker.this.updateLists();
                        Tracker.this.disp.updateUI();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                Tracker.this.cy = -1;
                Tracker.this.cx = -1;
            }
        });
        this.disp.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Tracker.this.cx != -1) {
                    int clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                    int clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                    Tracker.this.disp.centerx = (int)((double)Tracker.this.disp.centerx + (double)(Tracker.this.cx - clickx) * Tracker.this.disp.zoom);
                    Tracker.this.disp.centery = (int)((double)Tracker.this.disp.centery + (double)(Tracker.this.cy - clicky) * Tracker.this.disp.zoom);
                    clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                    clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                    Tracker.this.cx = clickx;
                    Tracker.this.cy = clicky;
                    Tracker.this.paint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                int clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                Tracker.this.mX = clickx;
                Tracker.this.mY = clicky;
            }
        });
        this.disp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                try {
                    Tracker.this.disp.zoom = e.getWheelRotation() > 0 ? (Tracker.this.disp.zoom *= 1.5) : (Tracker.this.disp.zoom /= 1.5);
                    Tracker.this.disp.zoom = Math.max(0.05, Math.min(20.0, Tracker.this.disp.zoom));
                    Tracker.this.disp.setPreferredSize(new Dimension((int)((double)Tracker.this.current.getWidth() * Tracker.this.disp.zoom), (int)((double)Tracker.this.current.getHeight() * Tracker.this.disp.zoom)));
                    Tracker.this.self.setPreferredSize(new Dimension(Tracker.this.self.getWidth(), Tracker.this.self.getHeight()));
                    Tracker.this.self.pack();
                    Tracker.this.paint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.disp, "Center");
        JPanel right = new JPanel(new FlowLayout());
        this.tabber = new JTabbedPane(1, 0);
        Font fon = new Font("Calibri", 0, 12);
        this.pCool = new JSpinner(new SpinnerNumberModel(40, 1, 250, 1));
        this.pCool.setToolTipText("Optimization cooldown, higher = longer optimization");
        this.pEdge = new JSpinner(new SpinnerNumberModel(1000, 0, 1000000, 100));
        this.pEdge.setToolTipText("Strength of edge attraction, higher number = weaker strength 1/(1+sum(strength)*x)");
        this.pEdgeThreshold = new JSpinner(new SpinnerNumberModel(10000, 1, 1000000, 100));
        this.pEdgeThreshold.setToolTipText("Default Edge Strength. Higher means cells will tend to grow more near image edges");
        this.pKappa = new JSpinner(new SpinnerNumberModel(0.02, 0.0, 1.0, 0.01));
        this.pKappa.setToolTipText("Image edge effect adjustment, higher values will make cells grow more near edges of image to account for fuzziness");
        this.pGamma = new JSpinner(new SpinnerNumberModel(0.08, 0.0, 1.0, 0.01));
        this.pGamma.setToolTipText("Velocity adjustment. Higher numbers make faster cells larger to account for cell stretching during movement");
        this.pFactor = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.01));
        this.pFactor.setToolTipText("Intrinsic growth propensity. Higher numbers reflect inherently larger cells");
        this.pExpectedRadius = new JSpinner(new SpinnerNumberModel(0.025, 0.0, 1.0, 0.005));
        this.pExpectedRadius.setToolTipText("Determines how big the cell will be given its previous average size, larger numbers mean bigger cells");
        this.pTooSmall = new JSpinner(new SpinnerNumberModel(0.9, 0.0, 1.0, 0.01));
        this.pTooSmall.setToolTipText("If the cell is smaller than its average size * this value, then it will grow to correct this. \nBasically the speed with which a cell can shrink from frame to frame");
        this.pTooLarge = new JSpinner(new SpinnerNumberModel(1.1, 0.0, 10.0, 0.01));
        this.pTooLarge.setToolTipText("If the cell is larger than its average size * this value, then it will shrink to compensate. \nBasically the speed with which a cell can grow from frame to frame");
        this.pSpaceFill = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.01));
        this.pSpaceFill.setToolTipText("Inherent growth to ensure the cell fills out to the edges, higher numbers = bigger cells");
        this.pShape = new JSpinner(new SpinnerNumberModel(0.3, 0.0, 10.0, 0.01));
        this.pShape.setToolTipText("The strength with which the cell tries to keep its circularity and shape. Keep this relatively low to avoid runaway vibration effects");
        this.pNeighborLin = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 10.0, 0.01));
        this.pNeighborLin.setToolTipText("The strength of the linear repulsive force from nearby cells");
        this.pNeighborSq = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));
        this.pNeighborSq.setToolTipText("The strength of the quadratic repulsive force from nearby cells. Close range.");
        this.pWaypoint = new JSpinner(new SpinnerNumberModel(0.05, 0.0, 10.0, 0.01));
        this.pWaypoint.setToolTipText("The strength with which the cell will try to follow the curated path. Keep low enough to account for granularity in paths");
        this.cellRadius = new JSpinner(new SpinnerNumberModel(7, 1, 50, 1));
        this.cellRadius.setToolTipText("The average size of cells. Cells with radii twice as large should still be handled properly. Higher numbers will slow down the computation.");
        this.numberOfPoints = new JSpinner(new SpinnerNumberModel(10, 3, 50, 1));
        this.numberOfPoints.setToolTipText("The number of points used to model a single cell (All new cells will have this many). Higher numbers mean more computation but may help if cells are very irregular or large");
        this.growthThreshold = new JSpinner(new SpinnerNumberModel(350, 0, 100000, 1));
        this.growthThreshold.setToolTipText("The volume (assuming sphere and uM length scales) of growth required to be called a \"grower\" cell. ");
        this.endingSizeThreshold = new JSpinner(new SpinnerNumberModel(800, 0, 100000, 1));
        this.endingSizeThreshold.setToolTipText("Minimum final volume (assuming sphere and uM length scales) required to be called a \"grower\" cell.");
        this.micrometerMultiplier = new JSpinner(new SpinnerNumberModel(1.02, 0.0, 100.0, 0.01));
        this.micrometerMultiplier.setToolTipText("Micrometer conversion factor for one image pixel length. Used to standardize volume measurements in terms of micrometers cubed. Area still in pixels^2");
        JPanel paramPanel = new JPanel(new GridLayout(19, 2));
        paramPanel.setPreferredSize(new Dimension(250, 380));
        paramPanel.add(new JLabel("Cell Size:"));
        paramPanel.add(this.cellRadius);
        paramPanel.add(new JLabel("Number of points:"));
        paramPanel.add(this.numberOfPoints);
        paramPanel.add(new JLabel("1/EdgeStrength:"));
        paramPanel.add(this.pEdge);
        paramPanel.add(new JLabel("User path attraction:"));
        paramPanel.add(this.pWaypoint);
        paramPanel.add(new JLabel("Space Filling Growth:"));
        paramPanel.add(this.pSpaceFill);
        paramPanel.add(new JLabel("Shape Maintenance:"));
        paramPanel.add(this.pShape);
        paramPanel.add(new JLabel("Volume growth threshold:"));
        paramPanel.add(this.growthThreshold);
        paramPanel.add(new JLabel("Ending volume threshold:"));
        paramPanel.add(this.endingSizeThreshold);
        paramPanel.add(new JLabel("Micrometer conversion:"));
        paramPanel.add(this.micrometerMultiplier);
        paramPanel.add(new JLabel("Cooldown:"));
        paramPanel.add(this.pCool);
        paramPanel.add(new JLabel("Edge Threshold::"));
        paramPanel.add(this.pEdgeThreshold);
        paramPanel.add(new JLabel("Image Edge Fuzziness:"));
        paramPanel.add(this.pKappa);
        paramPanel.add(new JLabel("Cell Speed Mod:"));
        paramPanel.add(this.pGamma);
        paramPanel.add(new JLabel("Intrinsic Growth:"));
        paramPanel.add(this.pFactor);
        paramPanel.add(new JLabel("Expected Growth:"));
        paramPanel.add(this.pExpectedRadius);
        paramPanel.add(new JLabel("Too Small Mult:"));
        paramPanel.add(this.pTooSmall);
        paramPanel.add(new JLabel("Too Large Mult:"));
        paramPanel.add(this.pTooLarge);
        paramPanel.add(new JLabel("Lin Neighbor Repulsion:"));
        paramPanel.add(this.pNeighborLin);
        paramPanel.add(new JLabel("Sq Neighbor Repulsion:"));
        paramPanel.add(this.pNeighborSq);
        Component[] componentArray = paramPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setFont(fon);
            ++n2;
        }
        JPanel pPanel = new JPanel();
        pPanel.setPreferredSize(new Dimension(250, 1000));
        pPanel.add(paramPanel);
        menu.addTab("Parameters", pPanel);
        this.dividing.setFont(fon);
        this.dying.setFont(fon);
        this.leaving.setFont(fon);
        this.unprocessed.setFont(fon);
        this.placeholders.setFont(fon);
        MouseListener listListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Cell c;
                JList list = (JList)e.getSource();
                Tracker.this.pick = c = (Cell)list.getSelectedValue();
                if (Tracker.this.pick != null && e.getClickCount() == 2) {
                    if (e.getButton() == 1) {
                        Tracker.this.setCurrent(c.wmin);
                    } else if (e.getButton() == 3) {
                        Tracker.this.setCurrent(c.wmax);
                    }
                }
                Tracker.this.paint();
                Tracker.this.disp.requestFocus();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.dividing.addMouseListener(listListener);
        this.dying.addMouseListener(listListener);
        this.leaving.addMouseListener(listListener);
        this.unprocessed.addMouseListener(listListener);
        this.placeholders.addMouseListener(listListener);
        this.dividing.setFont(fon);
        this.dying.setFont(fon);
        this.leaving.setFont(fon);
        this.unprocessed.setFont(fon);
        this.placeholders.setFont(fon);
        JScrollPane scroll1 = new JScrollPane(this.dividing);
        JScrollPane scroll2 = new JScrollPane(this.dying);
        JScrollPane scroll3 = new JScrollPane(this.leaving);
        JScrollPane scroll4 = new JScrollPane(this.unprocessed);
        JScrollPane scroll5 = new JScrollPane(this.placeholders);
        this.tabber.setFont(fon);
        this.tabber.addTab("Div", scroll1);
        this.tabber.addTab("Die", scroll2);
        this.tabber.addTab("Leave", scroll3);
        this.tabber.addTab("?", scroll4);
        this.tabber.addTab("Placeholders", scroll5);
        right.add(this.cdisp);
        right.add(this.tabber);
        this.cdisp.addKeyListener(kl);
        this.tabber.addKeyListener(kl);
        this.tabber.setPreferredSize(new Dimension(260, 370));
        right.setPreferredSize(new Dimension(270, 750));
        menu.addTab("Track", right);
        menu.setFont(fon);
        cp.add((Component)menu, "East");
        cp.invalidate();
        this.pack();
        this.disp.requestFocus();
        this.disp.requestDefaultFocus();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width, screenSize.height - 20);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("Force Algorithm Semi-automated Tracker V2 by Max Shokhirev (C) 2014. Signaling Systems Laboratory");
        this.setVisible(true);
        this.autosaver.start();
    }

    public void paint() {
        try {
            this.disp.paintImmediately(0, 0, this.disp.getWidth(), this.disp.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cdisp.paintImmediately(0, 0, this.cdisp.getWidth(), this.cdisp.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveEverything(File saveFile) {
        int result = 0;
        if (saveFile.exists()) {
            result = JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite " + saveFile.getName() + "?");
        }
        if (result == 0) {
            try {
                BufferedWriter pw = new BufferedWriter(new FileWriter(saveFile));
                int count = 1;
                for (Cell c : this.cells) {
                    c.saveSelf(pw);
                    this.info("Cell " + count++ + "/" + this.cells.size() + " finished saving.");
                }
                pw.close();
                this.justsaved = true;
                if (this.debug) {
                    System.err.println("Saved everything");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.info("Save Cancelled!");
        }
    }

    private void loadEverything(File openFile) {
        while (!this.justsaved) {
            int result = JOptionPane.showConfirmDialog(this, "Save current cell state to file before loading?");
            if (result != 0) break;
            File saveFile = Dialogs.getSaveFile("dat", "Save all cells to file");
            if (saveFile == null) continue;
            this.saveEverything(saveFile);
        }
        try {
            Scanner s = new Scanner(openFile);
            this.cells.clear();
            this.info("Loading cells from " + openFile.getName());
            while (s.hasNextLine()) {
                Cell c = new Cell(this.self, s);
                this.addCell(c);
                this.id = Math.max(this.id, c.id);
                if (this.cells.size() % 10 != 0) continue;
                this.info("Loaded " + this.cells.size() + " cells.");
            }
            ++this.id;
            this.disp.updateUI();
        }
        catch (Exception e) {
            this.info("Error:" + e.getLocalizedMessage());
        }
        this.info("All cells loaded from " + openFile.getName());
        this.updateLists();
    }

    public final boolean[][][] getClusteredHotspots(double x, double xrad, double y, double yrad, int rmin, int rmax) {
        return this.getClusteredHotspots(11000, 35000, 30.0, 2.0, (int)x, (int)xrad, (int)y, (int)yrad, rmin, rmax);
    }

    public final boolean[][][] getClusteredHotspots(int edge_threshold, int accumulator_threshold, double min_vote, double vote_per_r, int x, int xrad, int y, int yrad, int rmin, int rmax) {
        int[][] gradient = Static.getSobelGradientNear(this.current, Math.max(0, x - xrad * 2), Math.min(this.current.getWidth() - 1, x + xrad * 2), Math.max(0, y - yrad * 2), Math.min(this.current.getHeight() - 1, y + yrad * 2));
        boolean[][][] clustered = new boolean[this.getMaxRadius() + 1][gradient.length][gradient[0].length];
        int[][][] accumulator = new int[this.getMaxRadius() + 1][gradient.length][gradient[0].length];
        LinkedList<ShortPoint> edgePixels = new LinkedList<ShortPoint>();
        int i = x - xrad;
        while (i <= x + xrad) {
            int j = y - yrad;
            while (j <= y + yrad) {
                try {
                    if (gradient[i][j] > edge_threshold) {
                        edgePixels.add(new ShortPoint(i, j));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        int r = Math.max(rmin, 1);
        while (r <= Math.min(rmax, this.getMaxRadius())) {
            LinkedList<ShortPoint> points = this.circlePoints.get(r - 1);
            for (ShortPoint point : edgePixels) {
                for (ShortPoint sp : points) {
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x + 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x - 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y + 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y - 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++r;
        }
        r = Math.max(rmin, 1);
        while (r <= Math.min(rmax, this.getMaxRadius())) {
            int threshold = (int)(min_vote + vote_per_r * Math.PI * (double)r);
            int i2 = x - xrad;
            while (i2 <= x + xrad) {
                int j = y - yrad;
                while (j <= y + yrad) {
                    try {
                        if (accumulator[r - 1][i2][j] > threshold) {
                            LinkedList<ShortPoint> hotspot = Static.floodFillThreshold(accumulator[r - 1], gradient, i2, j, threshold, accumulator_threshold);
                            double centerx = 0.0;
                            double centery = 0.0;
                            for (ShortPoint sp : hotspot) {
                                centerx += (double)sp.x;
                                centery += (double)sp.y;
                                accumulator[r - 1][sp.x][sp.y] = 0;
                            }
                            int xx = (int)Math.round(centerx / (double)hotspot.size());
                            int yy = (int)Math.round(centery / (double)hotspot.size());
                            if (hotspot.size() > r * r) {
                                clustered[r - 1][xx][yy] = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i2;
            }
            ++r;
        }
        return clustered;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    /*
     * WARNING - void declaration
     */
    private void saveToCSV(String filename) {
        void var8_9;
        if (this.debug) {
            System.err.println("Saving cell properties to csv file.");
        }
        HashMap<Cell, Integer> responseMap = new HashMap<Cell, Integer>();
        boolean tick = true;
        int maxGens = -1;
        int count = 0;
        LinkedList<Cell> wellModeled = new LinkedList<Cell>();
        for (Cell c : this.cells) {
            ++count;
            int response = 0;
            boolean tooEarly = false;
            if (c.gen == 0 && c.Tdie > -1 && c.getTrueFateTime(this.startingTime) < this.minFateTime) {
                tooEarly = true;
            }
            if (c.gen <= -1 || c.Tgone != -1 || tooEarly) continue;
            if (c.stats.get(c.Tmin) == null || c.stats.get((Object)Integer.valueOf((int)c.Tmin)).modeledMass == 0.0f) {
                if (c.stats.get(c.Tmin) != null) {
                    c.setModeledMasses2();
                } else if (c.stats.get(c.Tmin) == null) {
                    this.info("A cell has not been tracked... throwing it out!");
                    continue;
                }
            }
            response = c.response4();
            if (!(c.RMSD <= 250.0) || response == -3) continue;
            wellModeled.add(c);
            responseMap.put(c, response);
            if (c.gen <= maxGens) continue;
            maxGens = c.gen;
        }
        ArrayList divisions = new ArrayList();
        boolean bl = false;
        while (var8_9 <= maxGens) {
            divisions.add(new ArrayList());
            ++var8_9;
        }
        for (Cell cell : wellModeled) {
            if (cell.gen <= -1) continue;
            ((ArrayList)divisions.get(cell.gen)).add(cell);
        }
        for (ArrayList arrayList : divisions) {
            Collections.sort(arrayList, new Comparator<Cell>(){

                @Override
                public int compare(Cell o1, Cell o2) {
                    if (o1.id > o2.id) {
                        return 1;
                    }
                    if (o1.id < o2.id) {
                        return -1;
                    }
                    if (o1.id == o2.id) {
                        return 0;
                    }
                    return 0;
                }
            });
        }
        int n = this.pngs.size();
        int g = 0;
        while (g <= maxGens) {
            try {
                PrintWriter pw = new PrintWriter(String.valueOf(filename.substring(0, filename.length() - 4)) + "_" + g + ".csv");
                String header = "Frame#";
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Sc. " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Area " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    if ((Integer)responseMap.get(c) == 1) {
                        header = String.valueOf(header) + ",/Vol " + c.id;
                        continue;
                    }
                    if ((Integer)responseMap.get(c) == 0) {
                        header = String.valueOf(header) + ",^Vol " + c.id;
                        continue;
                    }
                    if ((Integer)responseMap.get(c) != -1) continue;
                    header = String.valueOf(header) + ",-Vol " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    if ((Integer)responseMap.get(c) == 1) {
                        header = String.valueOf(header) + ",/MV " + c.id;
                        continue;
                    }
                    if ((Integer)responseMap.get(c) == 0) {
                        header = String.valueOf(header) + ",^MVl " + c.id;
                        continue;
                    }
                    if ((Integer)responseMap.get(c) != -1) continue;
                    header = String.valueOf(header) + ",-MV " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Comp. " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",X " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Y " + c.id;
                }
                pw.println(header);
                int t = 0;
                while (t < n) {
                    if (this.debug) {
                        System.err.println(String.valueOf(t) + "/" + n);
                    }
                    double[][] data = new double[((ArrayList)divisions.get(g)).size()][7];
                    count = 0;
                    StringBuilder sb = new StringBuilder(t + 1);
                    for (Cell c : (ArrayList)divisions.get(g)) {
                        if (c.getStats(t) != null && t <= c.getTrueFateTime(this.startingTime)) {
                            data[count][0] = c.getStats((int)t).fate_score;
                            data[count][1] = c.getStats((int)t).area;
                            data[count][2] = c.getStats((int)t).mass;
                            data[count][3] = c.getStats((int)t).modeledMass;
                            data[count][4] = c.getStats((int)t).compactness;
                            data[count][5] = c.getStats((int)t).x;
                            data[count][6] = c.getStats((int)t).y;
                        } else {
                            data[count][0] = -1.0;
                            data[count][1] = -1.0;
                            data[count][2] = -1.0;
                            data[count][3] = -1.0;
                            data[count][4] = -1.0;
                            data[count][5] = -1.0;
                            data[count][6] = -1.0;
                        }
                        ++count;
                    }
                    sb.append(t);
                    int i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i2][0] != -1.0) {
                            sb.append(String.format("%3.3f", data[i2][0]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i2;
                    }
                    int i = 0;
                    while (i < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i][1] != -1.0) {
                            sb.append(String.format("%3.3f", data[i][1]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i][2] != -1.0) {
                            sb.append(String.format("%3.3f", data[i][2]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i][3] != -1.0) {
                            sb.append(String.format("%3.3f", data[i][3]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i][4] != -1.0) {
                            sb.append(String.format("%3.3f", data[i][4]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i][5] != -1.0) {
                            sb.append(String.format("%3.3f", data[i][5]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        if (data[i][6] != -1.0) {
                            sb.append(String.format("%3.3f", data[i][6]));
                        } else {
                            sb.append("=NA()");
                        }
                        ++i;
                    }
                    pw.println(sb.toString());
                    this.info("Saved frame " + t + " to " + filename.substring(0, filename.length() - 4) + "_" + g + ".csv");
                    ++t;
                }
                if (this.debug) {
                    System.err.println("Saved division " + g + " containing " + ((ArrayList)divisions.get(g)).size() + " cells and " + n + " frames");
                }
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ++g;
        }
    }

    private void saveDistributions(String filename) {
        int maxTdie = 0;
        int maxTdiv = 0;
        int maxTdecide = 0;
        int maxTgrow = 0;
        int minTdie = 0;
        int minTdiv = 0;
        int minTdecide = 0;
        int minTgrow = 0;
        int gens = 0;
        ArrayList Tdies = new ArrayList();
        ArrayList Tdivs = new ArrayList();
        ArrayList Tgrows = new ArrayList();
        ArrayList Tdecides = new ArrayList();
        ArrayList TdiesRespond = new ArrayList();
        ArrayList TdivsRespond = new ArrayList();
        LinkedList<Cell> wellModeled = new LinkedList<Cell>();
        int count = 0;
        int placeholders = 0;
        int leavers = 0;
        int prematures = 0;
        HashMap<Cell, Boolean> responseMap = new HashMap<Cell, Boolean>();
        for (Cell c : this.cells) {
            ++count;
            int response = -3;
            boolean tooEarly = false;
            if (c.gen == 0 && c.Tdie > -1 && c.getTrueFateTime(this.startingTime) < this.minFateTime) {
                tooEarly = true;
            }
            if (!(c.gen <= -1 || c.Tgone != -1 || tooEarly || c.Tdie <= -1 && c.Tdiv <= -1)) {
                if (c.stats.get(c.Tmin) == null || c.stats.get((Object)Integer.valueOf((int)c.Tmin)).modeledMass == 0.0f) {
                    if (c.stats.get(c.Tmin) != null) {
                        c.setModeledMasses2();
                    } else if (c.stats.get(c.Tmin) == null) {
                        this.info("A cell has not been tracked... throwing it out as an error!");
                        continue;
                    }
                }
                if ((response = c.response4()) == -3 || !(c.RMSD < 250.0)) continue;
                wellModeled.add(c);
                if (response > 0) {
                    responseMap.put(c, true);
                } else {
                    responseMap.put(c, false);
                }
                if (c.getTrueDecideAge(this.startingTime) > -1 && c.getTrueDecideAge(this.startingTime) > maxTdecide) {
                    maxTdecide = c.getTrueDecideAge(this.startingTime);
                }
                if (c.getTrueDivAge(this.startingTime) > -1 && c.getTrueDivAge(this.startingTime) > maxTdiv) {
                    maxTdiv = c.getTrueDivAge(this.startingTime);
                }
                if (c.getTrueDieAge(this.startingTime) > -1 && c.getTrueDieAge(this.startingTime) > maxTdie) {
                    maxTdie = c.getTrueDieAge(this.startingTime);
                }
                if (c.inflection > -1 && c.inflection > maxTgrow) {
                    maxTgrow = c.inflection;
                }
                if (c.gen > gens) {
                    gens = c.gen;
                }
                this.info("Finished getting stats from cell " + count + "/" + this.cells.size() + " RMSD=" + c.RMSD + " response: " + response);
                continue;
            }
            if (c.gen == -1) {
                ++placeholders;
                this.info("Finished getting stats from cell " + count + "/" + this.cells.size() + " The cell was ignored because it was just a placeholder!");
                continue;
            }
            if (c.Tgone > -1) {
                ++leavers;
                this.info("Finished getting stats from cell " + count + "/" + this.cells.size() + " The cell was ignored because it left the field of view!");
                continue;
            }
            ++prematures;
            this.info("Finished getting stats from cell " + count + "/" + this.cells.size() + " The cell was ignored because it died too early!");
        }
        maxTdiv = (maxTdiv / 1000 + 1) * 1000;
        maxTdie = (maxTdie / 1000 + 1) * 1000;
        maxTdecide = (maxTdecide / 1000 + 1) * 1000;
        maxTgrow = (maxTgrow / 1000 + 1) * 1000;
        this.info("There were " + wellModeled.size() + " well-modeled cells , " + leavers + " leaving cells, " + placeholders + " placeholder cells, and " + prematures + " premature cells  out of a total of " + this.cells.size());
        ++gens;
        ArrayList<DoublePoint> divCorrelations = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> dieCorrelations = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> decideCorrelations = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> startMassCorrelations = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> endMassCorrelations = new ArrayList<DoublePoint>();
        ArrayList rstartMasses = new ArrayList();
        ArrayList rendMasses = new ArrayList();
        ArrayList ustartMasses = new ArrayList();
        ArrayList uendMasses = new ArrayList();
        HashMap<Integer, Cell> sisters = new HashMap<Integer, Cell>();
        HashMap<Integer, Cell> penultimates = new HashMap<Integer, Cell>();
        ArrayList<DoublePoint> divCorrelations2 = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> dieCorrelations2 = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> decideCorrelations2 = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> startMassCorrelations2 = new ArrayList<DoublePoint>();
        ArrayList<DoublePoint> endMassCorrelations2 = new ArrayList<DoublePoint>();
        HashMap cousins = new HashMap();
        int massBins = 100;
        FloatList[][] rmasses = new FloatList[gens][massBins];
        FloatList[][] umasses = new FloatList[gens][massBins];
        int i = 0;
        while (i < gens) {
            Tdies.add(new ArrayList());
            Tdivs.add(new ArrayList());
            Tgrows.add(new ArrayList());
            Tdecides.add(new ArrayList());
            TdiesRespond.add(new ArrayList());
            TdivsRespond.add(new ArrayList());
            int j = 0;
            while (j < massBins) {
                rmasses[i][j] = new FloatList();
                ++j;
            }
            j = 0;
            while (j < massBins) {
                umasses[i][j] = new FloatList();
                ++j;
            }
            rstartMasses.add(new ArrayList());
            rendMasses.add(new ArrayList());
            ustartMasses.add(new ArrayList());
            uendMasses.add(new ArrayList());
            ++i;
        }
        int bins = 6;
        int[] fdiv = new int[gens];
        int[] responders = new int[gens];
        int[] nonresponders = new int[gens];
        int[] responders24 = new int[gens];
        int[] nonresponders24 = new int[gens];
        int[] numQuiescentPenultimate = new int[gens];
        double divBinSize = (double)(maxTdiv - minTdiv) / 6.0;
        double dieBinSize = (double)(maxTdie - minTdie) / 6.0;
        double growBinSize = (double)(maxTgrow - minTgrow) / 6.0;
        double pBinSize = (double)(maxTdecide - minTdecide) / 6.0;
        if (divBinSize == 0.0) {
            divBinSize = 1.0;
        }
        if (dieBinSize == 0.0) {
            dieBinSize = 1.0;
        }
        if (pBinSize == 0.0) {
            pBinSize = 1.0;
        }
        if (growBinSize == 0.0) {
            growBinSize = 1.0;
        }
        int[][] prTdie = new int[gens][7];
        int[][] prTdiv = new int[gens][7];
        int[][] prTgrow = new int[gens][7];
        int[][] prTdecide = new int[gens][7];
        int[][] genCells = new int[gens][this.pngs.size()];
        int[] prGrowAndDiv = new int[gens];
        int[] prGrowAndDie = new int[gens];
        int[] prQuiescentAndDiv = new int[gens];
        int[] prQuiescentAndDie = new int[gens];
        int[] prGrowAndDiv24 = new int[gens];
        int[] prGrowAndDie24 = new int[gens];
        int[] prQuiescentAndDiv24 = new int[gens];
        int[] prQuiescentAndDie24 = new int[gens];
        int[] prDifferentOutcomes = new int[gens];
        int[] prDifferentOutcomes2 = new int[gens];
        int[] totalSisters = new int[gens];
        for (Cell c : wellModeled) {
            Cell mother;
            if (c.motherId != -1) {
                if (sisters.get(c.motherId) == null) {
                    sisters.put(c.motherId, c);
                } else {
                    Cell sister = (Cell)sisters.get(c.motherId);
                    int n = c.gen;
                    totalSisters[n] = totalSisters[n] + 1;
                    if (sister.getTrueDivAge(this.startingTime) > -1 && c.getTrueDivAge(this.startingTime) > -1) {
                        divCorrelations.add(new DoublePoint(sister.getTrueDivAge(this.startingTime), c.getTrueDivAge(this.startingTime)));
                        decideCorrelations.add(new DoublePoint(sister.getTrueDecideAge(this.startingTime), c.getTrueDecideAge(this.startingTime)));
                        startMassCorrelations.add(new DoublePoint(sister.getAverageStartingMass(), c.getAverageStartingMass()));
                        endMassCorrelations.add(new DoublePoint(sister.getAverageEndingMass(), c.getAverageEndingMass()));
                    } else if (sister.getTrueDieAge(this.startingTime) > -1 && c.getTrueDieAge(this.startingTime) > -1) {
                        dieCorrelations.add(new DoublePoint(sister.getTrueDieAge(this.startingTime), c.getTrueDieAge(this.startingTime)));
                        startMassCorrelations.add(new DoublePoint(sister.getAverageStartingMass(), c.getAverageStartingMass()));
                        endMassCorrelations.add(new DoublePoint(sister.getAverageEndingMass(), c.getAverageEndingMass()));
                    } else {
                        int n2 = c.gen;
                        prDifferentOutcomes[n2] = prDifferentOutcomes[n2] + 1;
                    }
                }
                Cell mother2 = this.getCellById(c.motherId);
                if (mother2 != null && mother2.motherId > -1) {
                    if (cousins.get(mother2.motherId) == null) {
                        cousins.put(mother2.motherId, new LinkedList());
                    }
                    ((LinkedList)cousins.get(mother2.motherId)).add(c);
                }
            }
            if (((Boolean)responseMap.get(c)).booleanValue()) {
                ((ArrayList)rstartMasses.get(c.gen)).add(c.getAverageStartingMass());
                ((ArrayList)rendMasses.get(c.gen)).add(c.getAverageEndingMass());
            } else {
                ((ArrayList)ustartMasses.get(c.gen)).add(c.getAverageStartingMass());
                ((ArrayList)uendMasses.get(c.gen)).add(c.getAverageEndingMass());
            }
            int i2 = c.Tmin;
            while (i2 <= Math.max(Math.max(c.Tdiv, c.Tgone), c.Tdie)) {
                int[] nArray = genCells[c.gen];
                int n = i2++;
                nArray[n] = nArray[n] + 1;
            }
            boolean died = false;
            boolean divided = false;
            boolean responded = (Boolean)responseMap.get(c);
            if (c.Tdiv > -1) {
                ((ArrayList)Tdivs.get(c.gen)).add(Math.max(0, c.getTrueDivAge(this.startingTime)));
                ((ArrayList)TdivsRespond.get(c.gen)).add(responded);
                divided = true;
            } else {
                if (c.Tdie <= -1) continue;
                ((ArrayList)Tdies.get(c.gen)).add(Math.max(0, c.getTrueDieAge(this.startingTime)));
                ((ArrayList)TdiesRespond.get(c.gen)).add(responded);
                died = true;
            }
            if (divided) {
                int n = c.gen;
                fdiv[n] = fdiv[n] + 1;
            }
            if (responded) {
                ((ArrayList)Tdecides.get(c.gen)).add(Math.max(0, c.getTrueDecideAge(this.startingTime)));
                ((ArrayList)Tgrows.get(c.gen)).add(Math.max(0, c.getTrueDivAge(this.startingTime) - c.inflection));
                int n = c.gen;
                responders[n] = responders[n] + 1;
                if (divided) {
                    int[] nArray = prTdiv[c.gen];
                    int n3 = (int)((double)(c.getTrueDivAge(this.startingTime) - minTdiv) / divBinSize);
                    nArray[n3] = nArray[n3] + 1;
                    int n4 = c.gen;
                    prGrowAndDiv[n4] = prGrowAndDiv[n4] + 1;
                    if (c.getTrueDivAge(this.startingTime) <= 1440 || c.getTrueDivAge(this.startingTime) <= this.startingTime + 2880 && c.gen == 0) {
                        int n5 = c.gen;
                        prGrowAndDiv24[n5] = prGrowAndDiv24[n5] + 1;
                        int n6 = c.gen;
                        responders24[n6] = responders24[n6] + 1;
                    }
                }
                if (died) {
                    int[] nArray = prTdie[c.gen];
                    int n7 = (int)((double)(c.getTrueDieAge(this.startingTime) - minTdie) / dieBinSize);
                    nArray[n7] = nArray[n7] + 1;
                    int n8 = c.gen;
                    prGrowAndDie[n8] = prGrowAndDie[n8] + 1;
                    if (c.getTrueDieAge(this.startingTime) <= 1440 || c.getTrueDieAge(this.startingTime) <= this.startingTime + 2880 && c.gen == 0) {
                        int n9 = c.gen;
                        prGrowAndDie24[n9] = prGrowAndDie24[n9] + 1;
                        int n10 = c.gen;
                        responders24[n10] = responders24[n10] + 1;
                    }
                    if (penultimates.get(c.motherId) == null) {
                        penultimates.put(c.motherId, c);
                    } else {
                        mother = this.idmap.get(c.motherId);
                        if (mother != null && responseMap.get(mother) != null && !((Boolean)responseMap.get(mother)).booleanValue()) {
                            int n11 = mother.gen;
                            numQuiescentPenultimate[n11] = numQuiescentPenultimate[n11] + 1;
                        }
                        penultimates.remove(c.motherId);
                    }
                }
                int[] nArray = prTdecide[c.gen];
                int n12 = (int)((double)(c.getTrueDecideAge(this.startingTime) - minTdecide) / pBinSize);
                nArray[n12] = nArray[n12] + 1;
            } else {
                int n = c.gen;
                nonresponders[n] = nonresponders[n] + 1;
                if (divided) {
                    int[] nArray = prTdiv[c.gen];
                    int n13 = (int)((double)(c.getTrueDivAge(this.startingTime) - minTdiv) / divBinSize);
                    nArray[n13] = nArray[n13] + 1;
                    int n14 = c.gen;
                    prQuiescentAndDiv[n14] = prQuiescentAndDiv[n14] + 1;
                    if (c.getTrueDivAge(this.startingTime) <= 1440 || c.getTrueDivAge(this.startingTime) <= this.startingTime + 2880 && c.gen == 0) {
                        int n15 = c.gen;
                        prQuiescentAndDiv24[n15] = prQuiescentAndDiv24[n15] + 1;
                        int n16 = c.gen;
                        nonresponders24[n16] = nonresponders24[n16] + 1;
                    }
                }
                if (died) {
                    int[] nArray = prTdie[c.gen];
                    int n17 = (int)((double)(c.getTrueDieAge(this.startingTime) - minTdie) / dieBinSize);
                    nArray[n17] = nArray[n17] + 1;
                    int n18 = c.gen;
                    prQuiescentAndDie[n18] = prQuiescentAndDie[n18] + 1;
                    if (c.getTrueDieAge(this.startingTime) <= 1440 || c.getTrueDieAge(this.startingTime) <= this.startingTime + 2880 && c.gen == 0) {
                        int n19 = c.gen;
                        prQuiescentAndDie24[n19] = prQuiescentAndDie24[n19] + 1;
                        int n20 = c.gen;
                        nonresponders24[n20] = nonresponders24[n20] + 1;
                    }
                    if (penultimates.get(c.motherId) == null) {
                        penultimates.put(c.motherId, c);
                    } else {
                        mother = this.idmap.get(c.motherId);
                        if (mother != null && responseMap.get(mother) != null && !((Boolean)responseMap.get(mother)).booleanValue()) {
                            int n21 = mother.gen;
                            numQuiescentPenultimate[n21] = numQuiescentPenultimate[n21] + 1;
                        }
                        penultimates.remove(c.motherId);
                    }
                }
            }
            float[] fractionMasses = c.getRawVolumeOverLifetime(massBins, this.startingTime);
            int i3 = 0;
            while (i3 < fractionMasses.length) {
                if (responded) {
                    rmasses[c.gen][i3].list.add(Float.valueOf(fractionMasses[i3]));
                } else {
                    umasses[c.gen][i3].list.add(Float.valueOf(fractionMasses[i3]));
                }
                ++i3;
            }
        }
        int[] validCousinSets = new int[gens];
        for (LinkedList clist : cousins.values()) {
            if (clist.size() <= 1) continue;
            LinkedList<Cell> left = new LinkedList<Cell>();
            LinkedList<Cell> right = new LinkedList<Cell>();
            left.add((Cell)clist.removeFirst());
            while (clist.size() > 0) {
                Cell first = (Cell)clist.removeFirst();
                if (first.motherId == ((Cell)left.getFirst()).motherId) {
                    left.add(first);
                    continue;
                }
                right.add(first);
            }
            if (right.size() <= 0) continue;
            boolean different = false;
            for (Cell c : left) {
                for (Cell d : right) {
                    startMassCorrelations2.add(new DoublePoint(c.getAverageStartingMass(), d.getAverageStartingMass()));
                    endMassCorrelations2.add(new DoublePoint(c.getAverageEndingMass(), d.getAverageEndingMass()));
                    if (c.getTrueDivAge(this.startingTime) > -1 && d.getTrueDivAge(this.startingTime) > -1) {
                        divCorrelations2.add(new DoublePoint(c.getTrueDivAge(this.startingTime), d.getTrueDivAge(this.startingTime)));
                        decideCorrelations2.add(new DoublePoint(c.getTrueDecideAge(this.startingTime), d.getTrueDecideAge(this.startingTime)));
                        continue;
                    }
                    if (c.getTrueDieAge(this.startingTime) > -1 && d.getTrueDieAge(this.startingTime) > -1) {
                        dieCorrelations2.add(new DoublePoint(c.getTrueDieAge(this.startingTime), d.getTrueDieAge(this.startingTime)));
                        continue;
                    }
                    different = true;
                }
            }
            if (different) {
                int n = ((Cell)right.getFirst()).gen;
                prDifferentOutcomes2[n] = prDifferentOutcomes2[n] + 1;
            }
            int n = ((Cell)right.getFirst()).gen;
            validCousinSets[n] = validCousinSets[n] + 1;
        }
        java.util.Iterator<Object> died = penultimates.keySet().iterator();
        while (died.hasNext()) {
            int id = (Integer)died.next();
            Cell mother = this.getCellById(id);
            if (mother == null || responseMap.get(mother) == null || ((Boolean)responseMap.get(mother)).booleanValue()) continue;
            int n = mother.gen;
            numQuiescentPenultimate[n] = numQuiescentPenultimate[n] + 1;
        }
        double[][] logDiv = new double[gens][2];
        double[][] logDie = new double[gens][2];
        double[][] logDecide = new double[gens][2];
        try {
            BufferedWriter pw = new BufferedWriter(new FileWriter(filename));
            String header = "Frame";
            int i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TdivGen" + i4;
                ++i4;
            }
            header = String.valueOf(header) + ",Gen,E[Tdiv],sd[Tdiv],Frame";
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TdieGen" + i4;
                ++i4;
            }
            header = String.valueOf(header) + ",Gen,E[Tdie],sd[Tdie],Frame";
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TdecideGen" + i4;
                ++i4;
            }
            header = String.valueOf(header) + ",Gen,E[Tdecide],sd[Tdecide],Frame";
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",#CellsGen" + i4;
                ++i4;
            }
            header = String.valueOf(header) + ",TotalCells,%Lifetime";
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",VRGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",VUGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",VSDRGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",VSDUGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",V#RGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",V#UGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TdivsGen" + i4 + ",cdf(Tdiv" + i4 + "),Responded?";
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TgrowGen" + i4 + ",cdf(Tgrow" + i4 + ")";
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TdiesGen" + i4 + ",cdf(Tdie" + i4 + "),Responded?";
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",TdecidesGen" + i4 + ",cdf(Tdecide" + i4 + ")";
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",StartMRGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",EndMRGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",StartMUGen" + i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < gens) {
                header = String.valueOf(header) + ",EndMUGen" + i4;
                ++i4;
            }
            header = String.valueOf(header) + ",Gen,Fs,PrGrow,PrNoGrow,PrGrowerDivided,PrGrowerDied,PrNongrowerDivided,PrNongrowerDied,PrNonPenultimateNonGrowDied,PrDifferentSisOutcomes,PrDifferentCousinOutcomes,PrGrowerDivided24,PrGrowerDied24,PrNongrowerDivided24,PrNongrowerDied24,NumResponder,NumQuiescent,NumPenultimateQuiescent,NumResponder24,NumQuiescent24,TDivSis1,TDivSis2,TDieSis1,TDieSis2,TDecSis1,TDecSis2,SMassSis1,SMassSis2,EMassSis1,EmassSis2,TDivCuz1,TDivCuz2,TDieCuz1,TDieCuz2,TDecCuz1,TDecCuz2,SMassCuz1,SMassCuz2,EMassCuz1,EmassCuz2";
            pw.write(header);
            pw.newLine();
            pw.flush();
            int rows = Math.max(6, Math.max(this.pngs.size(), wellModeled.size()));
            int g = 0;
            while (g < gens) {
                Collections.sort((List)Tdivs.get(g));
                Collections.sort((List)Tdies.get(g));
                Collections.sort((List)Tdecides.get(g));
                DoublePoint dpdiv = Static.fitLognormalEandSD((List)Tdivs.get(g));
                logDiv[g][0] = dpdiv.x;
                logDiv[g][1] = dpdiv.y;
                DoublePoint dpdie = Static.fitLognormalEandSD((List)Tdies.get(g));
                logDie[g][0] = dpdie.x;
                logDie[g][1] = dpdie.y;
                DoublePoint dpdecide = Static.fitLognormalEandSD((List)Tdecides.get(g));
                logDecide[g][0] = dpdecide.x;
                logDecide[g][1] = dpdecide.y;
                ++g;
            }
            int r = 0;
            while (r < rows) {
                String str = "";
                if (r <= 6) {
                    str = String.valueOf(str) + ((double)minTdiv + (double)r * divBinSize);
                }
                int i5 = 0;
                while (i5 < gens) {
                    try {
                        str = String.valueOf(str) + "," + (double)prTdiv[i5][r] / (double)((ArrayList)Tdivs.get(i5)).size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i5;
                }
                str = r < gens ? String.valueOf(str) + "," + r + "," + logDiv[r][0] + "," + logDiv[r][1] : String.valueOf(str) + ",,,";
                str = r > 6 ? String.valueOf(str) + "," : String.valueOf(str) + "," + ((double)minTdie + (double)r * dieBinSize);
                i5 = 0;
                while (i5 < gens) {
                    try {
                        str = String.valueOf(str) + "," + (double)prTdie[i5][r] / (double)((ArrayList)Tdies.get(i5)).size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i5;
                }
                str = r < gens ? String.valueOf(str) + "," + r + "," + logDie[r][0] + "," + logDie[r][1] : String.valueOf(str) + ",,,";
                str = r > 6 ? String.valueOf(str) + "," : String.valueOf(str) + "," + ((double)minTdecide + (double)r * pBinSize);
                i5 = 0;
                while (i5 < gens) {
                    try {
                        str = String.valueOf(str) + "," + (double)prTdecide[i5][r] / (double)responders[i5];
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i5;
                }
                str = r < gens ? String.valueOf(str) + "," + r + "," + logDecide[r][0] + "," + logDecide[r][1] : String.valueOf(str) + ",,,";
                str = String.valueOf(str) + "," + r;
                int totalCells = 0;
                int i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + genCells[i6][r];
                        totalCells += genCells[i6][r];
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                str = String.valueOf(str) + "," + totalCells;
                str = r > massBins ? String.valueOf(str) + "," : String.valueOf(str) + "," + r;
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + rmasses[i6][r].getAvg();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + umasses[i6][r].getAvg();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + rmasses[i6][r].getSD();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + umasses[i6][r].getSD();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + rmasses[i6][r].list.size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + umasses[i6][r].list.size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)Tdivs.get(i6)).get(r) + "," + (double)(r + 1) / (double)((ArrayList)Tdivs.get(i6)).size() + "," + ((ArrayList)TdivsRespond.get(i6)).get(r);
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",,,";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)Tgrows.get(i6)).get(r) + "," + (double)(r + 1) / (double)((ArrayList)Tgrows.get(i6)).size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",,";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)Tdies.get(i6)).get(r) + "," + (double)(r + 1) / (double)((ArrayList)Tdies.get(i6)).size() + "," + ((ArrayList)TdiesRespond.get(i6)).get(r);
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",,,";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)Tdecides.get(i6)).get(r) + "," + (double)(r + 1) / (double)((ArrayList)Tdecides.get(i6)).size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",,";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)rstartMasses.get(i6)).get(r);
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)rendMasses.get(i6)).get(r);
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)ustartMasses.get(i6)).get(r);
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + ((ArrayList)uendMasses.get(i6)).get(r);
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                str = r <= gens ? String.valueOf(str) + "," + r : String.valueOf(str) + ",";
                try {
                    str = String.valueOf(str) + "," + (double)fdiv[r] / (double)(responders[r] + nonresponders[r]);
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)responders[r] / (double)(responders[r] + nonresponders[r]);
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)nonresponders[r] / (double)(responders[r] + nonresponders[r]);
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prGrowAndDiv[r] / (double)responders[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prGrowAndDie[r] / (double)responders[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prQuiescentAndDiv[r] / (double)nonresponders[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prQuiescentAndDie[r] / (double)nonresponders[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)(prQuiescentAndDiv[r] - numQuiescentPenultimate[r]) / (double)(nonresponders[r] - numQuiescentPenultimate[r]);
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prDifferentOutcomes[r] / (double)totalSisters[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prDifferentOutcomes2[r] / (double)validCousinSets[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prGrowAndDiv24[r] / (double)responders24[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prGrowAndDie24[r] / (double)responders24[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prQuiescentAndDiv24[r] / (double)nonresponders24[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + (double)prQuiescentAndDie24[r] / (double)nonresponders24[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + responders[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + nonresponders[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + numQuiescentPenultimate[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + responders24[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + nonresponders24[r];
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)divCorrelations.get((int)r)).x + "," + ((DoublePoint)divCorrelations.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)dieCorrelations.get((int)r)).x + "," + ((DoublePoint)dieCorrelations.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)decideCorrelations.get((int)r)).x + "," + ((DoublePoint)decideCorrelations.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)startMassCorrelations.get((int)r)).x + "," + ((DoublePoint)startMassCorrelations.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)endMassCorrelations.get((int)r)).x + "," + ((DoublePoint)endMassCorrelations.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)divCorrelations2.get((int)r)).x + "," + ((DoublePoint)divCorrelations2.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)dieCorrelations2.get((int)r)).x + "," + ((DoublePoint)dieCorrelations2.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)decideCorrelations2.get((int)r)).x + "," + ((DoublePoint)decideCorrelations2.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)startMassCorrelations2.get((int)r)).x + "," + ((DoublePoint)startMassCorrelations2.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                try {
                    str = String.valueOf(str) + "," + ((DoublePoint)endMassCorrelations2.get((int)r)).x + "," + ((DoublePoint)endMassCorrelations2.get((int)r)).y;
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",,";
                }
                pw.write(str);
                pw.newLine();
                ++r;
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.info("Saved statistics to file " + filename);
    }

    private void saveFamilyTree(String filename, int delta) {
        LinkedList<Object> roots = new LinkedList<Object>();
        int count = 0;
        boolean placeholders = false;
        boolean leavers = false;
        boolean prematures = false;
        HashMap<Integer, Object> nodes = new HashMap<Integer, Object>();
        HashMap responseMap = new HashMap();
        LinkedList<Cell> candidates = new LinkedList<Cell>();
        for (Cell c : this.cells) {
            ++count;
            int response = 0;
            boolean tooEarly = false;
            if (c.gen == 0 && c.Tdie > -1 && c.getTrueFateTime(this.startingTime) < this.minFateTime) {
                tooEarly = true;
            }
            if (c.gen == 0 && c.Tdie > -1 && c.getTrueFateTime(this.startingTime) < this.minFateTime) {
                tooEarly = true;
            }
            if (c.gen <= -1 || c.Tgone != -1 || tooEarly) continue;
            if (c.stats.get(c.Tmin()) == null || c.stats.get((Object)Integer.valueOf((int)c.Tmin())).modeledMass == 0.0f) {
                if (c.stats.get(c.Tmin()) != null) {
                    c.setModeledMasses2();
                } else if (c.stats.get(c.Tmin()) == null) {
                    this.info("A cell has not been tracked... please \"R\"un the tracking from the beginning!");
                    return;
                }
            }
            response = c.response4();
            if (!(c.RMSD <= 250.0) || response == -3) continue;
            candidates.add(c);
            this.info("Candidate cell found " + c.toString());
        }
        HashSet<Cell> connected = new HashSet<Cell>();
        HashSet<Cell> leaves = new HashSet<Cell>();
        int csize = 0;
        while (candidates.size() > 0 && csize != candidates.size()) {
            csize = candidates.size();
            int i = 0;
            while (i < csize) {
                Cell c = (Cell)candidates.removeFirst();
                int n = c.motherId;
                if (n > -1) {
                    if (nodes.get(n) != null) {
                        BinaryTreeNode newnode = ((BinaryTreeNode)nodes.get(n)).addLeaf(c);
                        nodes.put(c.id, newnode);
                        connected.add(c);
                        leaves.remove(((BinaryTreeNode)nodes.get((Object)Integer.valueOf((int)n))).cell);
                        leaves.add(c);
                    } else {
                        candidates.addLast(c);
                    }
                } else {
                    BinaryTreeNode newNode = new BinaryTreeNode(null, c);
                    nodes.put(c.id, newNode);
                    roots.add(newNode);
                    connected.add(c);
                    leaves.add(c);
                }
                ++i;
            }
        }
        LinkedList<Integer> depths = new LinkedList<Integer>();
        LinkedList<BinaryTreeNode> orderedRoots = new LinkedList<BinaryTreeNode>();
        for (BinaryTreeNode binaryTreeNode : roots) {
            int maxDepth = binaryTreeNode.getMaxDepth();
            int counter = 0;
            for (Integer d : depths) {
                if (d > maxDepth) break;
                ++counter;
            }
            orderedRoots.add(counter, binaryTreeNode);
            depths.add(counter, maxDepth);
        }
        roots = orderedRoots;
        int n = (this.pngs.size() + this.startingTime) / 10;
        int h = delta + leaves.size() * delta * 2;
        BufferedImage img = new BufferedImage(n, h, 2);
        Value offset = new Value(delta);
        int rootCount = 0;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(String.valueOf(filename.substring(0, filename.length() - 4)) + "_lineage.csv");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        for (BinaryTreeNode binaryTreeNode : roots) {
            if (rootCount == roots.size() - 1) {
                System.err.println("Last root!");
            }
            ++rootCount;
            this.drawTreeNode(binaryTreeNode, offset, delta, (Graphics2D)img.getGraphics(), img.getWidth(), img.getHeight());
            pw.println("ID,Branch,Tmin,Tmax,Fate");
            this.outputTreeNode(pw, binaryTreeNode, "");
            offset.val += delta;
        }
        pw.close();
        try {
            ImageIO.write((RenderedImage)img, "png", new File(filename));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.info("Saved the family tree to file " + filename);
    }

    private void outputTreeNode(PrintWriter pw, BinaryTreeNode node, String prefix) {
        if (prefix.length() > 0) {
            pw.println(String.valueOf(node.cell.id) + "," + prefix + "_" + node.cell.id + "," + node.cell.Tmin + "," + node.cell.getTrueFateTime(this.startingTime) + "," + node.cell.getFate());
        } else {
            pw.println(String.valueOf(node.cell.id) + "," + node.cell.id + "," + node.cell.Tmin + "," + node.cell.getTrueFateTime(this.startingTime) + "," + node.cell.getFate());
        }
        if (node.left != null) {
            this.outputTreeNode(pw, node.left, "" + node.cell.id);
        }
        if (node.right != null) {
            this.outputTreeNode(pw, node.right, "" + node.cell.id);
        }
    }

    private void drawTreeNode(BinaryTreeNode node, Value offset, int delta, Graphics2D g2, int width, int height) {
        Cell c = node.cell;
        if (node.left == null && node.right == null) {
            int tmax;
            int max;
            g2.setColor(colors[c.gen % colors.length]);
            int xmin = width * (c.Tmin() + this.startingTime) / (this.pngs.size() + this.startingTime);
            if (c.gen == 0) {
                xmin = 0;
            }
            if ((max = c.getTrueFateTime(this.startingTime)) == -1) {
                max = this.startingTime + c.Tmax();
            }
            int xmax = width * max / (this.pngs.size() + this.startingTime);
            int tmin = c.Tmin() + this.startingTime;
            if (c.gen == 0) {
                tmin = 0;
            }
            if ((tmax = c.getTrueFateTime(this.startingTime)) == -1) {
                tmax = c.Tmax() + this.startingTime;
            }
            int x = xmin;
            while (x < xmax) {
                int t = (int)((double)tmin + (double)(tmax - tmin) * ((double)(x - xmin) / (double)(xmax - xmin)));
                int size = 0;
                try {
                    size = (int)(0.5 * (double)delta * (double)c.getStats((int)t).mass / 1500.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                g2.drawLine(x, offset.val - size, x, offset.val + size);
                ++x;
            }
            node.y = offset.val;
        } else {
            int tmax;
            int max;
            if (node.left != null) {
                this.drawTreeNode(node.left, offset, delta, g2, width, height);
            }
            offset.val += delta;
            if (node.right != null && node.right.left == null && node.right.right == null) {
                offset.val += delta;
            }
            if (node.right != null) {
                this.drawTreeNode(node.right, offset, delta, g2, width, height);
            }
            g2.setColor(colors[c.gen % colors.length]);
            int xmin = width * (c.Tmin() + this.startingTime) / (this.pngs.size() + this.startingTime);
            if (c.gen == 0) {
                xmin = 0;
            }
            if ((max = c.getTrueFateTime(this.startingTime)) == -1) {
                max = this.startingTime + c.Tmax();
            }
            int xmax = width * max / (this.pngs.size() + this.startingTime);
            int tmin = c.Tmin() + this.startingTime;
            if (c.gen == 0) {
                tmin = 0;
            }
            if ((tmax = c.getTrueFateTime(this.startingTime)) == -1) {
                tmax = c.Tmax() + this.startingTime;
            }
            int ypos = 0;
            ypos = node.left != null && node.right == null ? node.left.y + delta : (node.left == null && node.right != null ? node.right.y + delta : (node.left.y + node.right.y) / 2 / delta * delta);
            int x = xmin;
            while (x < xmax) {
                int t = (int)((double)tmin + (double)(tmax - tmin) * ((double)(x - xmin) / (double)(xmax - xmin)));
                int size = 0;
                try {
                    size = (int)(0.5 * (double)delta * (double)c.getStats((int)t).mass / 1500.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                g2.drawLine(x, (int)((double)ypos - (double)size / 2.0), x, (int)((double)ypos + (double)size / 2.0));
                ++x;
            }
            g2.setColor(Color.BLACK);
            if (node.left != null) {
                g2.drawLine(xmax, node.left.y, xmax, ypos);
            }
            if (node.right != null) {
                g2.drawLine(xmax, node.right.y, xmax, ypos);
            }
            node.y = ypos;
        }
    }

    public static void main(String[] args) {
        new Tracker();
    }

    private class FComparator
    implements Comparator<File> {
        private FComparator() {
        }

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    private class FloatList {
        LinkedList<Float> list = new LinkedList();

        private FloatList() {
        }

        public float getAvg() {
            float avg = 0.0f;
            java.util.Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                avg += f;
            }
            return avg / (float)this.list.size();
        }

        public float getSD() {
            float avg = this.getAvg();
            float sd = 0.0f;
            java.util.Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                sd = (float)((double)sd + Math.pow(f - avg, 2.0));
            }
            return (float)Math.sqrt(sd / (float)this.list.size());
        }
    }

    private class Iterator
    extends Thread {
        LinkedList<Cell> group;
        int t = 0;
        HashMap<Cell, HashSet<Cell>> nearbys;
        boolean changing = true;

        public Iterator(LinkedList<Cell> group, int t, HashMap<Cell, HashSet<Cell>> nearbys) {
            this.group = group;
            this.t = t;
            this.nearbys = nearbys;
            this.start();
        }

        @Override
        public void run() {
            while (this.changing) {
                this.changing = false;
                for (Cell c : this.group) {
                    int result;
                    Waypoint wp = c.getWaypointAt(this.t);
                    double d = Math.pow(wp.x1 - wp.x2, 2.0) + Math.pow(wp.y1 - wp.y2, 2.0) * (double)(wp.end - wp.start) / 10.0;
                    if (wp == null || (result = c.iterate(gradient, (Collection<Cell>)this.nearbys.get(c), this.t, wp.getPoint(this.t), 1.0 / (1.0 + d))) != 1) continue;
                    this.changing = true;
                }
            }
            for (Cell c : this.group) {
                c.volumize(gradient, this.t);
            }
        }
    }

    private class Predictor
    extends Thread {
        LinkedList<Cell> group;
        LinkedList<Cell> remaining = new LinkedList();
        int t = 0;
        boolean tracking = true;
        int count = 0;

        public Predictor(LinkedList<Cell> group, int t) {
            this.group = group;
            this.t = t;
            this.start();
        }

        @Override
        public void run() {
            this.tracking = false;
            for (Cell c : this.group) {
                boolean tracked = Tracker.this.predictTrackOneStep(c);
                this.tracking |= tracked;
                if (!tracked) continue;
                ++this.count;
                this.remaining.add(c);
            }
        }
    }

    private class Preparer
    extends Thread {
        LinkedList<Cell> group;
        int t = 0;

        public Preparer(LinkedList<Cell> group, int t) {
            this.group = group;
            this.t = t;
            this.start();
        }

        @Override
        public void run() {
            for (Cell c : this.group) {
                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                c.prepareOptimizationNoSpots(this.t, gradient, position);
            }
        }
    }

    private class Value {
        int val = 0;

        public Value(int val) {
            this.val = val;
        }
    }
}

