/*
 * Decompiled with CFR 0.152.
 */
package semiTracker352213;

import java.io.Serializable;

public class ShortPoint
implements Cloneable,
Serializable {
    public static transient ShortPoint ORIGIN = new ShortPoint(0, 0);
    public short x;
    public short y;

    public ShortPoint(short x, short y) {
        this.x = x;
        this.y = y;
    }

    public ShortPoint(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
    }

    public ShortPoint clone() {
        return new ShortPoint(this.x, this.y);
    }

    public boolean equals(ShortPoint o) {
        return this.x == o.x && this.y == o.y;
    }

    public int dotProduct(short x2, short y2) {
        return this.x * x2 + this.y * y2;
    }

    public int dotProduct(ShortPoint dp) {
        short x2 = dp.x;
        short y2 = dp.y;
        return this.x * x2 + this.y * y2;
    }

    public ShortPoint plus(ShortPoint dp) {
        return new ShortPoint((short)(this.x + dp.x), (short)(this.y + dp.y));
    }

    public ShortPoint minus(ShortPoint dp) {
        return new ShortPoint((short)(this.x - dp.x), (short)(this.y - dp.y));
    }

    public double distanceTo(ShortPoint dp) {
        return Math.sqrt((dp.x - this.x) * (dp.x - this.x) + (dp.y - this.y) * (dp.y - this.y));
    }

    public double squaredDistance(ShortPoint dp) {
        if (dp == null) {
            return 0.0;
        }
        return (dp.x - this.x) * (dp.x - this.x) + (dp.y - this.y) * (dp.y - this.y);
    }

    public double distanceTo(double x2, double y2) {
        return Math.sqrt((x2 - (double)this.x) * (x2 - (double)this.x) + (y2 - (double)this.y) * (y2 - (double)this.y));
    }

    public double squaredDistance(double x2, double y2) {
        return (x2 - (double)this.x) * (x2 - (double)this.x) + (y2 - (double)this.y) * (y2 - (double)this.y);
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public String toString() {
        return String.format("(%d,%d)", this.x, this.y);
    }
}

