/*
 * Decompiled with CFR 0.152.
 */
package semiTracker352213;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import semiTracker352213.Cell;
import semiTracker352213.CellRegion;
import semiTracker352213.Dialogs;
import semiTracker352213.Display;
import semiTracker352213.DoublePoint;
import semiTracker352213.ShortPoint;
import semiTracker352213.Static;
import semiTracker352213.Waypoint;

public class Tracker
extends JFrame {
    Tracker self = this;
    BufferedImage current = null;
    BufferedImage sobelImage = null;
    int index = 0;
    static int[][] gradient;
    static final int hotspotRadius = 15;
    static final int maximum_radius = 15;
    ArrayList<LinkedList<ShortPoint>> circlePoints = new ArrayList();
    int[][] current_averages;
    int[][][] img_averages;
    int total_images_processed = 0;
    boolean escape_flag = false;
    private int id = 0;
    boolean applyMinMax = false;
    boolean color_by_score = false;
    boolean sobel = false;
    boolean continuousStitch = false;
    boolean endStitch = false;
    private static int minTrackLength;
    boolean finished_task = true;
    boolean debug = true;
    boolean timing = true;
    File dir;
    ArrayList<File> pngs = new ArrayList();
    Display disp;
    Cell pick;
    Cell daughter1 = null;
    Cell daughter2 = null;
    boolean ctrl_down = false;
    boolean shift_down = false;
    int cx = -1;
    int cy = -1;
    HashSet<Cell> cells = new HashSet();
    HashMap<Integer, Cell> idmap = new HashMap();
    private final int region_size = 15;
    CellRegion[][] regions;
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH-mm-ss";

    static {
        minTrackLength = 0;
    }

    public int getNextId() {
        int result = this.id++;
        return result;
    }

    private void setDir(File d) {
        this.dir = d;
        this.pngs.clear();
        if (this.debug) {
            System.err.println("Found " + d.list().length + " files in dir " + d.getName());
        }
        String[] strs = d.list();
        File[] files = d.listFiles();
        int i = 0;
        while (i < files.length) {
            if (strs[i].endsWith("png") || strs[i].endsWith("PNG")) {
                this.pngs.add(files[i]);
            }
            ++i;
        }
        Collections.sort(this.pngs, new FComparator());
        this.img_averages = new int[this.pngs.size()][1][1];
    }

    private void setCurrent(int new_index) {
        if ((new_index %= this.pngs.size()) < 0) {
            new_index = this.pngs.size() + new_index;
        }
        this.current = null;
        this.current = this.applyMinMax ? Static.adjustMinMax(this.getImage(new_index)) : this.getImage(new_index);
        this.sobelImage = Static.getSobelTransformed(this.current);
        this.regions = null;
        gradient = Static.getIntArray(this.sobelImage);
        this.total_images_processed = Math.max(this.total_images_processed, new_index + 1);
        this.index = new_index;
        this.setTitle("TrackerMax by Shokhirev M., Signaling Systems Laboratory (C) 2013. Current Frame = " + this.index + "/" + this.pngs.size());
    }

    private void populateCellRegions() {
        this.regions = new CellRegion[this.current.getWidth() / 15][this.current.getHeight() / 15];
        for (Cell c : this.cells) {
            if (!c.exists(this.index)) continue;
            DoublePoint center = c.getCenter(this.index);
            int x = (int)(center.x / 15.0);
            int y = (int)(center.y / 15.0);
            try {
                if (this.regions[x][y] == null) {
                    this.regions[x][y] = new CellRegion();
                }
                this.regions[x][y].addCell(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void optimizeCellsToTracks() {
        HashMap<Cell, HashSet<Cell>> nearbys = new HashMap<Cell, HashSet<Cell>>();
        double avgTime = 0.0;
        long timer = 0L;
        int cores = Runtime.getRuntime().availableProcessors() - 1;
        int t = 1;
        while (t < this.pngs.size()) {
            boolean bl;
            long time;
            if (this.escape_flag) {
                this.escape_flag = false;
                break;
            }
            timer = time = System.currentTimeMillis();
            this.setCurrent(t);
            nearbys.clear();
            ArrayList<Cell> currentCells = new ArrayList<Cell>();
            for (Cell c : this.cells) {
                if (c.getWaypointPosition(t) == null) continue;
                currentCells.add((int)(Math.random() * (double)currentCells.size()), c);
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + " Setting current cells took " + (System.currentTimeMillis() - timer) + " ms current Cells: " + currentCells.size());
                timer = System.currentTimeMillis();
            }
            LinkedList<LinkedList<Cell>> cellGroups = Static.splitList(currentCells, cores);
            LinkedList<Preparer> preparers = new LinkedList<Preparer>();
            for (LinkedList linkedList : cellGroups) {
                preparers.add(new Preparer(linkedList, t));
            }
            for (Preparer preparer : preparers) {
                try {
                    preparer.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + "Preparing cells took " + (System.currentTimeMillis() - timer) + " ms current Cells: " + currentCells.size());
                timer = System.currentTimeMillis();
            }
            this.populateCellRegions();
            for (Cell cell : currentCells) {
                if (cell.getPoints(t) != null) {
                    nearbys.put(cell, this.getNearby(cell, t));
                    continue;
                }
                currentCells.remove(cell);
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + " Assigning nearby cells took  " + (System.currentTimeMillis() - timer) + " ms");
                timer = System.currentTimeMillis();
            }
            boolean bl2 = true;
            while (bl) {
                bl = false;
                Collections.shuffle(currentCells);
                for (Cell c : currentCells) {
                    int result;
                    Waypoint wp = c.getWaypointAt(t);
                    double d = Math.sqrt(Math.pow(wp.x1 - wp.x2, 2.0) + Math.pow(wp.y1 - wp.y2, 2.0));
                    if (wp == null || (result = c.iterate(gradient, (Collection)nearbys.get(c), t, wp.getPoint(t), 1.0 / (1.0 + (double)(wp.end - wp.start) * d))) != 1) continue;
                    bl = true;
                }
                boolean drawing = false;
                drawing = true;
                if (!drawing) continue;
                this.paint();
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + "amoeba physics took " + (System.currentTimeMillis() - timer) + " ms");
            }
            for (Cell c : currentCells) {
                c.finalize(this.current, t, 1.0f);
            }
            double seconds = (double)(System.currentTimeMillis() - time) / 1000.0;
            avgTime = (avgTime * (double)(t - 1) + seconds) / (double)t;
            double minutes_left = (double)(this.pngs.size() - t) * avgTime / 60.0;
            this.info(String.format("Finished frame: %d cells %d. Took %3.2f s, Avg %3.2f s, ETA in %3.2f m", t, currentCells.size(), seconds, avgTime, minutes_left));
            ++t;
        }
    }

    public Tracker() {
        this.initializeCirclePoints();
        this.initialize();
    }

    private HashSet<Cell> getNearby(Cell cell, int time) {
        if (this.regions == null) {
            this.populateCellRegions();
        }
        HashSet<Cell> nearby = new HashSet<Cell>();
        DoublePoint center = cell.getCenter(time);
        int x = (int)(center.x / 15.0);
        int y = (int)(center.y / 15.0);
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                try {
                    nearby.addAll(this.regions[x + i][y + j].getCells());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return nearby;
    }

    private void initializeCirclePoints() {
        this.circlePoints.clear();
        int rr = 0;
        while (rr < 15) {
            this.circlePoints.add(new LinkedList());
            ++rr;
        }
        int i = -15;
        while (i <= 15) {
            int j = -15;
            while (j <= 15) {
                int r = (int)Math.round(Math.sqrt(i * i + j * j));
                if (r <= 15 && r > 0) {
                    this.circlePoints.get(r - 1).add(new ShortPoint(i, j));
                }
                ++j;
            }
            ++i;
        }
    }

    public void addCell(Cell c) {
        this.cells.add(c);
        this.idmap.put(c.id, c);
    }

    public Cell getCellById(int cellid) {
        return this.idmap.get(cellid);
    }

    private BufferedImage getImage(int index) {
        if (this.dir != null) {
            try {
                return Static.getGrayscale(ImageIO.read(this.pngs.get(index % this.pngs.size())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void saveImages() {
        File dir = Dialogs.getSaveDir("Save images to dir");
        int i = 0;
        while (i < this.pngs.size()) {
            this.setCurrent(i);
            BufferedImage img = this.getImage(i);
            BufferedImage ioimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Static.paintOnGraphics((Graphics2D)ioimg.getGraphics(), img, false, true, true, true, false, null, 1.0, 0, 0, this.cells, this.index, this.pick);
            try {
                ImageIO.write((RenderedImage)ioimg, "PNG", new File(String.valueOf(dir.getAbsolutePath()) + File.separator + this.pngs.get(i).getName() + "_processed_" + String.format("%4d.png", i)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.info("Saved all images!");
    }

    private void info(String string) {
        this.disp.addMessage(string);
        this.paint();
    }

    private void initialize() {
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("Load");
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        boolean loading = true;
        while (loading) {
            int val = fc.showOpenDialog(this);
            if (val != 0 || !fc.getSelectedFile().isDirectory()) continue;
            this.setDir(fc.getSelectedFile());
            this.setCurrent(0);
            loading = false;
        }
        if (this.disp == null) {
            this.disp = new Display(this);
        }
        this.disp.addMessage("Welcome to TrackerMax 2013! Get ready to track some cells!");
        this.disp.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Tracker.this.ctrl_down = arg0.isControlDown();
                Tracker.this.shift_down = arg0.isShiftDown();
            }

            @Override
            public void keyReleased(final KeyEvent arg0) {
                if (arg0.getKeyCode() == 27 || arg0.getKeyCode() == 73 || arg0.getKeyCode() == 84 || arg0.getKeyCode() == 71 || Tracker.this.finished_task) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            Waypoint current;
                            int earliest_waypoint;
                            Cell best;
                            (this).Tracker.this.finished_task = false;
                            if (arg0.getKeyCode() == 68) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 100);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 1);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 69) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 20);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 5);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 33) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 25);
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 65) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 100);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 1);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 81) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 20);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 5);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 34) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 25);
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 114) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.sobel = !(this).Tracker.this.sobel;
                                System.err.println("Sobel is now " + (this).Tracker.this.sobel);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 115) {
                                (this).Tracker.this.disp.toggleImage();
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 84) {
                                (this).Tracker.this.disp.showAllTraces = !(this).Tracker.this.disp.showAllTraces;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 71) {
                                (this).Tracker.this.disp.showTags = !(this).Tracker.this.disp.showTags;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.goodOnly = !(this).Tracker.this.disp.goodOnly;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 74) {
                                (this).Tracker.this.disp.centerx += 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 76) {
                                (this).Tracker.this.disp.centerx -= 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 73) {
                                (this).Tracker.this.disp.centery -= 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 75) {
                                (this).Tracker.this.disp.centery += 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 85) {
                                (this).Tracker.this.disp.zoom *= 1.25;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.zoom *= 0.75;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 32) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent(0);
                                Tracker.this.info("Back to frame 0");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 35) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.pngs.size() - 1);
                                Tracker.this.info("To the end");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 27) {
                                (this).Tracker.this.escape_flag = true;
                                Tracker.this.info("Escape flag is set!");
                            }
                            if (arg0.getKeyCode() == 120) {
                                Tracker.this.saveImages();
                            }
                            if (arg0.getKeyCode() == 112) {
                                Tracker.this.setCursor(3);
                                Tracker.this.loadEverything(Dialogs.getOpenFile("dat", "load all cells from file"));
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 78) {
                                Tracker.this.setCursor(3);
                                best = null;
                                earliest_waypoint = 999999;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end >= earliest_waypoint || c.waypoints.get((int)(c.waypoints.size() - 1)).end <= (this).Tracker.this.index || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 66) {
                                Tracker.this.setCursor(3);
                                best = null;
                                earliest_waypoint = 0;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end <= earliest_waypoint || c.waypoints.get((int)(c.waypoints.size() - 1)).end >= (this).Tracker.this.index || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 88 && (this).Tracker.this.ctrl_down && (this).Tracker.this.pick != null) {
                                Tracker.this.info("Cell " + (this).Tracker.this.pick.id + " died at " + (this).Tracker.this.index);
                                (this).Tracker.this.pick.killAt((this).Tracker.this.index);
                                (this).Tracker.this.pick = null;
                            }
                            if (arg0.getKeyCode() == 87 && (this).Tracker.this.pick != null) {
                                if ((this).Tracker.this.shift_down) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.pick.waypoints.size() > 0) {
                                        Tracker.this.setCurrent((this).Tracker.this.pick.waypoints.get((int)((this).Tracker.this.pick.waypoints.size() - 1)).end);
                                        Tracker.this.paint();
                                    }
                                } else {
                                    current = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index);
                                    if (current != null) {
                                        if ((this).Tracker.this.index < current.end) {
                                            Tracker.this.setCurrent(current.end);
                                        } else {
                                            Waypoint next = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index + 1);
                                            if (next != null) {
                                                Tracker.this.setCurrent(next.end);
                                            }
                                        }
                                        Tracker.this.paint();
                                    }
                                }
                            }
                            if (arg0.getKeyCode() == 83) {
                                if ((this).Tracker.this.shift_down) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.pick.waypoints.size() > 0) {
                                        Tracker.this.setCurrent((this).Tracker.this.pick.waypoints.get((int)0).start);
                                        Tracker.this.paint();
                                    }
                                } else if ((this).Tracker.this.pick != null && (current = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index)) != null) {
                                    if ((this).Tracker.this.index > current.start) {
                                        Tracker.this.setCurrent(current.start);
                                    } else {
                                        Waypoint next = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index - 1);
                                        if (next != null) {
                                            Tracker.this.setCurrent(next.start);
                                        }
                                    }
                                    Tracker.this.paint();
                                }
                            }
                            if (arg0.getKeyCode() == 70) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 113) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.applyMinMax = !(this).Tracker.this.applyMinMax;
                                Tracker.this.info("Gamma correction is " + (this).Tracker.this.applyMinMax);
                                Tracker.this.setCurrent((this).Tracker.this.index);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 115) {
                                (this).Tracker.this.color_by_score = !(this).Tracker.this.color_by_score;
                                Tracker.this.info("Set color by score to: " + (this).Tracker.this.color_by_score);
                            }
                            if (arg0.getKeyCode() == 116) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveEverything(Dialogs.getSaveFile("dat", "Save all cells to file"));
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 117) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveToCSV(Dialogs.getSaveFile("csv", "Save all cell stats to file").getAbsolutePath());
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 118) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 82 && (this).Tracker.this.shift_down) {
                                Tracker.this.setCursor(3);
                                Tracker.this.optimizeCellsToTracks();
                                Tracker.this.setCursor(0);
                            }
                            (this).Tracker.this.ctrl_down = false;
                            (this).Tracker.this.shift_down = false;
                            (this).Tracker.this.finished_task = true;
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.disp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                int clickx = (int)Math.round((double)(arg0.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                int clicky = (int)Math.round((double)(arg0.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                if (arg0.getButton() == 3 && arg0.getClickCount() == 1 && Tracker.this.ctrl_down) {
                    Tracker.this.cx = clickx;
                    Tracker.this.cy = clicky;
                }
                System.err.println("Clicked: " + Tracker.this.cx + "," + Tracker.this.cy);
                if (arg0.getButton() == 1) {
                    if (Tracker.this.pick != null) {
                        if (!Tracker.this.ctrl_down && !Tracker.this.shift_down) {
                            Tracker.this.pick.addWaypoint(Tracker.this.index, clickx, clicky);
                            Tracker.this.paint();
                        } else if (Tracker.this.shift_down && !Tracker.this.ctrl_down) {
                            Tracker.this.pick.removeWaypoint(Tracker.this.index);
                            Tracker.this.paint();
                        } else if (Tracker.this.ctrl_down && Tracker.this.shift_down) {
                            if (Tracker.this.daughter1 == null) {
                                Tracker.this.daughter1 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                            } else {
                                Tracker.this.daughter2 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                                Tracker.this.addCell(Tracker.this.daughter1);
                                Tracker.this.addCell(Tracker.this.daughter2);
                                Tracker.this.daughter2 = null;
                                Tracker.this.daughter1 = null;
                                Tracker.this.pick.Tdiv = Tracker.this.index;
                                Tracker.this.pick = Tracker.this.daughter1;
                                Tracker.this.paint();
                            }
                        }
                    }
                } else if (arg0.getButton() == 3) {
                    if (arg0.getClickCount() == 1 && !Tracker.this.ctrl_down) {
                        Tracker.this.pick = null;
                        for (Cell c : Tracker.this.cells) {
                            if (!c.insideSimple(clickx, clicky, Tracker.this.index)) continue;
                            Tracker.this.pick = c;
                            break;
                        }
                        if (Tracker.this.pick != null) {
                            Tracker.this.info("Cell: " + Tracker.this.pick.id + " X:" + Tracker.this.pick.getCOM((int)Tracker.this.index).x + " Y:" + Tracker.this.pick.getCOM((int)Tracker.this.index).y + " A:" + Tracker.this.pick.getArea(Tracker.this.index));
                            Tracker.this.setTitle("Placing cell " + Tracker.this.pick.id + " x: " + Tracker.this.pick.getCOM((int)Tracker.this.index).x + " y: " + Tracker.this.pick.getCOM((int)Tracker.this.index).y + " area: " + Tracker.this.pick.getArea(Tracker.this.index));
                        } else {
                            Cell best = null;
                            double best_distance = 9999999.0;
                            for (Cell c : Tracker.this.cells) {
                                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                                if (position == null || !(position.squaredDistance(clickx, clicky) < best_distance)) continue;
                                best = c;
                                best_distance = position.squaredDistance(clickx, clicky);
                            }
                            if (best != null && best_distance < 25.0) {
                                Tracker.this.pick = best;
                                Tracker.this.info("Selected " + best.id);
                                Tracker.this.paint();
                            }
                        }
                        Tracker.this.paint();
                    } else if (arg0.getClickCount() == 2) {
                        if (Tracker.this.debug) {
                            System.err.println("Adding new cell");
                        }
                        boolean[][][] clusteredSpots = Tracker.this.getClusteredHotspots(clickx - 15, clickx + 15, clicky - 15, clicky + 15, 2, 12);
                        Cell newcell = new Cell(Tracker.this.self, gradient, clusteredSpots, Tracker.this.index, Tracker.this.getNextId(), (short)clickx, (short)clicky);
                        if (Tracker.this.shift_down) {
                            newcell.gen = -1;
                        }
                        Tracker.this.addCell(newcell);
                        Tracker.this.pick = newcell;
                        Tracker.this.pick.finalize(Tracker.this.current, Tracker.this.index, 1.0f);
                        Tracker.this.setTitle("Created new cell for tracking: " + Tracker.this.pick.id);
                        Tracker.this.disp.updateUI();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                Tracker.this.cy = -1;
                Tracker.this.cx = -1;
            }
        });
        this.disp.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Tracker.this.cx != -1) {
                    int clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                    int clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                    Tracker.this.disp.centerx = (int)((double)Tracker.this.disp.centerx + (double)(Tracker.this.cx - clickx) * Tracker.this.disp.zoom);
                    Tracker.this.disp.centery = (int)((double)Tracker.this.disp.centery + (double)(Tracker.this.cy - clicky) * Tracker.this.disp.zoom);
                    clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                    clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                    Tracker.this.cx = clickx;
                    Tracker.this.cy = clicky;
                    Tracker.this.paint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.disp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                try {
                    Tracker.this.disp.zoom = e.getWheelRotation() > 0 ? (Tracker.this.disp.zoom *= 1.5) : (Tracker.this.disp.zoom /= 1.5);
                    Tracker.this.disp.zoom = Math.max(0.05, Math.min(20.0, Tracker.this.disp.zoom));
                    Tracker.this.disp.setPreferredSize(new Dimension((int)((double)Tracker.this.current.getWidth() * Tracker.this.disp.zoom), (int)((double)Tracker.this.current.getHeight() * Tracker.this.disp.zoom)));
                    Tracker.this.self.setPreferredSize(new Dimension(Tracker.this.self.getWidth(), Tracker.this.self.getHeight()));
                    Tracker.this.self.pack();
                    Tracker.this.paint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.disp.setPreferredSize(new Dimension(this.current.getWidth(), this.current.getHeight()));
        cp.add((Component)this.disp, "Center");
        cp.invalidate();
        this.pack();
        this.disp.requestFocus();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("TrackerMax by Max Shokhirev 2013. Signaling Systems Laboratory");
        this.setVisible(true);
    }

    private void paint() {
        try {
            this.disp.paintImmediately(0, 0, this.disp.getWidth(), this.disp.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveEverything(File saveFile) {
        try {
            PrintWriter pw = new PrintWriter(saveFile);
            for (Cell c : this.cells) {
                if (c.lifeSpan(this.pngs.size() - 1) > 20) {
                    c.saveSelf(pw);
                }
                this.info("Cell " + c.id + "/" + this.cells.size() + " finished saving.");
            }
            pw.close();
            if (this.debug) {
                System.err.println("Saved everything");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadEverything(File openFile) {
        try {
            Scanner s = new Scanner(openFile);
            this.cells.clear();
            while (s.hasNextLine()) {
                Cell c = new Cell(this.self, s);
                this.addCell(c);
                this.id = Math.max(this.id, c.id);
                if (this.cells.size() % 10 != 0) continue;
                this.info("Loaded " + this.cells.size() + " cells.");
            }
            ++this.id;
            this.disp.updateUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean[][][] getClusteredHotspots(double xmin, double xmax, double ymin, double ymax, int rmin, int rmax) {
        return this.getClusteredHotspots(gradient, 15000, 40000, 20.0, 3.0, (int)Math.max(0.0, xmin), (int)Math.min((double)(gradient.length - 1), xmax), (int)Math.max(0.0, ymin), (int)Math.min((double)(gradient[0].length - 1), ymax), rmin, rmax);
    }

    public final boolean[][][] getClusteredHotspots(int[][] gradient, int edge_threshold, int accumulator_threshold, double min_vote, double vote_per_r, int xmin, int xmax, int ymin, int ymax, int rmin, int rmax) {
        boolean[][][] clustered = new boolean[16][gradient.length][gradient[0].length];
        int[][][] accumulator = new int[16][gradient.length][gradient[0].length];
        LinkedList<ShortPoint> edgePixels = new LinkedList<ShortPoint>();
        int i = xmin;
        while (i < xmax) {
            int j = ymin;
            while (j < ymax) {
                try {
                    if (gradient[i][j] > edge_threshold) {
                        edgePixels.add(new ShortPoint(i, j));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        int r = Math.max(rmin, 1);
        while (r <= Math.min(rmax, 15)) {
            LinkedList<ShortPoint> points = this.circlePoints.get(r - 1);
            for (ShortPoint point : edgePixels) {
                for (ShortPoint sp : points) {
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x + 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x - 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y + 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y - 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++r;
        }
        r = Math.max(rmin, 1);
        while (r <= Math.min(rmax, 15)) {
            int threshold = (int)(min_vote + vote_per_r * Math.PI * (double)r);
            int i2 = xmin;
            while (i2 < xmax) {
                int j = ymin;
                while (j < ymax) {
                    if (accumulator[r][i2][j] > threshold) {
                        LinkedList<ShortPoint> hotspot = Static.floodFillThreshold(accumulator[r], gradient, i2, j, threshold, accumulator_threshold);
                        double centerx = 0.0;
                        double centery = 0.0;
                        for (ShortPoint sp : hotspot) {
                            centerx += (double)sp.x;
                            centery += (double)sp.y;
                            accumulator[r][sp.x][sp.y] = 0;
                        }
                        int x = (int)Math.round(centerx / (double)hotspot.size());
                        int y = (int)Math.round(centery / (double)hotspot.size());
                        if (hotspot.size() > 1) {
                            clustered[r][x][y] = true;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            ++r;
        }
        return clustered;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private void saveToCSV(String filename) {
        if (this.debug) {
            System.err.println("Saving cell properties to csv file.");
        }
        HashMap<Cell, Boolean> grew = new HashMap<Cell, Boolean>();
        for (Cell c : this.cells) {
            c.setModeledMasses2();
            try {
                if (c.getStats((int)c.Tmin).modeledMass < c.getStats((int)(c.Tmax - 1)).modeledMass / 2.0f && c.Tmax - c.Tmin > 300) {
                    grew.put(c, true);
                } else {
                    grew.put(c, false);
                }
            }
            catch (Exception e) {
                grew.put(c, false);
            }
            this.info("Cell " + c.id + "/" + this.cells.size() + " masses modeled.");
        }
        try {
            int maximum_frame = this.pngs.size();
            PrintWriter pw = new PrintWriter(filename);
            String header = "Frame#";
            for (Cell c : this.cells) {
                header = String.valueOf(header) + ",Score " + c.id;
            }
            for (Cell c : this.cells) {
                header = String.valueOf(header) + ",Area " + c.id;
            }
            for (Cell c : this.cells) {
                header = String.valueOf(header) + ",Mass " + c.id;
            }
            for (Cell c : this.cells) {
                header = (Boolean)grew.get(c) != false ? String.valueOf(header) + ",* MM " + c.id : String.valueOf(header) + ",MM " + c.id;
            }
            for (Cell c : this.cells) {
                header = String.valueOf(header) + ",Compactness " + c.id;
            }
            for (Cell c : this.cells) {
                header = String.valueOf(header) + ",X Cell " + c.id;
            }
            for (Cell c : this.cells) {
                header = String.valueOf(header) + ",Y Cell " + c.id;
            }
            pw.println(header);
            int t = 0;
            while (t < maximum_frame) {
                if (this.debug) {
                    System.err.println(String.valueOf(t) + "/" + maximum_frame);
                }
                double[][] data = new double[this.cells.size()][7];
                int count = 0;
                StringBuilder sb = new StringBuilder(t + 1);
                for (Cell c : this.cells) {
                    if (c.getStats(t) != null) {
                        data[count][0] = c.getStats((int)t).fate_score;
                        data[count][1] = c.getStats((int)t).area;
                        data[count][2] = c.getStats((int)t).mass;
                        data[count][3] = c.getStats((int)t).modeledMass;
                        data[count][4] = c.getStats((int)t).compactness;
                        data[count][5] = c.getStats((int)t).x;
                        data[count][6] = c.getStats((int)t).y;
                    }
                    ++count;
                }
                sb.append(t);
                int i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(String.format("%3.3f", data[i][0]));
                    ++i;
                }
                i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i][1]);
                    ++i;
                }
                i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(String.format("%3.3f", data[i][2]));
                    ++i;
                }
                i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(String.format("%3.3f", data[i][3]));
                    ++i;
                }
                i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(String.format("%3.3f", data[i][4]));
                    ++i;
                }
                i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i][5]);
                    ++i;
                }
                i = 0;
                while (i < this.cells.size()) {
                    sb.append(",");
                    sb.append(data[i][6]);
                    ++i;
                }
                pw.println(sb.toString());
                if (t % 10 == 0) {
                    this.info("Saved frame " + t + " to " + filename);
                }
                ++t;
            }
            if (this.debug) {
                System.err.println("Saved everything " + this.cells.size() + " cells and " + maximum_frame + " frames");
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new Tracker();
    }

    private class FComparator
    implements Comparator<File> {
        private FComparator() {
        }

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    private class Preparer
    extends Thread {
        LinkedList<Cell> group;
        int t = 0;

        public Preparer(LinkedList<Cell> group, int t) {
            this.group = group;
            this.t = t;
            this.start();
        }

        @Override
        public void run() {
            for (Cell c : this.group) {
                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                int radius = (int)Math.round(Math.sqrt(c.avgArea / 2.7));
                int lastFrame = c.lastFrame(this.t - 1);
                if (c.points.get(lastFrame) == null) {
                    boolean[][][] clusteredSpots = Tracker.this.getClusteredHotspots(position.x - 15.0, position.x + 15.0, position.y - 15.0, position.y + 15.0, 2, 10);
                    c.prepareOptimization(this.t, gradient, clusteredSpots, position);
                    continue;
                }
                DoublePoint previousCenter = c.getCenter(c.lastFrame(this.t - 1));
                boolean[][][] clusteredSpots = Tracker.this.getClusteredHotspots(position.x - 15.0, previousCenter.x + 15.0, previousCenter.y - 15.0, previousCenter.y + 15.0, radius, radius + 3);
                c.prepareOptimization(this.t, gradient, clusteredSpots, previousCenter);
            }
        }
    }
}

