/*
 * Decompiled with CFR 0.152.
 */
package semiTracker3working;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import semiTracker3working.Tracker;

public class CellDisplay
extends JPanel {
    Tracker track;
    int xmargin = 20;
    int ymargin = 20;

    public CellDisplay(Tracker track) {
        this.track = track;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Color[] colors = new Color[]{Color.red.darker().darker(), Color.blue, Color.green, Color.cyan, Color.blue.darker(), Color.red.brighter().brighter(), Color.green.darker().darker(), Color.yellow, Color.blue.brighter().brighter(), Color.yellow.darker(), Color.orange, Color.magenta.brighter()};
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(0, 0, w, h);
        g2.setColor(Color.black);
        g2.drawLine(this.xmargin, h - this.ymargin, w, h - this.ymargin);
        g2.drawLine(this.xmargin, 0, this.xmargin, h - this.ymargin);
        float maxMass = 1200.0f;
        if (this.track.pick != null) {
            int frame;
            int r = colors[this.track.pick.id % colors.length].getRed();
            int gr = colors[this.track.pick.id % colors.length].getGreen();
            int b = colors[this.track.pick.id % colors.length].getBlue();
            int x = 0;
            while (x < w - this.xmargin - 1) {
                g2.setColor(new Color(r, gr, b, 130));
                frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                int frame2 = (int)((double)(x + 1) / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                if (this.track.pick.getStats(frame) != null && this.track.pick.getStats(frame2) != null) {
                    float mass1 = this.track.pick.getStats((int)frame).mass;
                    float mass2 = this.track.pick.getStats((int)frame2).mass;
                    int y1 = Math.round((float)(h - this.ymargin) * (mass1 / maxMass));
                    int y2 = Math.round((float)(h - this.ymargin) * (mass2 / maxMass));
                    g2.drawLine(x + this.xmargin, h - this.ymargin - y1, x + 1 + this.xmargin, h - this.ymargin - y2);
                    g2.setColor(g2.getColor().darker());
                    g2.drawLine(x + this.xmargin + 1, h - this.ymargin - y1 + 1, x + 1 + this.xmargin + 1, h - this.ymargin - y2 + 1);
                }
                ++x;
            }
            x = (int)((double)this.track.index / (double)this.track.pngs.size() * (double)(w - this.xmargin));
            g2.setColor(Color.black);
            frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
            if (this.track.pick.getStats(frame) != null) {
                float cmass = this.track.pick.getStats((int)frame).mass;
                int y = Math.round((float)(h - this.ymargin) * (cmass / maxMass));
                g2.fillOval(x + this.xmargin - 1, h - this.ymargin - y - 1, 3, 3);
            }
        }
    }
}

