/*
 * Decompiled with CFR 0.152.
 */
package semiTracker3working;

import semiTracker3working.DoublePoint;

public class Waypoint {
    int start;
    int end;
    int x1;
    int x2;
    int y1;
    int y2;

    public Waypoint(int start, int end, int x1, int y1, int x2, int y2) {
        this.start = start;
        this.end = end;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public DoublePoint getPoint(int t) {
        if (t >= this.start && t <= this.end) {
            if (this.start == this.end) {
                return new DoublePoint(this.x1, this.y1);
            }
            double dx = (double)(this.x2 - this.x1) / (double)(this.end - this.start);
            double dy = (double)(this.y2 - this.y1) / (double)(this.end - this.start);
            return new DoublePoint((double)this.x1 + dx * (double)(t - this.start), (double)this.y1 + dy * (double)(t - this.start));
        }
        return null;
    }

    public boolean contains(int t) {
        return t >= this.start && t <= this.end;
    }

    public double clickDistance(int x, int y, int t) {
        DoublePoint clickPoint = this.getPoint(t);
        if (clickPoint != null) {
            double d = clickPoint.squaredDistance(x, y);
            return d;
        }
        return 9.99999999E8;
    }
}

