/*
 * Decompiled with CFR 0.152.
 */
package semiTracker61813;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import semiTracker61813.Tracker;

public class CellDisplay
extends JPanel {
    Tracker track;
    int xmargin = 30;
    int ymargin = 30;

    public CellDisplay(Tracker track) {
        this.track = track;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Color[] colors = new Color[]{Color.red.darker().darker(), Color.blue, Color.green, Color.cyan, Color.blue.darker(), Color.red.brighter().brighter(), Color.green.darker().darker(), Color.yellow, Color.blue.brighter().brighter(), Color.yellow.darker(), Color.orange, Color.magenta.brighter()};
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(0, 0, w, h);
        g2.setColor(Color.black);
        g2.drawLine(this.xmargin, h - this.ymargin, w, h - this.ymargin);
        g2.drawLine(this.xmargin, 0, this.xmargin, h - this.ymargin);
        float maxMass = 1800.0f;
        if (this.track.pick != null) {
            int frame;
            int r = colors[this.track.pick.id % colors.length].getRed();
            int gr = colors[this.track.pick.id % colors.length].getGreen();
            int b = colors[this.track.pick.id % colors.length].getBlue();
            int x = 0;
            while (x < w - this.xmargin - 1) {
                g2.setColor(new Color(r, gr, b, 130));
                frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                int frame2 = (int)((double)(x + 1) / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                if (this.track.pick.getStats(frame) != null && this.track.pick.getStats(frame2) != null) {
                    float mass1 = this.track.pick.getStats((int)frame).mass;
                    float mass2 = this.track.pick.getStats((int)frame2).mass;
                    int y1 = Math.round((float)(h - this.ymargin) * (mass1 / maxMass));
                    int y2 = Math.round((float)(h - this.ymargin) * (mass2 / maxMass));
                    g2.drawLine(x + this.xmargin, h - this.ymargin - y1, x + 1 + this.xmargin, h - this.ymargin - y2);
                }
                ++x;
            }
            g2.setFont(new Font("Arial", 0, 9));
            x = (int)((double)this.track.index / (double)this.track.pngs.size() * (double)(w - this.xmargin));
            g2.setColor(Color.black);
            frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
            if (this.track.pick.getStats(frame) != null) {
                float cmass = this.track.pick.getStats((int)frame).mass;
                int y = Math.round((float)(h - this.ymargin) * (cmass / maxMass));
                g2.fillOval(x + this.xmargin - 1, h - this.ymargin - y - 1, 3, 3);
                g2.drawString("" + (int)cmass, x + this.xmargin - 15, h - this.ymargin - y);
            }
            if (this.track.pick.Tdiv > -1) {
                x = (int)((double)this.track.pick.Tdiv / (double)this.track.pngs.size() * (double)(w - this.xmargin));
                g2.setColor(Color.GREEN.darker());
                frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                if (this.track.pick.getStats(frame) != null) {
                    float cmass = this.track.pick.getStats((int)frame).mass;
                    int y = Math.round((float)(h - this.ymargin) * (cmass / maxMass));
                    g2.fillOval(x + this.xmargin - 1, h - this.ymargin - y - 1, 3, 3);
                    g2.drawString("<", x + this.xmargin, h - this.ymargin - y);
                }
            }
            if (this.track.pick.Tdie > -1) {
                x = (int)((double)this.track.pick.Tdie / (double)this.track.pngs.size() * (double)(w - this.xmargin));
                g2.setColor(Color.RED.darker());
                frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                if (this.track.pick.getStats(frame) != null) {
                    float cmass = this.track.pick.getStats((int)frame).mass;
                    int y = Math.round((float)(h - this.ymargin) * (cmass / maxMass));
                    g2.fillOval(x + this.xmargin - 1, h - this.ymargin - y - 1, 3, 3);
                    g2.drawString("x", x + this.xmargin, h - this.ymargin - y);
                }
            }
            if (this.track.pick.Tgone > -1) {
                x = (int)((double)this.track.pick.Tgone / (double)this.track.pngs.size() * (double)(w - this.xmargin));
                g2.setColor(Color.BLUE.darker());
                frame = (int)((double)x / (double)(w - this.xmargin) * (double)this.track.pngs.size());
                if (this.track.pick.getStats(frame) != null) {
                    float cmass = this.track.pick.getStats((int)frame).mass;
                    int y = Math.round((float)(h - this.ymargin) * (cmass / maxMass));
                    g2.fillOval(x + this.xmargin - 1, h - this.ymargin - y - 1, 3, 3);
                    g2.drawString("->", x + this.xmargin, h - this.ymargin - y);
                }
            }
            g2.setColor(Color.BLACK);
            int f = 5;
            int i = 0;
            while (i <= h - this.ymargin) {
                g2.drawLine(-2 + this.xmargin, i, 2 + this.xmargin, i);
                g2.drawString(String.format("%d", (int)((double)((float)f * maxMass) / 5.0)), this.xmargin - 20, i + 8);
                --f;
                i += (h - this.ymargin) / 5;
            }
            f = 0;
            i = 0;
            while (i < w - this.xmargin) {
                g2.drawLine(i + this.xmargin, h - this.ymargin - 2, i + this.xmargin, h - this.ymargin + 2);
                g2.drawString(String.format("%d", this.track.pngs.size() * f / 5), i + this.xmargin - 5, h - this.ymargin + 10);
                ++f;
                i += (w - this.xmargin) / 5;
            }
            g2.drawString("Frame #", (w - this.xmargin) / 2 - 5, h - this.ymargin + 28);
            g2.drawString("Vol", 0, h / 2 - 7);
        }
    }
}

