/*
 * Decompiled with CFR 0.152.
 */
package semiTracker61813;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import semiTracker61813.Cell;
import semiTracker61813.CellDisplay;
import semiTracker61813.CellRegion;
import semiTracker61813.Dialogs;
import semiTracker61813.Display;
import semiTracker61813.DoublePoint;
import semiTracker61813.ShortPoint;
import semiTracker61813.Static;
import semiTracker61813.Waypoint;

public class Tracker
extends JFrame {
    Tracker self = this;
    BufferedImage current = null;
    BufferedImage sobelImage = null;
    int index = 0;
    static int[][] gradient;
    static final int hotspotRadius = 10;
    static final int maximum_radius = 10;
    static final double growthRatio = 1.5;
    ArrayList<LinkedList<ShortPoint>> circlePoints = new ArrayList();
    int[][] current_averages;
    int[][][] img_averages;
    int total_images_processed = 0;
    boolean escape_flag = false;
    private int id = 0;
    boolean applyMinMax = false;
    boolean color_by_score = false;
    boolean animateBlobs = false;
    boolean sobel = false;
    boolean continuousStitch = false;
    boolean endStitch = false;
    private static int minTrackLength;
    boolean finished_task = true;
    boolean debug = false;
    boolean timing = false;
    File dir;
    ArrayList<File> pngs = new ArrayList();
    Display disp;
    CellDisplay cdisp;
    Cell pick;
    Cell daughter1 = null;
    Cell daughter2 = null;
    boolean ctrl_down = false;
    boolean shift_down = false;
    int cx = -1;
    int cy = -1;
    HashSet<Cell> cells = new HashSet();
    HashMap<Integer, Cell> idmap = new HashMap();
    private final int region_size = 15;
    CellRegion[][] regions;
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH-mm-ss";

    static {
        minTrackLength = 0;
    }

    public int getNextId() {
        int result = this.id++;
        return result;
    }

    private void setDir(File d) {
        this.dir = d;
        this.pngs.clear();
        if (this.debug) {
            System.err.println("Found " + d.list().length + " files in dir " + d.getName());
        }
        String[] strs = d.list();
        File[] files = d.listFiles();
        int i = 0;
        while (i < files.length) {
            if (strs[i].endsWith("png") || strs[i].endsWith("PNG")) {
                this.pngs.add(files[i]);
            }
            ++i;
        }
        Collections.sort(this.pngs, new FComparator());
        this.img_averages = new int[this.pngs.size()][1][1];
    }

    private void setCurrent(int new_index) {
        if ((new_index %= this.pngs.size()) < 0) {
            new_index = this.pngs.size() + new_index;
        }
        this.current = null;
        this.current = this.applyMinMax ? Static.adjustMinMax(this.getImage(new_index)) : this.getImage(new_index);
        this.sobelImage = Static.getSobelTransformed(this.current);
        this.regions = null;
        gradient = Static.getIntArray(this.sobelImage);
        this.total_images_processed = Math.max(this.total_images_processed, new_index + 1);
        this.index = new_index;
        this.setTitle("TrackerMax by Shokhirev M., Signaling Systems Laboratory (C) 2013. Current Frame = " + this.index + "/" + this.pngs.size());
    }

    private void populateCellRegions() {
        this.regions = new CellRegion[this.current.getWidth() / 15][this.current.getHeight() / 15];
        for (Cell c : this.cells) {
            if (!c.exists(this.index)) continue;
            DoublePoint center = c.getCenter(this.index);
            int x = (int)(center.x / 15.0);
            int y = (int)(center.y / 15.0);
            try {
                if (this.regions[x][y] == null) {
                    this.regions[x][y] = new CellRegion();
                }
                this.regions[x][y].addCell(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void optimizeCellsToTracks() {
        HashMap<Cell, HashSet<Cell>> nearbys = new HashMap<Cell, HashSet<Cell>>();
        double avgTime = 0.0;
        long timer = 0L;
        int cores = Runtime.getRuntime().availableProcessors() - 1;
        int t = Math.max(this.index, 1);
        while (t < this.pngs.size()) {
            long time;
            if (this.escape_flag) {
                this.escape_flag = false;
                break;
            }
            timer = time = System.currentTimeMillis();
            this.setCurrent(t);
            nearbys.clear();
            ArrayList<Cell> currentCells = new ArrayList<Cell>();
            for (Cell c : this.cells) {
                if (c.getWaypointPosition(t) == null) continue;
                currentCells.add((int)(Math.random() * (double)currentCells.size()), c);
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + " Setting current cells took " + (System.currentTimeMillis() - timer) + " ms current Cells: " + currentCells.size());
                timer = System.currentTimeMillis();
            }
            LinkedList<LinkedList<Cell>> cellGroups = Static.splitList(currentCells, cores);
            LinkedList<Preparer> preparers = new LinkedList<Preparer>();
            for (LinkedList linkedList : cellGroups) {
                preparers.add(new Preparer(linkedList, t));
            }
            for (Preparer preparer : preparers) {
                try {
                    preparer.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + "Preparing cells took " + (System.currentTimeMillis() - timer) + " ms current Cells: " + currentCells.size());
                timer = System.currentTimeMillis();
            }
            this.populateCellRegions();
            for (Cell cell : currentCells) {
                if (cell.getPoints(t) != null) {
                    nearbys.put(cell, this.getNearby(cell, t));
                    continue;
                }
                currentCells.remove(cell);
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + " Assigning nearby cells took  " + (System.currentTimeMillis() - timer) + " ms");
                timer = System.currentTimeMillis();
            }
            boolean bl = true;
            if (this.animateBlobs) {
                boolean bl2;
                while (bl2) {
                    bl2 = false;
                    Collections.shuffle(currentCells);
                    for (Cell c : currentCells) {
                        int result;
                        Waypoint wp = c.getWaypointAt(t);
                        double d = Math.pow(wp.x1 - wp.x2, 2.0) + Math.pow(wp.y1 - wp.y2, 2.0) * (double)(wp.end - wp.start) / 10.0;
                        if (wp == null || (result = c.iterate(gradient, (Collection<Cell>)nearbys.get(c), t, wp.getPoint(t), 1.0 / (1.0 + d))) != 1) continue;
                        bl2 = true;
                    }
                    this.paint();
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                LinkedList<Iterator> iterators = new LinkedList<Iterator>();
                for (LinkedList linkedList : cellGroups) {
                    iterators.add(new Iterator(linkedList, t, nearbys));
                }
                for (Iterator iterator : iterators) {
                    try {
                        iterator.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.timing) {
                System.err.println("Frame " + this.index + "amoeba physics took " + (System.currentTimeMillis() - timer) + " ms");
            }
            for (Cell c : currentCells) {
                c.finalize(this.current, t, 1.0f);
            }
            double seconds = (double)(System.currentTimeMillis() - time) / 1000.0;
            avgTime = (avgTime * (double)(t - 1) + seconds) / (double)t;
            double minutes_left = (double)(this.pngs.size() - t) * avgTime / 60.0;
            this.info(String.format("Finished frame: %d cells %d. Took %3.2f s, Avg %3.2f s, ETA in %3.2f m", t, currentCells.size(), seconds, avgTime, minutes_left));
            ++t;
        }
    }

    public Tracker() {
        this.initializeCirclePoints();
        this.initialize();
    }

    private HashSet<Cell> getNearby(Cell cell, int time) {
        if (this.regions == null) {
            this.populateCellRegions();
        }
        HashSet<Cell> nearby = new HashSet<Cell>();
        DoublePoint center = cell.getCenter(time);
        int x = (int)(center.x / 15.0);
        int y = (int)(center.y / 15.0);
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                try {
                    nearby.addAll(this.regions[x + i][y + j].getCells());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return nearby;
    }

    private void initializeCirclePoints() {
        this.circlePoints.clear();
        int rr = 0;
        while (rr < 10) {
            this.circlePoints.add(new LinkedList());
            ++rr;
        }
        int i = -10;
        while (i <= 10) {
            int j = -10;
            while (j <= 10) {
                int r = (int)Math.round(Math.sqrt(i * i + j * j));
                if (r <= 10 && r > 0) {
                    this.circlePoints.get(r - 1).add(new ShortPoint(i, j));
                }
                ++j;
            }
            ++i;
        }
    }

    public void addCell(Cell c) {
        this.cells.add(c);
        this.idmap.put(c.id, c);
    }

    public Cell getCellById(int cellid) {
        return this.idmap.get(cellid);
    }

    private BufferedImage getImage(int index) {
        if (this.dir != null) {
            try {
                return Static.getGrayscale(ImageIO.read(this.pngs.get(index % this.pngs.size())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void saveImages() {
        File dir = Dialogs.getSaveDir("Save images to dir");
        int i = 0;
        while (i < this.pngs.size()) {
            this.setCurrent(i);
            BufferedImage img = this.getImage(i);
            BufferedImage ioimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Static.paintOnGraphics((Graphics2D)ioimg.getGraphics(), img, false, true, true, true, false, false, null, 1.0, 0, 0, this.cells, this.index, this.pick);
            try {
                ImageIO.write((RenderedImage)ioimg, "PNG", new File(String.valueOf(dir.getAbsolutePath()) + File.separator + this.pngs.get(i).getName() + "_processed_" + String.format("%4d.png", i)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.info("Saved all images!");
    }

    private void info(String string) {
        this.disp.addMessage(string);
        this.paint();
    }

    private void initialize() {
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("Load");
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        boolean loading = true;
        while (loading) {
            int val = fc.showOpenDialog(this);
            if (val != 0 || !fc.getSelectedFile().isDirectory()) continue;
            this.setDir(fc.getSelectedFile());
            this.setCurrent(0);
            loading = false;
        }
        if (this.cdisp == null) {
            this.cdisp = new CellDisplay(this);
        }
        this.cdisp.setPreferredSize(new Dimension(250, 150));
        if (this.disp == null) {
            this.disp = new Display(this);
        }
        this.disp.addMessage("Welcome to TrackerMax 2013! Get ready to track some cells!");
        this.disp.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Tracker.this.ctrl_down = arg0.isControlDown();
                Tracker.this.shift_down = arg0.isShiftDown();
            }

            @Override
            public void keyReleased(final KeyEvent arg0) {
                if (arg0.getKeyCode() == 27 || arg0.getKeyCode() == 116 || arg0.getKeyCode() == 114 || arg0.getKeyCode() == 113 || arg0.getKeyCode() == 117 || arg0.getKeyCode() == 118 || Tracker.this.finished_task) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            int earliest_waypoint;
                            (this).Tracker.this.finished_task = false;
                            if (arg0.getKeyCode() == 68) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 100);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 1);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 69) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 20);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index + 5);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 33) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index + 25);
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 65) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 100);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 1);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 81) {
                                Tracker.this.setCursor(3);
                                if ((this).Tracker.this.shift_down) {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 20);
                                } else {
                                    Tracker.this.setCurrent((this).Tracker.this.index - 5);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 34) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.index - 25);
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 112) {
                                Tracker.this.setCursor(3);
                                Tracker.this.loadEverything(Dialogs.getOpenFile("dat", "load all cells from file"));
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 113) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.applyMinMax = !(this).Tracker.this.applyMinMax;
                                Tracker.this.info("Gamma correction is " + (this).Tracker.this.applyMinMax);
                                Tracker.this.setCurrent((this).Tracker.this.index);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 114) {
                                Tracker.this.setCursor(3);
                                (this).Tracker.this.sobel = !(this).Tracker.this.sobel;
                                System.err.println("Sobel is now " + (this).Tracker.this.sobel);
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 115) {
                                (this).Tracker.this.disp.toggleImage();
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 116) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveEverything(Dialogs.getSaveFile("dat", "Save all cells to file"));
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 117) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveToCSV(Dialogs.getSaveFile("csv", "Save all cell values to file").getAbsolutePath());
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 118) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveImages();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 119) {
                                Tracker.this.setCursor(3);
                                Tracker.this.saveDistributions(Dialogs.getSaveFile("csv", "Save all population statistics to file").getAbsolutePath());
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 120) {
                                (this).Tracker.this.animateBlobs = !(this).Tracker.this.animateBlobs;
                                Tracker.this.info("Animate Blobs sets to " + (this).Tracker.this.animateBlobs);
                            }
                            if (arg0.getKeyCode() == 121) {
                                (this).Tracker.this.color_by_score = !(this).Tracker.this.color_by_score;
                                Tracker.this.info("Set color by score to: " + (this).Tracker.this.color_by_score);
                            }
                            if (arg0.getKeyCode() == 84) {
                                (this).Tracker.this.disp.showAllTraces = !(this).Tracker.this.disp.showAllTraces;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 71) {
                                (this).Tracker.this.disp.showTags = !(this).Tracker.this.disp.showTags;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.goodOnly = !(this).Tracker.this.disp.goodOnly;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 74) {
                                (this).Tracker.this.disp.centerx += 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 76) {
                                (this).Tracker.this.disp.centerx -= 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 73) {
                                (this).Tracker.this.disp.centery -= 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 75) {
                                (this).Tracker.this.disp.centery += 20;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 85) {
                                (this).Tracker.this.disp.zoom *= 1.25;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 79) {
                                (this).Tracker.this.disp.zoom *= 0.75;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 127 && (this).Tracker.this.pick != null) {
                                int i = 0;
                                while (i < (this).Tracker.this.pick.waypoints.size()) {
                                    if ((this).Tracker.this.pick.waypoints.get((int)i).end > (this).Tracker.this.index) {
                                        (this).Tracker.this.pick.waypoints.remove(i);
                                        --i;
                                    }
                                    ++i;
                                }
                                if ((this).Tracker.this.pick.waypoints.size() == 0) {
                                    (this).Tracker.this.cells.remove((this).Tracker.this.pick);
                                }
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 32) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent(0);
                                Tracker.this.info("Back to frame 0");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 35) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCurrent((this).Tracker.this.pngs.size() - 1);
                                Tracker.this.info("To the end");
                                (this).Tracker.this.disp.repaint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 27) {
                                (this).Tracker.this.escape_flag = true;
                                Tracker.this.info("Stopping the tracking early...");
                            }
                            if (arg0.getKeyCode() == 78) {
                                Tracker.this.setCursor(3);
                                Cell best = null;
                                earliest_waypoint = 999999;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end >= earliest_waypoint || c.waypoints.get((int)(c.waypoints.size() - 1)).end <= (this).Tracker.this.index || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 66) {
                                Tracker.this.setCursor(3);
                                Cell best = null;
                                earliest_waypoint = 0;
                                for (Cell c : (this).Tracker.this.cells) {
                                    if (c.waypoints.size() > 0) {
                                        if (c.waypoints.get((int)(c.waypoints.size() - 1)).end <= earliest_waypoint || c.waypoints.get((int)(c.waypoints.size() - 1)).end >= (this).Tracker.this.index || c.Tgone != -1) continue;
                                        best = c;
                                        earliest_waypoint = c.waypoints.get((int)(c.waypoints.size() - 1)).end;
                                        continue;
                                    }
                                    if (c.lastFrame((this).Tracker.this.index) >= earliest_waypoint) continue;
                                    best = c;
                                    earliest_waypoint = c.lastFrame((this).Tracker.this.index);
                                }
                                (this).Tracker.this.pick = best;
                                Tracker.this.setCurrent(earliest_waypoint);
                                if (best != null) {
                                    Tracker.this.info("The earliest cell path is at frame:" + earliest_waypoint + " now editing cell: " + best.id);
                                }
                                Tracker.this.paint();
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 88 && (this).Tracker.this.ctrl_down && (this).Tracker.this.pick != null) {
                                Tracker.this.info("Cell " + (this).Tracker.this.pick.id + " died at " + (this).Tracker.this.index);
                                (this).Tracker.this.pick.killAt((this).Tracker.this.index);
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 90 && (this).Tracker.this.ctrl_down && (this).Tracker.this.pick != null) {
                                Tracker.this.info("Cell " + (this).Tracker.this.pick.id + " left at " + (this).Tracker.this.index);
                                (this).Tracker.this.pick.leaveAt((this).Tracker.this.index);
                                (this).Tracker.this.pick = null;
                                Tracker.this.paint();
                            }
                            if (arg0.getKeyCode() == 87 && (this).Tracker.this.pick != null) {
                                if ((this).Tracker.this.shift_down) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.pick.waypoints.size() > 0) {
                                        Tracker.this.setCurrent((this).Tracker.this.pick.waypoints.get((int)((this).Tracker.this.pick.waypoints.size() - 1)).end);
                                        Tracker.this.paint();
                                    }
                                } else {
                                    Waypoint current = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index);
                                    if (current != null) {
                                        if ((this).Tracker.this.index < current.end) {
                                            Tracker.this.setCurrent(current.end);
                                        } else {
                                            Waypoint next = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index + 1);
                                            if (next != null) {
                                                Tracker.this.setCurrent(next.end);
                                            }
                                        }
                                        Tracker.this.paint();
                                    }
                                }
                            }
                            if (arg0.getKeyCode() == 83) {
                                Waypoint current;
                                if ((this).Tracker.this.shift_down) {
                                    if ((this).Tracker.this.pick != null && (this).Tracker.this.pick.waypoints.size() > 0) {
                                        Tracker.this.setCurrent((this).Tracker.this.pick.waypoints.get((int)0).start);
                                        Tracker.this.paint();
                                    }
                                } else if ((this).Tracker.this.pick != null && (current = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index)) != null) {
                                    if ((this).Tracker.this.index > current.start) {
                                        Tracker.this.setCurrent(current.start);
                                    } else {
                                        Waypoint next = (this).Tracker.this.pick.getWaypointAt((this).Tracker.this.index - 1);
                                        if (next != null) {
                                            Tracker.this.setCurrent(next.start);
                                        }
                                    }
                                    Tracker.this.paint();
                                }
                            }
                            if (arg0.getKeyCode() == 70) {
                                Tracker.this.setCursor(3);
                                Tracker.this.setCursor(0);
                            }
                            if (arg0.getKeyCode() == 82 && (this).Tracker.this.shift_down) {
                                Tracker.this.setCursor(3);
                                Tracker.this.optimizeCellsToTracks();
                                Tracker.this.setCursor(0);
                            }
                            (this).Tracker.this.ctrl_down = false;
                            (this).Tracker.this.shift_down = false;
                            (this).Tracker.this.finished_task = true;
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.disp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent arg0) {
                int clickx = (int)Math.round((double)(arg0.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                int clicky = (int)Math.round((double)(arg0.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                if (arg0.getButton() == 3 && arg0.getClickCount() == 1 && Tracker.this.ctrl_down) {
                    Tracker.this.cx = clickx;
                    Tracker.this.cy = clicky;
                }
                System.err.println("Clicked: " + Tracker.this.cx + "," + Tracker.this.cy);
                if (arg0.getButton() == 1) {
                    if (Tracker.this.pick != null) {
                        if (!Tracker.this.ctrl_down && !Tracker.this.shift_down) {
                            Tracker.this.pick.addWaypoint(Tracker.this.index, clickx, clicky);
                            Tracker.this.paint();
                        } else if (Tracker.this.shift_down && !Tracker.this.ctrl_down) {
                            Cell best = null;
                            double best_distance = 9999999.0;
                            for (Cell c : Tracker.this.cells) {
                                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                                if (position == null || !(position.squaredDistance(clickx, clicky) < best_distance)) continue;
                                best = c;
                                best_distance = position.squaredDistance(clickx, clicky);
                            }
                            if (best != null && best_distance < 25.0) {
                                Tracker.this.pick.takeOver(best, Tracker.this.index);
                                Tracker.this.paint();
                            }
                        } else if (Tracker.this.ctrl_down && Tracker.this.shift_down) {
                            if (Tracker.this.daughter1 == null) {
                                Tracker.this.daughter1 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                            } else {
                                Tracker.this.daughter2 = new Cell(Tracker.this.index, Tracker.this.getNextId(), clickx, clicky, Tracker.this.pick);
                                Tracker.this.addCell(Tracker.this.daughter1);
                                Tracker.this.addCell(Tracker.this.daughter2);
                                Tracker.this.daughter2 = null;
                                Tracker.this.daughter1 = null;
                                Tracker.this.pick.Tdiv = Tracker.this.index;
                                Tracker.this.pick = Tracker.this.daughter1;
                                Tracker.this.paint();
                            }
                        }
                    }
                } else if (arg0.getButton() == 3) {
                    if (arg0.getClickCount() == 1 && !Tracker.this.ctrl_down) {
                        Tracker.this.pick = null;
                        for (Cell c : Tracker.this.cells) {
                            if (!c.insideSimple(clickx, clicky, Tracker.this.index)) continue;
                            Tracker.this.pick = c;
                            Tracker.this.cdisp.paintImmediately(0, 0, Tracker.this.cdisp.getWidth(), Tracker.this.cdisp.getHeight());
                            break;
                        }
                        if (Tracker.this.pick != null) {
                            Cell c;
                            c = Tracker.this.pick;
                            synchronized (c) {
                                DoublePoint com = Tracker.this.pick.getCenter(Tracker.this.index);
                                if (com != null) {
                                    Tracker.this.info("Cell: " + Tracker.this.pick.id + " X:" + com.x + " Y:" + com.y + " A:" + Tracker.this.pick.getArea(Tracker.this.index));
                                    Tracker.this.setTitle("Placing cell " + Tracker.this.pick.id + " x: " + com.x + " y: " + com.y + " area: " + Tracker.this.pick.getArea(Tracker.this.index));
                                }
                            }
                        } else {
                            Cell best = null;
                            double best_distance = 9999999.0;
                            for (Cell c : Tracker.this.cells) {
                                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                                if (position == null || !(position.squaredDistance(clickx, clicky) < best_distance)) continue;
                                best = c;
                                best_distance = position.squaredDistance(clickx, clicky);
                            }
                            if (best != null && best_distance < 25.0) {
                                Tracker.this.pick = best;
                                Tracker.this.info("Selected " + best.id);
                                Tracker.this.paint();
                            }
                        }
                        Tracker.this.paint();
                    } else if (arg0.getClickCount() == 2) {
                        if (Tracker.this.debug) {
                            System.err.println("Adding new cell");
                        }
                        boolean[][][] clusteredSpots = Tracker.this.getClusteredHotspots(clickx - 10, clickx + 10, clicky - 10, clicky + 10, 2, 12);
                        Cell newcell = new Cell(Tracker.this.self, gradient, clusteredSpots, Tracker.this.index, Tracker.this.getNextId(), (short)clickx, (short)clicky);
                        if (Tracker.this.shift_down) {
                            newcell.gen = -1;
                        }
                        Tracker.this.addCell(newcell);
                        Tracker.this.pick = newcell;
                        Tracker.this.pick.finalize(Tracker.this.current, Tracker.this.index, 1.0f);
                        Tracker.this.setTitle("Created new cell for tracking: " + Tracker.this.pick.id);
                        Tracker.this.disp.updateUI();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                Tracker.this.cy = -1;
                Tracker.this.cx = -1;
            }
        });
        this.disp.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Tracker.this.cx != -1) {
                    int clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                    int clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                    Tracker.this.disp.centerx = (int)((double)Tracker.this.disp.centerx + (double)(Tracker.this.cx - clickx) * Tracker.this.disp.zoom);
                    Tracker.this.disp.centery = (int)((double)Tracker.this.disp.centery + (double)(Tracker.this.cy - clicky) * Tracker.this.disp.zoom);
                    clickx = (int)Math.round((double)(e.getX() + Tracker.this.disp.centerx) / Tracker.this.disp.zoom);
                    clicky = (int)Math.round((double)(e.getY() + Tracker.this.disp.centery) / Tracker.this.disp.zoom);
                    Tracker.this.cx = clickx;
                    Tracker.this.cy = clicky;
                    Tracker.this.paint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.disp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                try {
                    Tracker.this.disp.zoom = e.getWheelRotation() > 0 ? (Tracker.this.disp.zoom *= 1.5) : (Tracker.this.disp.zoom /= 1.5);
                    Tracker.this.disp.zoom = Math.max(0.05, Math.min(20.0, Tracker.this.disp.zoom));
                    Tracker.this.disp.setPreferredSize(new Dimension((int)((double)Tracker.this.current.getWidth() * Tracker.this.disp.zoom), (int)((double)Tracker.this.current.getHeight() * Tracker.this.disp.zoom)));
                    Tracker.this.self.setPreferredSize(new Dimension(Tracker.this.self.getWidth(), Tracker.this.self.getHeight()));
                    Tracker.this.self.pack();
                    Tracker.this.paint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.disp.setPreferredSize(new Dimension(this.current.getWidth(), this.current.getHeight()));
        cp.add((Component)this.disp, "Center");
        JPanel right = new JPanel();
        right.add(this.cdisp);
        cp.add((Component)right, "East");
        cp.invalidate();
        this.pack();
        this.disp.requestFocus();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("TrackerMax by Max Shokhirev 2013. Signaling Systems Laboratory");
        this.setVisible(true);
    }

    private void paint() {
        try {
            this.disp.paintImmediately(0, 0, this.disp.getWidth(), this.disp.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cdisp.paintImmediately(0, 0, this.cdisp.getWidth(), this.cdisp.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveEverything(File saveFile) {
        try {
            PrintWriter pw = new PrintWriter(saveFile);
            int count = 1;
            for (Cell c : this.cells) {
                if (c.lifeSpan(this.pngs.size() - 1) > 20) {
                    c.saveSelf(pw);
                }
                this.info("Cell " + count++ + "/" + this.cells.size() + " finished saving.");
            }
            pw.close();
            if (this.debug) {
                System.err.println("Saved everything");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadEverything(File openFile) {
        try {
            Scanner s = new Scanner(openFile);
            this.cells.clear();
            this.info("Loading cells from " + openFile.getName());
            while (s.hasNextLine()) {
                Cell c = new Cell(this.self, s);
                this.addCell(c);
                this.id = Math.max(this.id, c.id);
                if (this.cells.size() % 10 != 0) continue;
                this.info("Loaded " + this.cells.size() + " cells.");
            }
            ++this.id;
            this.disp.updateUI();
        }
        catch (Exception e) {
            this.info("Error:" + e.getLocalizedMessage());
        }
        this.info("All cells loaded from " + openFile.getName());
    }

    public final boolean[][][] getClusteredHotspots(double xmin, double xmax, double ymin, double ymax, int rmin, int rmax) {
        return this.getClusteredHotspots(gradient, 13000, 18000, 15.0, 2.5, (int)Math.max(0.0, xmin), (int)Math.min((double)(gradient.length - 1), xmax), (int)Math.max(0.0, ymin), (int)Math.min((double)(gradient[0].length - 1), ymax), rmin, rmax);
    }

    public final boolean[][][] getClusteredHotspots(int[][] gradient, int edge_threshold, int accumulator_threshold, double min_vote, double vote_per_r, int xmin, int xmax, int ymin, int ymax, int rmin, int rmax) {
        boolean[][][] clustered = new boolean[11][gradient.length][gradient[0].length];
        int[][][] accumulator = new int[11][gradient.length][gradient[0].length];
        LinkedList<ShortPoint> edgePixels = new LinkedList<ShortPoint>();
        int i = xmin;
        while (i < xmax) {
            int j = ymin;
            while (j < ymax) {
                try {
                    if (gradient[i][j] > edge_threshold) {
                        edgePixels.add(new ShortPoint(i, j));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        int r = Math.max(rmin, 1);
        while (r <= Math.min(rmax, 10)) {
            LinkedList<ShortPoint> points = this.circlePoints.get(r - 1);
            for (ShortPoint point : edgePixels) {
                for (ShortPoint sp : points) {
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x + 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x - 1];
                        int n = point.y + sp.y;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y + 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        int[] nArray = accumulator[r - 1][point.x + sp.x];
                        int n = point.y + sp.y - 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++r;
        }
        r = Math.max(rmin, 1);
        while (r <= Math.min(rmax, 10)) {
            int threshold = (int)(min_vote + vote_per_r * Math.PI * (double)r);
            int i2 = xmin;
            while (i2 < xmax) {
                int j = ymin;
                while (j < ymax) {
                    if (accumulator[r][i2][j] > threshold) {
                        LinkedList<ShortPoint> hotspot = Static.floodFillThreshold(accumulator[r], gradient, i2, j, threshold, accumulator_threshold);
                        double centerx = 0.0;
                        double centery = 0.0;
                        for (ShortPoint sp : hotspot) {
                            centerx += (double)sp.x;
                            centery += (double)sp.y;
                            accumulator[r][sp.x][sp.y] = 0;
                        }
                        int x = (int)Math.round(centerx / (double)hotspot.size());
                        int y = (int)Math.round(centery / (double)hotspot.size());
                        if (hotspot.size() > r * r) {
                            clustered[r][x][y] = true;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            ++r;
        }
        return clustered;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private void saveToCSV(String filename) {
        if (this.debug) {
            System.err.println("Saving cell properties to csv file.");
        }
        HashMap<Cell, Boolean> grew = new HashMap<Cell, Boolean>();
        int tick = 1;
        int maxGens = -1;
        for (Cell c : this.cells) {
            c.setModeledMasses2();
            try {
                if ((double)c.getStats((int)c.Tmin).modeledMass < (double)c.getStats((int)(c.Tmax - 1)).modeledMass / 1.5 && c.Tmax - c.Tmin > 200) {
                    grew.put(c, true);
                } else {
                    grew.put(c, false);
                }
            }
            catch (Exception e) {
                grew.put(c, false);
            }
            this.info("Cell " + tick++ + "/" + this.cells.size() + " masses modeled.");
            if (c.gen <= maxGens) continue;
            maxGens = c.gen;
        }
        ArrayList divisions = new ArrayList();
        int i = 0;
        while (i <= maxGens) {
            divisions.add(new ArrayList());
            ++i;
        }
        for (Cell c : this.cells) {
            if (c.gen <= -1) continue;
            ((ArrayList)divisions.get(c.gen)).add(c);
        }
        int maximum_frame = this.pngs.size();
        int g = 0;
        while (g <= maxGens) {
            try {
                PrintWriter pw = new PrintWriter(String.valueOf(filename.substring(0, filename.length() - 4)) + "_" + g + ".csv");
                String header = "Frame#";
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Score " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Area " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Mass " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = (Boolean)grew.get(c) != false ? String.valueOf(header) + ",* MM " + c.id : String.valueOf(header) + ",MM " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Compactness " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",X Cell " + c.id;
                }
                for (Cell c : (ArrayList)divisions.get(g)) {
                    header = String.valueOf(header) + ",Y Cell " + c.id;
                }
                pw.println(header);
                int t = 0;
                while (t < maximum_frame) {
                    if (this.debug) {
                        System.err.println(String.valueOf(t) + "/" + maximum_frame);
                    }
                    double[][] data = new double[((ArrayList)divisions.get(g)).size()][7];
                    int count = 0;
                    StringBuilder sb = new StringBuilder(t + 1);
                    for (Cell c : (ArrayList)divisions.get(g)) {
                        if (c.getStats(t) != null) {
                            data[count][0] = c.getStats((int)t).fate_score;
                            data[count][1] = c.getStats((int)t).area;
                            data[count][2] = c.getStats((int)t).mass;
                            data[count][3] = c.getStats((int)t).modeledMass;
                            data[count][4] = c.getStats((int)t).compactness;
                            data[count][5] = c.getStats((int)t).x;
                            data[count][6] = c.getStats((int)t).y;
                        }
                        ++count;
                    }
                    sb.append(t);
                    int i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(String.format("%3.3f", data[i2][0]));
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(data[i2][1]);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(String.format("%3.3f", data[i2][2]));
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(String.format("%3.3f", data[i2][3]));
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(String.format("%3.3f", data[i2][4]));
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(data[i2][5]);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < ((ArrayList)divisions.get(g)).size()) {
                        sb.append(",");
                        sb.append(data[i2][6]);
                        ++i2;
                    }
                    pw.println(sb.toString());
                    this.info("Saved frame " + t + " to " + filename.substring(0, filename.length() - 4) + "_" + g + ".csv");
                    ++t;
                }
                if (this.debug) {
                    System.err.println("Saved division " + g + " containing " + ((ArrayList)divisions.get(g)).size() + " cells and " + maximum_frame + " frames");
                }
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ++g;
        }
    }

    private void saveDistributions(String filename) {
        int i;
        int maxTdie = 0;
        int maxTdiv = 0;
        int maxTdecide = 0;
        int minTdie = 999999;
        int minTdiv = 999999;
        int minTdecide = 999999;
        int maxTR = 0;
        int maxTU = 0;
        int gens = 0;
        ArrayList Tdies = new ArrayList();
        ArrayList Tdivs = new ArrayList();
        ArrayList Tdecides = new ArrayList();
        LinkedList<Cell> wellModeled = new LinkedList<Cell>();
        for (Cell c : this.cells) {
            if (c.gen <= -1 || c.Tdie <= -1 && c.Tdiv <= -1) continue;
            if (c.stats.get(c.Tmin) == null || c.stats.get((Object)Integer.valueOf((int)c.Tmin)).modeledMass == 0.0f) {
                if (c.stats.get(c.Tmin) != null) {
                    c.setModeledMasses2();
                } else if (c.stats.get(c.Tmin) == null) {
                    this.info("A cell has not been tracked... please \"R\"un the tracking from the beginning!");
                    return;
                }
            }
            double normalizedError = 0.0;
            int i2 = c.Tmin;
            while (i2 <= c.Tmax) {
                normalizedError += (double)c.getStats((int)i2).fate_score;
                ++i2;
            }
            if (!((normalizedError /= (double)(c.Tmax - c.Tmin)) < 75.0)) continue;
            wellModeled.add(c);
            int t = c.Tmin + 1;
            boolean foundInflection = false;
            while (t < c.Tmax) {
                if (c.getStats((int)t).modeledMass > c.getStats((int)c.Tmin).modeledMass) {
                    foundInflection = true;
                    break;
                }
                ++t;
            }
            boolean grew = false;
            if ((double)c.getStats((int)c.Tmin).modeledMass * 1.5 < (double)c.getStats((int)c.Tmax).modeledMass) {
                grew = true;
            }
            if (grew && c.Tmax - c.Tmin > maxTR) {
                maxTR = c.Tmax - c.Tmin;
            }
            if (!grew && c.Tmax - c.Tmin > maxTU) {
                maxTU = c.Tmax - c.Tmin;
            }
            if (foundInflection) {
                if (t - c.Tmin > maxTdecide) {
                    maxTdecide = t - c.Tmin;
                }
                if (t - c.Tmin < minTdecide) {
                    minTdecide = t - c.Tmin;
                }
            }
            if (c.Tdie > -1 && c.Tdie - c.Tmin > maxTdie) {
                maxTdie = c.Tdie - c.Tmin;
            }
            if (c.Tdiv > -1 && c.Tdiv - c.Tmin > maxTdiv) {
                maxTdiv = c.Tdiv - c.Tmin;
            }
            if (c.Tdie > -1 && c.Tdie - c.Tmin < minTdie) {
                minTdie = c.Tdie - c.Tmin;
            }
            if (c.Tdiv > -1 && c.Tdiv - c.Tmin < minTdiv) {
                minTdiv = c.Tdiv - c.Tmin;
            }
            if (c.gen <= gens) continue;
            gens = c.gen;
        }
        int i3 = 0;
        while (i3 < gens) {
            Tdies.add(new LinkedList());
            Tdivs.add(new LinkedList());
            Tdecides.add(new LinkedList());
            ++i3;
        }
        int bins = 25;
        int[] responders = new int[gens];
        int[] nonresponders = new int[gens];
        int[][] prTdie = new int[gens][25];
        int[][] prTdiv = new int[gens][25];
        int[][] prTdecide = new int[gens][25];
        int[][] genCells = new int[gens][this.pngs.size()];
        int[] prGrowAndDiv = new int[gens];
        int[] prGrowAndDie = new int[gens];
        int[] prQuiescentAndDiv = new int[gens];
        int[] prQuiescentAndDie = new int[gens];
        FloatList[][] rmasses = new FloatList[gens][maxTR];
        FloatList[][] umasses = new FloatList[gens][maxTU];
        double divBinSize = (double)(maxTdiv - minTdiv) / 25.0;
        double dieBinSize = (double)(maxTdie - minTdie) / 25.0;
        double pBinSize = (double)(maxTdecide - minTdecide) / 25.0;
        for (Cell c : wellModeled) {
            i = c.Tmin;
            while (i <= c.Tmax) {
                int[] nArray = genCells[c.gen];
                int n = i++;
                nArray[n] = nArray[n] + 1;
            }
            boolean died = false;
            boolean divided = false;
            boolean responded = false;
            if (c.Tdie != -1) {
                ((LinkedList)Tdies.get(c.gen)).add(c.Tdie - c.Tmin);
                died = true;
            }
            if (c.Tdiv != -1) {
                ((LinkedList)Tdivs.get(c.gen)).add(c.Tdiv - c.Tmin);
                divided = true;
            }
            int t = c.Tmin + 1;
            while (t < c.Tmax) {
                if (c.getStats((int)t).modeledMass > c.getStats((int)c.Tmin).modeledMass) {
                    ((LinkedList)Tdecides.get(c.gen)).add(t - c.Tmin);
                    break;
                }
                ++t;
            }
            if ((double)c.getStats((int)c.Tmin).modeledMass * 1.5 < (double)c.getStats((int)c.Tmax).modeledMass) {
                responded = true;
            }
            if (responded) {
                int n = c.gen;
                responders[n] = responders[n] + 1;
                if (divided) {
                    int[] nArray = prTdiv[c.gen];
                    int n2 = (int)((double)(c.Tdiv - c.Tmin - minTdiv) / divBinSize);
                    nArray[n2] = nArray[n2] + 1;
                    int n3 = c.gen;
                    prGrowAndDiv[n3] = prGrowAndDiv[n3] + 1;
                }
                if (died) {
                    int[] nArray = prTdie[c.gen];
                    int n4 = (int)((double)(c.Tdie - c.Tmin - minTdie) / dieBinSize);
                    nArray[n4] = nArray[n4] + 1;
                    int n5 = c.gen;
                    prGrowAndDie[n5] = prGrowAndDie[n5] + 1;
                }
                int[] nArray = prTdecide[c.gen];
                int n6 = (int)((double)(t - c.Tmin - minTdecide) / pBinSize);
                nArray[n6] = nArray[n6] + 1;
            } else {
                int n = c.gen;
                nonresponders[n] = nonresponders[n] + 1;
                if (divided) {
                    int[] nArray = prTdiv[c.gen];
                    int n7 = (int)((double)(c.Tdiv - c.Tmin - minTdiv) / divBinSize);
                    nArray[n7] = nArray[n7] + 1;
                    int n8 = c.gen;
                    prQuiescentAndDiv[n8] = prQuiescentAndDiv[n8] + 1;
                }
                if (died) {
                    int[] nArray = prTdie[c.gen];
                    int n9 = (int)((double)(c.Tdie - c.Tmin - minTdie) / dieBinSize);
                    nArray[n9] = nArray[n9] + 1;
                    int n10 = c.gen;
                    prQuiescentAndDie[n10] = prQuiescentAndDie[n10] + 1;
                }
            }
            float startmass = c.getStats((int)c.Tmin).modeledMass;
            int i4 = c.Tmin;
            while (i4 <= c.Tmax) {
                float mass = c.getStats((int)i4).modeledMass;
                if (responded) {
                    rmasses[c.gen][i4 - c.Tmin].list.add(Float.valueOf(mass / startmass));
                } else {
                    umasses[c.gen][i4 - c.Tmin].list.add(Float.valueOf(mass / startmass));
                }
                ++i4;
            }
        }
        try {
            PrintWriter pw = new PrintWriter(filename);
            String header = "Frame";
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",TdivGen" + i;
                ++i;
            }
            header = String.valueOf(header) + ",Frame";
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",TdieGen" + i;
                ++i;
            }
            header = String.valueOf(header) + ",Frame";
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",TdecideGen" + i;
                ++i;
            }
            header = String.valueOf(header) + ",Frame";
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",#CellsGen" + i;
                ++i;
            }
            header = String.valueOf(header) + ",TotalCells,Frame";
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",MassRGen" + i;
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",MassUGen" + i;
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",MassSDRGen" + i;
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",MassSDUGen" + i;
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",TdivsGen" + i;
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",TdiesGen" + i;
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",PrRespondGen" + i + "," + (double)responders[i] / (double)(responders[i] + nonresponders[i]);
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",PrQuiescentGen" + i + "," + (double)nonresponders[i] / (double)(responders[i] + nonresponders[i]);
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",PrGrowAndDivGen" + i + "," + (double)prGrowAndDiv[i] / (double)responders[i];
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",PrGrowAndDieGen" + i + "," + (double)prGrowAndDie[i] / (double)responders[i];
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",PrQuiescentAndDivGen" + i + "," + (double)prQuiescentAndDiv[i] / (double)nonresponders[i];
                ++i;
            }
            i = 0;
            while (i < gens) {
                header = String.valueOf(header) + ",PrQuiescentAndDieGen" + i + "," + (double)prQuiescentAndDie[i] / (double)nonresponders[i];
                ++i;
            }
            pw.println(header);
            int rows = Math.max(25, Math.max(this.pngs.size(), wellModeled.size()));
            int r = 0;
            while (r < rows) {
                String str = "" + ((double)minTdiv + (double)r * divBinSize);
                int i5 = 0;
                while (i5 < gens) {
                    try {
                        str = String.valueOf(str) + "," + (double)prTdiv[i5][r] / (double)((LinkedList)Tdivs.get(i5)).size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i5;
                }
                str = "," + ((double)minTdie + (double)r * dieBinSize);
                i5 = 0;
                while (i5 < gens) {
                    try {
                        str = String.valueOf(str) + "," + (double)prTdie[i5][r] / (double)((LinkedList)Tdies.get(i5)).size();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i5;
                }
                str = "," + ((double)minTdecide + (double)r * pBinSize);
                i5 = 0;
                while (i5 < gens) {
                    try {
                        str = String.valueOf(str) + "," + (double)prTdecide[i5][r] / (double)responders[i5];
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i5;
                }
                str = String.valueOf(str) + "," + r;
                int totalCells = 0;
                int i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + genCells[i6][r];
                        totalCells += genCells[i6][r];
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                str = String.valueOf(str) + "," + totalCells;
                str = String.valueOf(str) + "," + r;
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + rmasses[i6][r].getAvg();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + umasses[i6][r].getAvg();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + rmasses[i6][r].getSD();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < gens) {
                    try {
                        str = String.valueOf(str) + "," + umasses[i6][r].getSD();
                    }
                    catch (Exception e) {
                        str = String.valueOf(str) + ",";
                    }
                    ++i6;
                }
                try {
                    str = String.valueOf(str) + "," + Tdivs.get(r);
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                try {
                    str = String.valueOf(str) + "," + Tdies.get(r);
                }
                catch (Exception e) {
                    str = String.valueOf(str) + ",";
                }
                pw.println(str);
                ++r;
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.info("Saved statistics to file " + filename);
    }

    public static void main(String[] args) {
        new Tracker();
    }

    private class FComparator
    implements Comparator<File> {
        private FComparator() {
        }

        @Override
        public int compare(File arg0, File arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    private class FloatList {
        LinkedList<Float> list = new LinkedList();

        private FloatList() {
        }

        public float getAvg() {
            float avg = 0.0f;
            java.util.Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                avg += f;
            }
            return avg / (float)this.list.size();
        }

        public float getSD() {
            float avg = this.getAvg();
            float sd = 0.0f;
            java.util.Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                sd = (float)((double)sd + Math.pow(f - avg, 2.0));
            }
            return (float)Math.sqrt(sd / (float)this.list.size());
        }
    }

    private class Iterator
    extends Thread {
        LinkedList<Cell> group;
        int t = 0;
        HashMap<Cell, HashSet<Cell>> nearbys;
        boolean changing = true;

        public Iterator(LinkedList<Cell> group, int t, HashMap<Cell, HashSet<Cell>> nearbys) {
            this.group = group;
            this.t = t;
            this.nearbys = nearbys;
            this.start();
        }

        @Override
        public void run() {
            while (this.changing) {
                this.changing = false;
                for (Cell c : this.group) {
                    int result;
                    Waypoint wp = c.getWaypointAt(this.t);
                    double d = Math.pow(wp.x1 - wp.x2, 2.0) + Math.pow(wp.y1 - wp.y2, 2.0) * (double)(wp.end - wp.start) / 10.0;
                    if (wp == null || (result = c.iterate(gradient, (Collection<Cell>)this.nearbys.get(c), this.t, wp.getPoint(this.t), 1.0 / (1.0 + d))) != 1) continue;
                    this.changing = true;
                }
            }
        }
    }

    private class Preparer
    extends Thread {
        LinkedList<Cell> group;
        int t = 0;

        public Preparer(LinkedList<Cell> group, int t) {
            this.group = group;
            this.t = t;
            this.start();
        }

        @Override
        public void run() {
            for (Cell c : this.group) {
                DoublePoint position = c.getWaypointPosition(Tracker.this.index);
                c.prepareOptimizationNoSpots(this.t, gradient, position);
            }
        }
    }
}

